-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;
with JPATS_IOS_Interface;

package JPATS_Visual_Models.Ios_IF is


-- Access The_Air_Traffic
   procedure Set_Air_Traffic (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Ground_Traffic
   procedure Set_Ground_Traffic (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Ramp_Traffic
   procedure Set_Ramp_Traffic (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Ground_Hazard_On
   procedure Set_Ground_Hazard_On (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Ground_Hazard_Off
   procedure Set_Ground_Hazard_Off (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Ground_Hazard_Type
   procedure Set_Ground_Hazard_Type (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Ground_Hazard_Path
   procedure Set_Ground_Hazard_Path (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Ground_Hazard_Pause
   procedure Set_Ground_Hazard_Pause (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access FF_Test
   procedure Set_Ff_Test (Pdata : in JPATS_IOS_Interface.Set_Value);

   -- "Set" procedures to be used only by the IOS
   procedure Set_Threat_Page_Start_Button_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Start_Button_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Aircraft_Type_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Aircraft_Type_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Bearing_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Bearing_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Distance_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Distance_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Altitude_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Altitude_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Time_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Time_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Vert_Pos_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Vert_Pos_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Speed_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Speed_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Closure_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Page_Closure_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Scenario_1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Threat_Scenario_2(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Register_Ios_Variables;

end JPATS_Visual_Models.Ios_IF;
