-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models.Container;
with Jpats_Ios_Interface;

package body JPATS_Visual_Models.Ios_IF is

   package Jat renames Jpats_Avionics_Types;
   Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;

   Temp_Int : Integer;

-- Access The_Air_Traffic
   procedure Set_Air_Traffic
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Air_Traffic :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Air_Traffic_Was_Set := True;
   end Set_Air_Traffic;

-- Access The_Ground_Traffic
   procedure Set_Ground_Traffic
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Ground_Traffic :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Ground_Traffic_Was_Set := True;
   end Set_Ground_Traffic;

-- Access The_Ramp_Traffic
   procedure Set_Ramp_Traffic
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Ramp_Traffic :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Ramp_Traffic_Was_Set := True;
   end Set_Ramp_Traffic;

-- Access The_Ground_Hazard_On
   procedure Set_Ground_Hazard_On
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Ground_Hazard_On :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Ground_Hazard_On_Was_Set := True;
   end Set_Ground_Hazard_On;

-- Access The_Ground_Hazard_Off
   procedure Set_Ground_Hazard_Off
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Ground_Hazard_Off :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Ground_Hazard_Off_Was_Set := True;
   end Set_Ground_Hazard_Off;

-- Access The_Ground_Hazard_Type
   procedure Set_Ground_Hazard_Type
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Ground_Hazard_Type :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Ground_Hazard_Type_Was_Set := True;
   end Set_Ground_Hazard_Type;

-- Access The_Ground_Hazard_Path
   procedure Set_Ground_Hazard_Path
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Ground_Hazard_Path :=
        Jpats_Ios_Interface.Convert_To_Integer(Pdata);
      Container.This_Ios_Interface.Ground_Hazard_Path_Was_Set := True;
   end Set_Ground_Hazard_Path;

-- Access The_Ground_Hazard_Pause
   procedure Set_Ground_Hazard_Pause
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Ground_Hazard_Pause :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Ground_Hazard_Pause_Was_Set := True;
   end Set_Ground_Hazard_Pause;

-- Access Ff_Test
   procedure Set_Ff_Test
     (Pdata : in JPATS_IOS_Interface.Set_Value) is
   begin
      Container.This_Ios_Interface.Ff_Test :=
        Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Container.This_Ios_Interface.Ff_Test_Was_Set := True;
   end Set_Ff_Test;

   procedure Set_Threat_Page_Start_Button_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Start_Button(1) :=
        JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Threat_Page_Start_Button_1;

   procedure Set_Threat_Page_Start_Button_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Start_Button(2) :=
        JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Threat_Page_Start_Button_2;

   procedure Set_Threat_Page_Aircraft_Type_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Temp_Int := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Threat_Page_Aircraft_Type(1) := Jat.Aircraft_Type'Val(Temp_Int);
      Ios.Threat_Page_Aircraft_Type_Was_Set(1) := True;
   end Set_Threat_Page_Aircraft_Type_1;

   procedure Set_Threat_Page_Aircraft_Type_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Temp_Int := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Threat_Page_Aircraft_Type(2) := Jat.Aircraft_Type'Val(Temp_Int);
      Ios.Threat_Page_Aircraft_Type_Was_Set(2) := True;
   end Set_Threat_Page_Aircraft_Type_2;

   procedure Set_Threat_Page_Bearing_1( pData : JPATS_IOS_Interface.Set_Value ) is

   begin
      IOS.Threat_Page_Bearing(1) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Bearing_Was_Set(1) := True;
   end Set_Threat_Page_Bearing_1;

   procedure Set_Threat_Page_Bearing_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Bearing(2) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Bearing_Was_Set(2) := True;
   end Set_Threat_Page_Bearing_2;

   procedure Set_Threat_Page_Distance_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Distance(1) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Distance_Was_Set(1) := True;
   end Set_Threat_Page_Distance_1;

   procedure Set_Threat_Page_Distance_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Distance(2) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Distance_Was_Set(2) := True;
   end Set_Threat_Page_Distance_2;

   procedure Set_Threat_Page_Altitude_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Altitude(1) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Altitude_Was_Set(1) := True;
   end Set_Threat_Page_Altitude_1;

   procedure Set_Threat_Page_Altitude_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Altitude(2) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Altitude_Was_Set(2) := True;
   end Set_Threat_Page_Altitude_2;

   procedure Set_Threat_Page_Time_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Time(1) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Time_Was_Set(1) := True;
   end Set_Threat_Page_Time_1;

   procedure Set_Threat_Page_Time_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Time(2) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Time_Was_Set(2) := True;
   end Set_Threat_Page_Time_2;

   procedure Set_Threat_Page_Vert_Pos_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Temp_Int := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Threat_Page_Vert_Pos(1) := Jat.Vertical_Type'Val(Temp_Int);
      Ios.Threat_Page_Vert_Pos_Was_Set(1) := True;
   end Set_Threat_Page_Vert_Pos_1;

   procedure Set_Threat_Page_Vert_Pos_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Temp_Int := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Threat_Page_Vert_Pos(2) := Jat.Vertical_Type'Val(Temp_Int);
      Ios.Threat_Page_Vert_Pos_Was_Set(2) := True;
   end Set_Threat_Page_Vert_Pos_2;

   procedure Set_Threat_Page_Speed_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Speed(1) := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Speed_Was_Set(1) := True;
   end Set_Threat_Page_Speed_1;

   procedure Set_Threat_Page_Speed_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Speed(2) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Speed_Was_Set(2) := True;
   end Set_Threat_Page_Speed_2;

   procedure Set_Threat_Page_Closure_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Closure(1) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Closure_Was_Set(1) := True;
   end Set_Threat_Page_Closure_1;

   procedure Set_Threat_Page_Closure_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Page_Closure(2) :=
        JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Threat_Page_Closure_Was_Set(2) := True;
   end Set_Threat_Page_Closure_2;

   procedure Set_Threat_Scenario_1( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Scenario(1) :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Threat_Scenario_Was_Set(1) := True;
   end Set_Threat_Scenario_1;

   procedure Set_Threat_Scenario_2( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Threat_Scenario(2) :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Threat_Scenario_Was_Set(2) := True;
   end Set_Threat_Scenario_2;

   procedure Register_Ios_Variables  is
   begin
      JPATS_IOS_Interface.Register
        (Name          => "Air_Traffic",
         Variable      => IOS.Air_Traffic'address,
         Set_Routine   => Set_Air_Traffic'access );

      JPATS_IOS_Interface.Register
      (Name          => "Ground_Traffic",
       Variable      => IOS.Ground_Traffic'address,
       Set_Routine   => Set_Ground_Traffic'access );

      JPATS_IOS_Interface.Register
        (Name          => "Ramp_Traffic",
         Variable      => IOS.Ramp_Traffic'address,
         Set_Routine   => Set_Ramp_Traffic'access );

      JPATS_IOS_Interface.Register
        (Name          => "Ground_Hazard_On",
         Variable      => IOS.Ground_Hazard_On'address,
         Set_Routine   => Set_Ground_Hazard_On'access );

      JPATS_IOS_Interface.Register
        (Name          => "Ground_Hazard_Off",
         Variable      => IOS.Ground_Hazard_Off'address,
         Set_Routine   => Set_Ground_Hazard_Off'access );

      JPATS_IOS_Interface.Register
        (Name          => "Ground_Hazard_Type",
         Variable      => IOS.Ground_Hazard_Type'address,
         Set_Routine   => Set_Ground_Hazard_Type'access );

      JPATS_IOS_Interface.Register
        (Name          => "Ground_Hazard_Path",
         Variable      => IOS.Ground_Hazard_Path'address,
         Set_Routine   => Set_Ground_Hazard_Path'access );

      JPATS_IOS_Interface.Register
        (Name          => "Ground_Hazard_Pause",
         Variable      => IOS.Ground_Hazard_Pause'address,
         Set_Routine   => Set_Ground_Hazard_Pause'access );

      JPATS_IOS_Interface.Register
        (Name          => "Ff_Test",
         Variable      => IOS.Ff_Test'address,
         Set_Routine   => Set_Ff_Test'access );

      JPATS_IOS_Interface.Register
        (Name          => "Ff_Test_Lat",
         Variable      => Ios.Ff_Test_Lat'Address
         );

      JPATS_IOS_Interface.Register
        (Name          => "Ff_Test_Lon",
         Variable      => Ios.Ff_Test_Lon'Address
         );

      JPATS_IOS_Interface.Register
        (Name          => "Ff_Test_Hdg",
         Variable      => Ios.Ff_Test_Hdg'Address
         );

      JPATS_IOS_Interface.Register
        (Name          => "Ff_Test_Alt",
         Variable      => Ios.Ff_Test_Alt'Address
         );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Start_Button_1",
         Variable      => IOS.Threat_Page_Start_Button(1)'address,
         Set_Routine   => Set_Threat_Page_Start_Button_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Start_Button_2",
         Variable      => IOS.Threat_Page_Start_Button(2)'address,
         Set_Routine   => Set_Threat_Page_Start_Button_2'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Aircraft_Type_1",
         Variable      => IOS.Threat_Page_Aircraft_Type(1)'address,
         Set_Routine   => Set_Threat_Page_Aircraft_Type_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Aircraft_Type_2",
         Variable      => IOS.Threat_Page_Aircraft_Type(2)'address,
         Set_Routine   => Set_Threat_Page_Aircraft_Type_2'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Bearing_1",
         Variable      => IOS.Threat_Page_Bearing(1)'address,
         Set_Routine   => Set_Threat_Page_Bearing_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Bearing_2",
         Variable      => IOS.Threat_Page_Bearing(2)'address,
         Set_Routine   => Set_Threat_Page_Bearing_2'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Distance_1",
         Variable      => IOS.Threat_Page_Distance(1)'address,
         Set_Routine   => Set_Threat_Page_Distance_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Distance_2",
         Variable      => IOS.Threat_Page_Distance(2)'address,
         Set_Routine   => Set_Threat_Page_Distance_2'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Altitude_1",
         Variable      => IOS.Threat_Page_Altitude(1)'address,
         Set_Routine   => Set_Threat_Page_Altitude_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Altitude_2",
         Variable      => IOS.Threat_Page_Altitude(2)'address,
         Set_Routine   => Set_Threat_Page_Altitude_2'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Time_1",
         Variable      => IOS.Threat_Page_Time(1)'address,
         Set_Routine   => Set_Threat_Page_Time_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Time_2",
         Variable      => IOS.Threat_Page_Time(2)'address,
         Set_Routine   => Set_Threat_Page_Time_2'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Vert_Pos_1",
         Variable      => IOS.Threat_Page_Vert_Pos(1)'address,
         Set_Routine   => Set_Threat_Page_Vert_Pos_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Vert_Pos_2",
         Variable      => IOS.Threat_Page_Vert_Pos(2)'address,
         Set_Routine   => Set_Threat_Page_Vert_Pos_2'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Speed_1",
         Variable      => IOS.Threat_Page_Speed(1)'address,
         Set_Routine   => Set_Threat_Page_Speed_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Speed_2",
         Variable      => IOS.Threat_Page_Speed(2)'address,
         Set_Routine   => Set_Threat_Page_Speed_2'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Closure_1",
         Variable      => IOS.Threat_Page_Closure(1)'address,
         Set_Routine   => Set_Threat_Page_Closure_1'access );


      JPATS_IOS_Interface.Register
        (Name          => "Nacws_Page_Closure_2",
         Variable      => IOS.Threat_Page_Closure(2)'address,
         Set_Routine   => Set_Threat_Page_Closure_2'access );

      JPATS_IOS_Interface.Register
        (Name          => "Threat_Scenario_1",
         Variable      => IOS.Threat_Scenario(1)'address,
         Set_Routine   => Set_Threat_Scenario_1'access );

      JPATS_IOS_Interface.Register
        (Name          => "Threat_Scenario_2",
         Variable      => IOS.Threat_Scenario(2)'address,
         Set_Routine   => Set_Threat_Scenario_2'access );

   end Register_Ios_Variables;


end JPATS_Visual_Models.Ios_IF;
