-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;
with Jpats_Avionics_Types;
with Moving_Models.Position.Cloud_Model;
with Moving_Models.Position.Storm_Model;
with Moving_Models.Position.Host_Hazard;
with Moving_Models.Air_Hazard;
with Moving_Models.Ground_Hazard;
with Traffic_Model;
with Jpats_Avionics_Types;
with Threat_Control;

private package JPATS_Visual_Models.Container is

   package Jat renames Jpats_Avionics_Types;

   type Host_Hazard_Array is array (1..10)
     of Moving_Models.Position.Host_Hazard.Instance;
   type Storm_Model_Array is array (1..5)
     of Moving_Models.Position.Storm_Model.Instance;
   type Cloud_Model_Array is array (1..2)
     of Moving_Models.Position.Cloud_Model.Instance;
   type Model_Number_Array is array
     (Jpats_Avionics_Types.Aircraft_Type'Range) of Integer;

   type JPATS_Formation_Model is new
     Moving_Models.Position.Host_Hazard.Instance with
      record
         Flap_Position : Float;
         Speed_Brake_Position : Float;
         Gear_Position : Float;
      end record;

   type Instance is record
      The_Cloud_Model : Cloud_Model_Array;
      The_Storm_Model : Storm_Model_Array;
      The_Host_Hazard : Host_Hazard_Array;
      The_Air_Hazard : Moving_Models.Air_Hazard.Instance;
      The_Ground_Hazard : Moving_Models.Ground_Hazard.Instance;
      The_Traffic_Model : Traffic_Model.Instance;
      The_Formation_Model : Moving_Models.Position.Host_Hazard.Instance;
      The_Intruder_Drive       :
        JPATS_Avionics_Types.Intruder_Drive_Array_Type;
      The_Threat_Control : Threat_Control.Instance;
   end record;

  This_Subsystem : Instance;

  Model_Number_List : Model_Number_Array :=
    (Jpats_Avionics_Types.T6a_Navy => 1015,
     Jpats_Avionics_Types.T6a_AF => 1012,
     Jpats_Avionics_Types.Fuel_Truck => 11,
     Jpats_Avionics_Types.Fire_Truck => 27,
     Jpats_Avionics_Types.Pickup => 28,
     Jpats_Avionics_Types.Tow_Tug => 38,
     Jpats_Avionics_Types.Cessna => 22,
     Jpats_Avionics_Types.Ch_601 => 23,
     Jpats_Avionics_Types.King_Air => 1030,
     Jpats_Avionics_Types.F16 => 1028,
     Jpats_Avionics_Types.T1a => 1025,
     Jpats_Avionics_Types.T6b_Navy => 1023,
     Jpats_Avionics_Types.Kc10 => 1026,
     Jpats_Avionics_Types.Bell_407 => 1019,
     Jpats_Avionics_Types.Crop_Duster => 3107,
     Jpats_Avionics_Types.F15 => 4030,
     Jpats_Avionics_Types.Kc135 => 4073,
     Jpats_Avionics_Types.T38 => 4015,
     Jpats_Avionics_Types.Fire_T_Red => 1018,
     Jpats_Avionics_Types.Follow => 7033,
     Jpats_Avionics_Types.Fuel_Short => 7045,
     Jpats_Avionics_Types.Fuel_Long => 7030,
     Jpats_Avionics_Types.Humv => 7044,
     Jpats_Avionics_Types.Tank_Grn => 8019,
     Jpats_Avionics_Types.Tank_Tan => 8037,
     Jpats_Avionics_Types.Tank_Wht => 8043,
     Jpats_Avionics_Types.Truck_Grn => 7026,
     Jpats_Avionics_Types.Truck_Tan => 7027,
     Jpats_Avionics_Types.Truck_Wht => 7028,
     Jpats_Avionics_Types.Su25 => 5003,
     Jpats_Avionics_Types.Su35 => 5060,
     Jpats_Avionics_Types.Tu95 => 5034);

  Ground_Model_Number_List : Model_Number_Array :=
    (Jpats_Avionics_Types.T6a_Navy => 1005,
     Jpats_Avionics_Types.T6a_AF => 1002,
     Jpats_Avionics_Types.Fuel_Truck => 11,
     Jpats_Avionics_Types.Fire_Truck => 27,
     Jpats_Avionics_Types.Pickup => 28,
     Jpats_Avionics_Types.Tow_Tug => 38,
     Jpats_Avionics_Types.Cessna => 22,
     Jpats_Avionics_Types.Ch_601 => 23,
     Jpats_Avionics_Types.King_Air => 1029,
     Jpats_Avionics_Types.F16 => 1027,
     Jpats_Avionics_Types.T1a => 1024,
     Jpats_Avionics_Types.T6b_Navy => 1021,
     Jpats_Avionics_Types.Kc10 => 1026,
     Jpats_Avionics_Types.Bell_407 => 1019,
     Jpats_Avionics_Types.Crop_Duster => 3107,
     Jpats_Avionics_Types.F15 => 4030,
     Jpats_Avionics_Types.Kc135 => 4073,
     Jpats_Avionics_Types.T38 => 1034,
     Jpats_Avionics_Types.Fire_T_Red => 1018,
     Jpats_Avionics_Types.Follow => 7033,
     Jpats_Avionics_Types.Fuel_Short => 7045,
     Jpats_Avionics_Types.Fuel_Long => 7030,
     Jpats_Avionics_Types.Humv => 7044,
     Jpats_Avionics_Types.Tank_Grn => 8019,
     Jpats_Avionics_Types.Tank_Tan => 8037,
     Jpats_Avionics_Types.Tank_Wht => 8043,
     Jpats_Avionics_Types.Truck_Grn => 7026,
     Jpats_Avionics_Types.Truck_Tan => 7027,
     Jpats_Avionics_Types.Truck_Wht => 7028,
     Jpats_Avionics_Types.Su25 => 5003,
     Jpats_Avionics_Types.Su35 => 5060,
     Jpats_Avionics_Types.Tu95 => 5034);

  type Ios_Interface_Instance is record
     Air_Traffic : Boolean;
     Ground_Traffic : Boolean;
     Ramp_Traffic : Boolean;
     Ground_Hazard_On : Boolean;
     Ground_Hazard_Off : Boolean;
     Ground_Hazard_Type : Integer;
     Ground_Hazard_Path : Integer;
     Ground_Hazard_Pause : Boolean;
     Ff_Test : Boolean;
     Ff_Test_Lat : Long_Float;
     Ff_Test_Lon : Long_Float;
     Ff_Test_Hdg : Float;
     Ff_Test_Alt : Float;
     Threat_Page_Start_Button  : Jat.Ios_Boolean_Type;
     Threat_Page_Aircraft_Type : Jat.Ios_Aircraft_Type;
     Threat_Page_Bearing       : Jat.Ios_Float_Type;
     Threat_Page_Distance      : Jat.Ios_Float_Type;
     Threat_Page_Altitude      : Jat.Ios_Float_Type;
     Threat_Page_Time          : Jat.Ios_Float_Type;
     Threat_Page_Vert_Pos      : Jat.Ios_Vertical_Type;
     Threat_Page_Speed         : Jat.Ios_Float_Type;
     Threat_Page_Closure       : Jat.Ios_Float_Type;
     Threat_Scenario           : Jat.Ios_Integer_Type;

     Air_Traffic_Was_Set : Boolean;
     Ground_Traffic_Was_Set : Boolean;
     Ramp_Traffic_Was_Set : Boolean;
     Ground_Hazard_On_Was_Set : Boolean;
     Ground_Hazard_Off_Was_Set : Boolean;
     Ground_Hazard_Type_Was_Set : Boolean;
     Ground_Hazard_Path_Was_Set : Boolean;
     Ground_Hazard_Pause_Was_Set : Boolean;
     Ff_Test_Was_Set : Boolean;
     Threat_Page_Aircraft_Type_Was_Set : Jat.Ios_Boolean_Type;
     Threat_Page_Bearing_Was_Set       : Jat.Ios_Boolean_Type;
     Threat_Page_Distance_Was_Set      : Jat.Ios_Boolean_Type;
     Threat_Page_Altitude_Was_Set      : Jat.Ios_Boolean_Type;
     Threat_Page_Time_Was_Set          : Jat.Ios_Boolean_Type;
     Threat_Page_Vert_Pos_Was_Set      : Jat.Ios_Boolean_Type;
     Threat_Page_Speed_Was_Set         : Jat.Ios_Boolean_Type;
     Threat_Page_Closure_Was_Set       : Jat.Ios_Boolean_Type;
     Threat_Scenario_Was_Set           : Jat.Ios_Boolean_Type;

  end record;

  This_Ios_Interface : Ios_Interface_Instance;

end JPATS_Visual_Models.Container;
