-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package Jpats_Visual_Buffer_Types is

    subtype Visual_IF_Intensity is Integer range 0..5;
    type Unsigned_Int is mod 4294967296;
    type Buffer_Array is array (Positive range <>) of Unsigned_Int;

    type Block_Array is array (Positive range <>) of Unsigned_Int;
    subtype Runway_Name_Type is string (1..4);
    subtype Airport_Name_Type is string (1..4);
    subtype Test_Name_String is String (1..8);
    type Material_Enum is (Undefined, Metal, Part_Metal, Brick, Composition,
                           Earthen_Works, Water, Sand, Rock, Concrete, Soil,
                           Marsh, Trees, Snow_Ice, Asphalt, Spare1, Spare2,
                           Spare3, Spare4, Spare5, Spare6, Spare7, Spare8,
                           Spare9, Spare10, Spare11, Spare12, Spare13, Slush,
                           Ice, Snow, Wet_Tiremarks);
    type Hot_Long_Float_Array is array (1..4) of Long_Float;
    type Hot_Float_Array is array (1..4) of Float;
    type Hot_Int_Array is array (1..4) of Integer;
    type Hot_Bool_Array is array (1..4) of Boolean;
    type Hot_Enum_Array is array (1..4) of Material_Enum;
    type Steerable_Light_Array is array (1..8) of Float;

    Bams_16bit : constant := 182.04444444;        --2^15 / 180
    Bams_22bit : constant := 512.0;               --2^9
    Bams_32bit : constant := 11930464.71;         --2^31 / 180
    Sb0_Scale : constant :=  32768.0;             --2^15
    Sb1_Scale : constant :=  182.04444444;        --2^15 / 180
    Sb15_Scale : constant := 131072.0;            --2^17
    Sb16_Scale : constant := 65536.0;             --2^16
    Sb23_Scale : constant := 256.0;               --2^8
    Sb0_32bit_Scale : constant := 2147483648.0;   --2^31
    Sb1_32bit_Scale : constant := 11930464.71;    --2^31 / 180
    Sb1_24bit_Scale : constant := 8388608.0;      --2^23
    Sb1_20bit_Scale : constant := 524288.0;       --2^19
    Ub24_Scale : constant := 256.0;               --2^8
    Ub1_32bit_Scale : constant := 23860929.42;    --2^32 / 180
    Ub1_24bit_Scale : constant := 93206.755555;   --2^24 / 180

end Jpats_Visual_Buffer_Types;


