-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;

package JPATS_Visual_Buffer is

-- Ownship Return Functions
   function Fuselage_Collision return Boolean;
   function Right_Wing_Collision return Boolean;
   function Left_Wing_Collision return Boolean;
   function Video_On return Boolean;
   function Cloud_Type_Penetrated return Integer;

-- Height of Terrain Return
   function Hot_Data_Valid (A_Point : in Integer) return Boolean;
   function Material_Code_Valid (A_Point : in Integer) return Boolean;
   function Height_Of_Terrain (A_Point : in Integer) return Float;
   function Material_Code (A_Point : in Integer)
                           return Jpats_Visual_Buffer_Types.Material_Enum;
   function Contaminant_Value (A_Point : in Integer)
                              return Integer;
   function Contaminant_Material_Code
     (A_Point : in Integer)
      return Jpats_Visual_Buffer_Types.Material_Enum;
   function Aircraft_On_Runway (A_Point : in Integer) return Boolean;
   function Average_Terrain_Height return Float;

-- Lightning Return
   function Lightning_Latitude return Long_Float;
   function Lightning_Longitude return Long_Float;
   function Lightning_Id return Integer;


end JPATS_Visual_Buffer;
