-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Data_Block.Ownship_Return;
with Data_Block.Hot_Return;
with Data_Block.Lightning_Return;
with Jpats_Visual_Buffer.Fast_Data_Container;

package body JPATS_Visual_Buffer is

-- Ownship Return Functions
   function Fuselage_Collision
     return Boolean is
   begin
      return Data_Block.Ownship_Return.Fuselage_Collision
        (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return);
   end Fuselage_Collision;

   function Right_Wing_Collision
     return Boolean is
   begin
      return Data_Block.Ownship_Return.Right_Wing_Collision
        (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return);
   end Right_Wing_Collision;

   function Left_Wing_Collision
     return Boolean is
   begin
      return Data_Block.Ownship_Return.Left_Wing_Collision
        (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return);
   end Left_Wing_Collision;

   function Video_On
     return Boolean is
   begin
      return Data_Block.Ownship_Return.Video_On
        (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return);
   end Video_On;

   function Cloud_Type_Penetrated
     return Integer is
   begin
      return Data_Block.Ownship_Return.Cloud_Type_Penetrated
        (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return);
   end Cloud_Type_Penetrated;

-- Height of Terrain Return
   function Hot_Data_Valid
     (A_Point : in Integer)
      return Boolean is
   begin
      return Data_Block.Hot_Return.Data_Valid
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return, A_Point);
   end Hot_Data_Valid;

   function Material_Code_Valid
     (A_Point : in Integer)
      return Boolean is
   begin
      return Data_Block.Hot_Return.Material_Code_Valid
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return, A_Point);
   end Material_Code_Valid;

   function Height_Of_Terrain
     (A_Point : in Integer)
      return Float is
   begin
      return Data_Block.Hot_Return.Height_Of_Terrain
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return, A_Point);
   end Height_Of_Terrain;

   function Material_Code
     (A_Point : in Integer)
      return Jpats_Visual_Buffer_Types.Material_Enum is
   begin
      return Data_Block.Hot_Return.Material_Code
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return, A_Point);
   end Material_Code;

   function Contaminant_Value
     (A_Point : in Integer)
      return Integer is
   begin
      return Data_Block.Hot_Return.Contaminant_Value
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return, A_Point);
   end Contaminant_Value;

   function Contaminant_Material_Code
     (A_Point : in Integer)
      return Jpats_Visual_Buffer_Types.Material_Enum is
   begin
      return Data_Block.Hot_Return.Contaminant_Material_Code
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return, A_Point);
   end Contaminant_Material_Code;

   function Aircraft_On_Runway
     (A_Point : in Integer)
     return Boolean is
   begin
      return Data_Block.Hot_Return.Aircraft_On_Runway
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return, A_Point);
   end Aircraft_On_Runway;

   function Average_Terrain_Height
     return Float is
   begin
      return Data_Block.Hot_Return.Terrain_Height
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return);
   end Average_Terrain_Height;

-- Lightning Return
   function Lightning_Latitude
     return Long_Float is
   begin
      return Data_Block.Lightning_Return.Latitude
        (Fast_Data_Container.This_Receive_Subsystem.The_Lightning_Return);
   end Lightning_Latitude;

   function Lightning_Longitude
     return Long_Float is
   begin
      return Data_Block.Lightning_Return.Longitude
        (Fast_Data_Container.This_Receive_Subsystem.The_Lightning_Return);
   end Lightning_Longitude;

   function Lightning_Id
     return Integer is
   begin
      return Data_Block.Lightning_Return.Lightning_Id
        (Fast_Data_Container.This_Receive_Subsystem.The_Lightning_Return);
   end Lightning_Id;


end JPATS_Visual_Buffer;
