-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block.System_Features;
with Data_Block.Airport_Control;
with Data_Block.Celestial_Control;
with Data_Block.Runway_Control;
with Data_Block.Atmosphere_Control;
with Data_Block.Config_Apt_Cntl;
with Data_Block.Test_Pattern;

private package JPATS_Visual_Buffer.Slow_Data_Container is

   type Slow_Send_Instance is record
      The_System_Features : Data_Block.System_Features.Instance;
      The_Airport_Control : Data_Block.Airport_Control.Instance;
      The_Celestial_Control : Data_Block.Celestial_Control.Instance;
      The_Runway_Control : Data_Block.Runway_Control.Instance;
      The_Atmosphere_Control : Data_Block.Atmosphere_Control.Instance;
      The_Config_Apt_Cntl : Data_Block.Config_Apt_Cntl.Instance;
      The_Test_Pattern : Data_Block.Test_Pattern.Instance;
   end record;

   This_Slow_Send_Subsystem : Slow_Send_Instance;

   type Ios_Interface_Instance is record
      Video_On : Boolean;
      Host_Buffer_Save : Boolean;
      Record_On : Boolean;
      Record_Pause : Boolean;
      Record_Reverse : Boolean;
      Record_Single_Step : Boolean;
      Sea_State : Integer;
      Visual_Transmit : Boolean;
      Height_Of_Terrain : Float;
      Config_Apt_Enable : Boolean;
      Test_Pattern_Number : Integer;
      Visual_Com_Reset : Boolean;

      Video_On_Was_Set : Boolean;
      Host_Buffer_Save_Was_Set : Boolean;
      Record_On_Was_Set : Boolean;
      Record_Pause_Was_Set : Boolean;
      Record_Reverse_Was_Set : Boolean;
      Record_Single_Step_Was_Set : Boolean;
      Sea_State_Was_Set : Boolean;
      Visual_Transmit_Was_Set : Boolean;
      Test_Pattern_Number_Was_Set : Boolean;
      Visual_Com_Reset_Was_Set : Boolean;
      Display_Propeller : Boolean;
      Rear_Seat_View : Boolean;
   end record;

   This_Ios_Interface : Ios_Interface_Instance;

end JPATS_Visual_Buffer.Slow_Data_Container;
