-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with JPATS_IOS_Interface;

private package JPATS_Visual_Buffer.Ios_IF is


-- Access The_Video_On
   procedure Set_Video_On (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Host_Buffer_Save
   procedure Set_Host_Buffer_Save (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Record_On
   procedure Set_Record_On (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Record_Pause
   procedure Set_Record_Pause (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Record_Reverse
   procedure Set_Record_Reverse (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Record_Single_Step
   procedure Set_Record_Single_Step (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Sea_State
   procedure Set_Sea_State (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Visual_Transmit
   procedure Set_Visual_Transmit (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Test_Pattern_Number
   procedure Set_Test_Pattern_Number
     (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Config_Apt_Enable
   procedure Set_Config_Apt_Enable (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Visual_Com_Reset
   procedure Set_Visual_Com_Reset (Pdata : in JPATS_IOS_Interface.Set_Value);

   procedure Register_Ios_Variables;

end JPATS_Visual_Buffer.Ios_IF;
