-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer.Slow_Data_Container;
with Jpats_Ios_Interface;

package body JPATS_Visual_Buffer.Ios_IF is

   IOS : Slow_Data_Container.Ios_Interface_Instance renames
     Slow_Data_Container.This_Ios_Interface;


-- Access The_Video_On
   procedure Set_Video_On
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Video_On := Jpats_Ios_Interface.Convert_To_Bool( Pdata);
      Ios.Video_On_Was_Set := True;
   end Set_Video_On;

-- Access The_Host_Buffer_Save
   procedure Set_Host_Buffer_Save
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Host_Buffer_Save := Jpats_Ios_Interface.Convert_To_Bool( Pdata);
      Ios.Host_Buffer_Save_Was_Set := True;
   end Set_Host_Buffer_Save;

-- Access The_Record_On
   procedure Set_Record_On
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Record_On := Jpats_Ios_Interface.Convert_To_Bool( Pdata);
      Ios.Record_On_Was_Set := True;
   end Set_Record_On;

-- Access The_Record_Pause
   procedure Set_Record_Pause
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Record_Pause := Jpats_Ios_Interface.Convert_To_Bool( Pdata);
      Ios.Record_Pause_Was_Set := True;
   end Set_Record_Pause;

-- Access The_Record_Reverse
   procedure Set_Record_Reverse
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Record_Reverse := Jpats_Ios_Interface.Convert_To_Bool( Pdata);
      Ios.Record_Reverse_Was_Set := True;
   end Set_Record_Reverse;

-- Access The_Record_Single_Step
   procedure Set_Record_Single_Step
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Record_Single_Step := Jpats_Ios_Interface.Convert_To_Bool( Pdata);
      Ios.Record_Single_Step_Was_Set := True;
   end Set_Record_Single_Step;

-- Access Sea_State
   procedure Set_Sea_State
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Sea_State := Jpats_Ios_Interface.Convert_To_Integer( Pdata );
      Ios.Sea_State_Was_Set := True;
   end Set_Sea_State;

-- Access Visual_Transmit
   procedure Set_Visual_Transmit
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Visual_Transmit := Jpats_Ios_Interface.Convert_To_Bool( Pdata );
      Ios.Visual_Transmit_Was_Set := True;
   end Set_Visual_Transmit;

-- Access Test_Pattern_Number
   procedure Set_Test_Pattern_Number
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Test_Pattern_Number :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
      Ios.Test_Pattern_Number_Was_Set := True;
   end Set_Test_Pattern_Number;

-- Access Config_Apt_Enable
   procedure Set_Config_Apt_Enable
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Config_Apt_Enable := Jpats_Ios_Interface.Convert_To_Bool(Pdata);
   end Set_Config_Apt_Enable;

-- Access Visual_Com_Reset
   procedure Set_Visual_Com_Reset
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Visual_Com_Reset := Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Ios.Visual_Com_Reset_Was_Set := true;
   end Set_Visual_Com_Reset;

-- Access Display_Propeller
   procedure Set_Display_Propeller
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Display_Propeller := Jpats_Ios_Interface.Convert_To_Bool(Pdata);
   end Set_Display_Propeller;

-- Access Rear_Seat_View
   procedure Set_Rear_Seat_View
     ( Pdata : in JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Rear_Seat_View := Jpats_Ios_Interface.Convert_To_Bool(Pdata);
   end Set_Rear_Seat_View;

   procedure Register_Ios_Variables  is
   begin
      JPATS_IOS_Interface.Register
        (Name        => "Video_On",
         Variable    => Ios.Video_On'Address,
         Set_Routine => Set_Video_On'Access );
      JPATS_IOS_Interface.Register
        (Name        => "Height_Of_Terrain",
         Variable    => Ios.Height_Of_Terrain'Address);
      JPATS_IOS_Interface.Register
        (Name        => "Config_Apt_Enable",
         Variable    => Ios.Config_Apt_Enable'Address,
         Set_Routine => Set_Config_Apt_Enable'Access );
      JPATS_IOS_Interface.Register
        (Name        => "Test_Pattern_Number",
         Variable    => Ios.Test_Pattern_Number'Address,
         Set_Routine => Set_Test_Pattern_Number'Access );
      JPATS_IOS_Interface.Register
        (Name        => "Host_Buffer_Save",
         Variable    => Ios.Host_Buffer_Save'Address,
         Set_Routine => Set_Host_Buffer_Save'Access );
      JPATS_IOS_Interface.Register
        (Name        => "Visual_Com_Reset",
         Variable    => Ios.Visual_Com_Reset'Address,
         Set_Routine => Set_Visual_Com_Reset'Access );
      JPATS_IOS_Interface.Register
        (Name        => "Visual_Transmit",
         Variable    => Ios.Visual_Transmit'Address,
         Set_Routine => Set_Visual_Transmit'Access );
      JPATS_IOS_Interface.Register
        (Name        => "Display_Propeller",
         Variable    => Ios.Display_Propeller'Address,
         Set_Routine => Set_Display_Propeller'Access );
      JPATS_IOS_Interface.Register
        (Name        => "Rear_Seat_View",
         Variable    => Ios.Rear_Seat_View'Address,
         Set_Routine => Set_Rear_Seat_View'Access );
   end Register_Ios_Variables;


end JPATS_Visual_Buffer.Ios_IF;
