-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer.Fast_Data_Container;
with Jpats_Visual_Buffer.Slow_Data_Container;
with Jpats_Visual_Buffer_Types;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;
with Jpats_Visual_Models;
with Jpats_Visual_Airport;
with Jpats_Visual_Weather;
with Jpats_Simulated_Aircraft;
with Jpats_Aircraft_Body;
with Jpats_DCLS;
with Angle_Types;
with Visual_Airport_Utilities;
with Data_Block.High_Precision_Ownship_Send;
with Data_Block.Ownship_Lobes;
with Data_Block.Hot_Request;
with Data_Block.Air_Hazards;
with Data_Block.Other_Hazards;
with Data_Block.Dof_Models.Three_Dof_Model;
with Data_Block.Dof_Models.Four_Dof_Model;
with Data_Block.Dof_Models.Six_Dof_Model;
with Data_Block.Termination;
with Data_Block.Ownship_Return;
with Data_Block.Atmosphere_Return;
with Data_Block.Celestial_Control_Return;
with Data_Block.Hot_Return;
with Data_Block.Model_Hot_Return;
with Data_Block.Lightning_Return;
with Data_Block.Recording_Control;
with Data_Block.System_Features;
with Data_Block.Airport_Control;
with Data_Block.Celestial_Control;
with Data_Block.Runway_Control;
with Data_Block.Atmosphere_Control;
with Data_Block.Config_Apt_Cntl;
with Data_Block.Test_Pattern;
with Data_Block.Expanded_Model;
with Data_Block.Status_Block;
with Data_Block.Motion_Command;
with Data_Block.Scale_Command;
with Data_Block.Orientation_Command;
with Data_Block.Value_Command;
with Data_Block.Position_Command;
with Jpats_Formation_Manager;
with Lat_Long_Types;
with Io_Medium.Udp;
with Io_Medium;
with Vx_Ip_Binding;
with Simulation_Dictionary;
with Jpats_Radio_Db_If;
with Jpats_Lights;
with Ada.Text_Io;
use Ada.Text_Io;
with Ada.Integer_Text_Io;
--with Ada.Float_Text_Io;
use Ada.Integer_Text_Io;
--use Ada.Float_Text_Io;
with Interfaces.C;
with Ada.Strings.Fixed;
with Jpats_Engine_Data_Manager.Ios_Interface;
with Log;

package body JPATS_Visual_Buffer.Fast_Data_Controller is

   Foreign_Address : Vx_Ip_Binding.Ip_Address := (10,10,6,2);
   pragma Export ( C, Foreign_Address, "visual_foreign_address" );

   Local_Address : Vx_Ip_Binding.Ip_Address := (10,10,6,1);
   pragma Export ( C, Local_Address, "visual_local_address" );

   Foreign_Port : Natural := 8002;
   pragma Export ( C, Foreign_Port, "visual_foreign_port" );

   Local_Port : Natural := 8002;
   pragma Export ( C, Local_Port, "visual_local_port" );

   Reset_Visual_Medium : Boolean := False;
   pragma Export ( C, Reset_Visual_Medium, "reset_visual_medium" );

   Crashed_Last_Pass : Boolean := False;
   pragma Export ( C, Crashed_Last_Pass, "crashed_last_pass" );

   Visual_Models_Taw6       : Boolean;
   Visual_Models_Taw5       : Boolean;
   Visual_Models_Taw4       : Boolean;
   Visual_Models_Iaf        : Boolean;

   Temp_Landing_Lobe_Intensity_1 : Float;
   Temp_Landing_Lobe_Intensity_2 : Float;
   Temp_Landing_Lobe_Intensity_3 : Float;
   Temp_Landing_Lobe_Intensity_4 : Float;
   Temp_Landing_Lobe_Intensity_5 : Float;
   Temp_Landing_Lobe_Intensity_6 : Float;
   Temp_Landing_Lobe_Intensity_7 : Float;
   Temp_Landing_Lobe_Intensity_8 : Float;
   Temp_Steerable_Light_Azimuth_1 : Float;
   Temp_Steerable_Light_Azimuth_2 : Float;
   Temp_Steerable_Light_Azimuth_3 : Float;
   Temp_Steerable_Light_Azimuth_4 : Float;
   Temp_Steerable_Light_Azimuth_5 : Float;
   Temp_Steerable_Light_Azimuth_6 : Float;
   Temp_Steerable_Light_Azimuth_7 : Float;
   Temp_Steerable_Light_Azimuth_8 : Float;
   Temp_Steerable_Light_Elevation_1 : Float;
   Temp_Steerable_Light_Elevation_2 : Float;
   Temp_Steerable_Light_Elevation_3 : Float;
   Temp_Steerable_Light_Elevation_4 : Float;
   Temp_Steerable_Light_Elevation_5 : Float;
   Temp_Steerable_Light_Elevation_6 : Float;
   Temp_Steerable_Light_Elevation_7 : Float;
   Temp_Steerable_Light_Elevation_8 : Float;
   Temp_Steerable_Light_Vertical_Beam_1 : Float;
   Temp_Steerable_Light_Vertical_Beam_2 : Float;
   Temp_Steerable_Light_Vertical_Beam_3 : Float;
   Temp_Steerable_Light_Vertical_Beam_4 : Float;
   Temp_Steerable_Light_Vertical_Beam_5 : Float;
   Temp_Steerable_Light_Vertical_Beam_6 : Float;
   Temp_Steerable_Light_Vertical_Beam_7 : Float;
   Temp_Steerable_Light_Vertical_Beam_8 : Float;
   Temp_Steerable_Light_Horizontal_Beam_1 : Float;
   Temp_Steerable_Light_Horizontal_Beam_2 : Float;
   Temp_Steerable_Light_Horizontal_Beam_3 : Float;
   Temp_Steerable_Light_Horizontal_Beam_4 : Float;
   Temp_Steerable_Light_Horizontal_Beam_5 : Float;
   Temp_Steerable_Light_Horizontal_Beam_6 : Float;
   Temp_Steerable_Light_Horizontal_Beam_7 : Float;
   Temp_Steerable_Light_Horizontal_Beam_8 : Float;

   Invalid_Ip_Address : exception;

   -----------------------------------------------------------------------------
   -- Translate the given string into an IP address. The string needs to be a
   -- series of four numbers (from 0 to 255) separated by periods
   -----------------------------------------------------------------------------
   function To_IP_Address (Address : String) return Vx_Ip_Binding.Ip_Address is
      Result : Vx_Ip_Binding.Ip_Address;
      Start : Natural := Address'First;
      Finish : Natural;
   begin
      for Byte in Result'range loop
         -- Locate the end of the next address byte's string.
         if Byte = Result'Last then
            Finish := Address'Last;
         else
            -- Find the character in front of the next period
            Finish := Ada.Strings.Fixed.Index (Source  => Address (Start..Address'Last),
                                               Pattern => ".") - 1;
         end if;

         -- Convert it to a byte in the IP address array
         Result (Byte) := Interfaces.C.Unsigned_Char'Value(Address(Start..Finish));

         -- Advance start past the byte's dot.
         Start := Finish + 2;
      end loop;

      return Result;
   exception
      when Constraint_Error =>
         raise Invalid_Ip_Address;
   end To_Ip_Address;

-- Method Initialize
   procedure Initialize is
      --      I : Integer;
   begin

      Fast_Data_Container.This_Fast_Send_Subsystem.Visual_Transmit :=
        Simulation_Dictionary.Lookup("Visual_Installed") = "T";

      Visual_Models_Taw6 :=
        Simulation_Dictionary.Lookup("Visual_Models") = "TAW6";

      Visual_Models_Taw5 :=
        Simulation_Dictionary.Lookup("Visual_Models") = "TAW5";

      Visual_Models_Taw4 :=
        Simulation_Dictionary.Lookup("Visual_Models") = "TAW4";

      Visual_Models_Iaf :=
        Simulation_Dictionary.Lookup("Visual_Models") = "IAF";

      if Fast_Data_Container.This_Fast_Send_Subsystem.Visual_Transmit then

         Foreign_Address := To_Ip_Address
           (Simulation_Dictionary.Lookup
              (Word    => "Visual_Foreign_Address",
               Default => "10.10.6.2"
              )
           );

         Local_Address := To_Ip_Address
           (Simulation_Dictionary.Lookup
              (Word    => "Visual_Local_Address",
               Default => "10.10.6.1"
              )
           );

         Fast_Data_Container.The_Visual_Ethernet :=
           Io_Medium.Udp.Create(A_Local_Port => Local_Port,
                                A_Foreign_Port => Foreign_Port,
                                A_Local_Address => Local_Address,
                                A_Foreign_Address => Foreign_Address,
                                Use_Single_Socket => False,
                                Bind_Local        => True); -- bind to a local port and call recv to read data

         Io_Medium.Initialize(Fast_Data_Container.The_Visual_Ethernet);

      end if;

      --Initialize temporary variables
      Temp_Landing_Lobe_Intensity_1 := 0.0;
      Temp_Landing_Lobe_Intensity_2 := 0.0;
      Temp_Landing_Lobe_Intensity_3 := 0.0;
      Temp_Landing_Lobe_Intensity_4 := 0.0;
      Temp_Landing_Lobe_Intensity_5 := 1.0;
      Temp_Landing_Lobe_Intensity_6 := 0.0;
      Temp_Landing_Lobe_Intensity_7 := 1.0;
      Temp_Landing_Lobe_Intensity_8 := 0.0;
      Temp_Steerable_Light_Azimuth_1 := 0.0;
      Temp_Steerable_Light_Azimuth_2 := 0.0;
      Temp_Steerable_Light_Azimuth_3 := 0.0;
      Temp_Steerable_Light_Azimuth_4 := 0.0;
      Temp_Steerable_Light_Azimuth_5 := 0.0;
      Temp_Steerable_Light_Azimuth_6 := 0.0;
      Temp_Steerable_Light_Azimuth_7 := 0.0;
      Temp_Steerable_Light_Azimuth_8 := 0.0;
      Temp_Steerable_Light_Elevation_1 := 0.0;
      Temp_Steerable_Light_Elevation_2 := 0.0;
      Temp_Steerable_Light_Elevation_3 := 0.0;
      Temp_Steerable_Light_Elevation_4 := 0.0;
      Temp_Steerable_Light_Elevation_5 := 0.0;
      Temp_Steerable_Light_Elevation_6 := 0.0;
      Temp_Steerable_Light_Elevation_7 := 0.0;
      Temp_Steerable_Light_Elevation_8 := 0.0;
      Temp_Steerable_Light_Vertical_Beam_1 := 0.25;
      Temp_Steerable_Light_Vertical_Beam_2 := 0.25;
      Temp_Steerable_Light_Vertical_Beam_3 := 0.25;
      Temp_Steerable_Light_Vertical_Beam_4 := 0.25;
      Temp_Steerable_Light_Vertical_Beam_5 := 0.25;
      Temp_Steerable_Light_Vertical_Beam_6 := 0.25;
      Temp_Steerable_Light_Vertical_Beam_7 := 0.25;
      Temp_Steerable_Light_Vertical_Beam_8 := 0.25;
      Temp_Steerable_Light_Horizontal_Beam_1 := 0.25;
      Temp_Steerable_Light_Horizontal_Beam_2 := 0.25;
      Temp_Steerable_Light_Horizontal_Beam_3 := 0.25;
      Temp_Steerable_Light_Horizontal_Beam_4 := 0.25;
      Temp_Steerable_Light_Horizontal_Beam_5 := 0.25;
      Temp_Steerable_Light_Horizontal_Beam_6 := 0.25;
      Temp_Steerable_Light_Horizontal_Beam_7 := 0.25;
      Temp_Steerable_Light_Horizontal_Beam_8 := 0.25;

      Data_Block.High_Precision_Ownship_Send.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_High_Precision_Ownship);
      Data_Block.Ownship_Lobes.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes);
      Data_Block.Hot_Request.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Hot_Request);
      Data_Block.Air_Hazards.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards);
      Data_Block.Other_Hazards.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards);
      Data_Block.Dof_Models.Three_Dof_Model.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Three_Dof_Models);
      for I in 1..7 loop
         Data_Block.Dof_Models.Four_Dof_Model.Initialize
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Four_Dof_Models(I), I);
      end loop;
      for I in 1..10 loop
         Data_Block.Dof_Models.Six_Dof_Model.Initialize
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Six_Dof_Models(I), I);
      end loop;
      Data_Block.Recording_Control.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Recording_Control);
      Data_Block.Termination.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Termination);

      Data_Block.Expanded_Model.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model);
      Data_Block.Status_Block.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status);
      Data_Block.Orientation_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Right_Aileron_Orient);
      Data_Block.Orientation_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Left_Aileron_Orient);
      Data_Block.Scale_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Scale);
      Data_Block.Value_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Value);
      Data_Block.Status_Block.Set_Status_Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status,2);
      Data_Block.Status_Block.Set_Command_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status,4);

      Data_Block.Expanded_Model.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Expanded_Model);
      Data_Block.Status_Block.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Control_Status);
      Data_Block.Orientation_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Flap_Orient);
      Data_Block.Orientation_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Speed_Brake_Orient);
      Data_Block.Orientation_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Elevator_Orient);
      Data_Block.Orientation_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Rudder_Orient);
      Data_Block.Orientation_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Right_Aileron_Orient);
      Data_Block.Orientation_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Left_Aileron_Orient);
      Data_Block.Status_Block.Set_Status_Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Control_Status,1);
      Data_Block.Status_Block.Set_Command_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Control_Status,6);

      Data_Block.Expanded_Model.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Lightning.The_Expanded_Model);
      Data_Block.Status_Block.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Lightning.The_Control_Status);
      Data_Block.Value_Command.Initialize
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Lightning.The_Lightning_Value);
      Data_Block.Status_Block.Set_Status_Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Lightning.The_Control_Status,1);
      Data_Block.Status_Block.Set_Command_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Lightning.The_Control_Status,1);

      Data_Block.Ownship_Return.Initialize
        (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return);
      Data_Block.Hot_Return.Initialize
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return);
      Data_Block.Atmosphere_Return.Initialize
        (Fast_Data_Container.This_Receive_Subsystem.The_Atmosphere_Return);
      Data_Block.Celestial_Control_Return.Initialize
        (Fast_Data_Container.This_Receive_Subsystem.The_Celestial_Control_Return);
      for I in 1..17 loop
         Data_Block.Model_Hot_Return.Initialize
           (Fast_Data_Container.This_Receive_Subsystem.
            The_Model_Hot_Return(I));
      end loop;
      Data_Block.Lightning_Return.Initialize
        (Fast_Data_Container.This_Receive_Subsystem.The_Lightning_Return);


      Fast_Data_Container.The_Send_Buffer(1) := 16#00400003#;
      Fast_Data_Container.The_Send_Buffer(2) := 16#01000000#;
      Fast_Data_Container.The_Send_Buffer(3) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(4) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(5) := 16#00000106#;
      Fast_Data_Container.The_Send_Buffer(6) := 16#1abf554f#;
      Fast_Data_Container.The_Send_Buffer(7) := 16#7adaa908#;
      Fast_Data_Container.The_Send_Buffer(8) := 16#a8fd9044#;
      Fast_Data_Container.The_Send_Buffer(9) := 16#0003e800#;
      Fast_Data_Container.The_Send_Buffer(10) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(11) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(12) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(13) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(14) := 16#02000000#;
      Fast_Data_Container.The_Send_Buffer(15) := 16#00b6d072#;
      Fast_Data_Container.The_Send_Buffer(16) := 16#6b73666f#;
      Fast_Data_Container.The_Send_Buffer(17) := 16#04880815#;
      Fast_Data_Container.The_Send_Buffer(18) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(19) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(20) := 16#03e80000#;
      Fast_Data_Container.The_Send_Buffer(21) := 16#000003e8#;
      Fast_Data_Container.The_Send_Buffer(22) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(23) := 16#03d80000#;
      Fast_Data_Container.The_Send_Buffer(24) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(25) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(26) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(27) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(28) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(29) := 16#00000000#;
      Fast_Data_Container.The_Send_Buffer(30) := 16#00140000#;
      Fast_Data_Container.The_Send_Buffer(31) := 16#13000000#;

      for I in 32..365 loop
        Fast_Data_Container.The_Send_Buffer(I) := 0;
      end loop;
      for I in 1..365 loop
--         Fast_Data_Container.The_Send_Buffer(I) := 0;
         Fast_Data_Container.The_Receive_Buffer(I) := 0;
      end loop;

      Slow_Data_Container.This_Ios_Interface.Display_Propeller := True;
      Slow_Data_Container.This_Ios_Interface.Rear_Seat_View := False;

   exception
      when others =>
         Log.Report ("Jpats_Visual_Buffer-fast_data_controller.Initialize()");
         raise;

   end Initialize;

-- Method Update
   procedure Update
     (Integration_Constant : in Float) is
      X_Cg : Float := 0.0;
      Z_Cg : Float := 0.0;
      Ac_Position : Lat_Long_Types.Position;
      Model_Position : Lat_Long_Types.Position;
      Ac_Heading : Float := 0.0;
      J : Integer := 1;
      R_Ail_Pos            : Angle_Types.Degrees;
      L_Ail_Pos            : Angle_Types.Degrees;
      Prop_Spin_Pct        : Float;
      Flap_Position        : Float;
      Speed_Brake_Position : Float;
      Elevator_Position    : Float;
      Rudder_Position      : Float;
      Lead_R_Ail_Pos       : Angle_Types.Degrees;
      Lead_L_Ail_Pos       : Angle_Types.Degrees;
   begin

      if Slow_Data_Container.This_Ios_Interface.Visual_Transmit_Was_Set then
         Fast_Data_Container.This_Fast_Send_Subsystem.Visual_Transmit :=
           Slow_Data_Container.This_Ios_Interface.Visual_Transmit;
         Slow_Data_Container.This_Ios_Interface.Visual_Transmit_Was_Set :=
           False;
      end if;

      Slow_Data_Container.This_Ios_Interface.Visual_Transmit :=
        Fast_Data_Container.This_Fast_Send_Subsystem.Visual_Transmit;

      if Slow_Data_Container.This_Ios_Interface.Visual_Com_Reset_Was_Set then
         Reset_Visual_Medium := Slow_Data_Container.This_Ios_Interface.
           Visual_Com_Reset;
         Slow_Data_Container.This_Ios_Interface.Visual_Com_Reset_Was_Set :=
           False;
         Slow_Data_Container.This_Ios_Interface.Visual_Com_Reset := False;
      end if;

      if Reset_Visual_Medium and
        Fast_Data_Container.This_Fast_Send_Subsystem.Visual_Transmit then

         -- DEBUG CODE --- on a flag from the host, close the socket,
         -- delete the instance of the medium, create a new one with
         -- a different address, and initialize it

         Reset_Visual_Medium := False;
         Io_Medium.Delete ( Fast_Data_Container.The_Visual_Ethernet );

         Fast_Data_Container.The_Visual_Ethernet :=
           Io_Medium.Udp.Create(A_Local_Port => Local_Port,
                                A_Foreign_Port => Foreign_Port,
                                A_Local_Address => Local_Address,
                                A_Foreign_Address => Foreign_Address,
                                Use_Single_Socket => False);

         Io_Medium.Initialize(Fast_Data_Container.The_Visual_Ethernet);

      end if;

      X_Cg := Jpats_Simulated_Aircraft.Get_X_Cg;
      Z_Cg := Jpats_Simulated_Aircraft.Get_Z_Cg;
      Ac_Heading := Jpats_Simulated_Aircraft.Get_Hdg_Angle *
        180.0/3.14159265;
      Ac_Position :=
        Jpats_Simulated_Aircraft.Get_Aircraft_Position;

      if (Jpats_Visual_Airport.Visual_Debug_Position) then
         X_Cg := 40.0;
         Z_Cg := 4.0;
         Ac_Heading := 0.0;
         Ac_Position.Latitude := 38.936489;
         Ac_Position.Longitude := -77.459588;
         Ac_Position.Altitude := 406.0;
      end if;

      if (not Jpats_Simulated_Aircraft.Crashed and Crashed_Last_Pass) then
         Data_Block.Ownship_Return.Set_Fuselage_Collision_Latch
           (Fast_Data_Container.This_Receive_Subsystem.
            The_Ownship_Return, False);
         Data_Block.Ownship_Return.Set_Right_Wing_Collision_Latch
           (Fast_Data_Container.This_Receive_Subsystem.
            The_Ownship_Return, False);
         Data_Block.Ownship_Return.Set_Left_Wing_Collision_Latch
           (Fast_Data_Container.This_Receive_Subsystem.
            The_Ownship_Return, False);
      end if;
      Crashed_Last_Pass := Jpats_Simulated_Aircraft.Crashed;

--Set Ownship Model Parameters
      Data_Block.Expanded_Model.Set_Model_Instance_Id
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,19);
      if Visual_Models_Taw6 then
         if Slow_Data_Container.This_Ios_Interface.Rear_Seat_View then
            Data_Block.Expanded_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Jpats_Ownship.The_Expanded_Model,1032);
         else
            Data_Block.Expanded_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Jpats_Ownship.The_Expanded_Model,1004);
         end if;
      elsif Visual_Models_Taw5 or Visual_Models_Taw4 then
         if Slow_Data_Container.This_Ios_Interface.Rear_Seat_View then
            Data_Block.Expanded_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Jpats_Ownship.The_Expanded_Model,1014);
         else
            Data_Block.Expanded_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Jpats_Ownship.The_Expanded_Model,1022);
         end if;
      elsif Visual_Models_Iaf then
         Data_Block.Expanded_Model.Set_Model_Designation
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Ownship.The_Expanded_Model,1006);
      else
         if Slow_Data_Container.This_Ios_Interface.Rear_Seat_View then
            Data_Block.Expanded_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Jpats_Ownship.The_Expanded_Model,1031);
         else
            Data_Block.Expanded_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Jpats_Ownship.The_Expanded_Model,1001);
         end if;
      end if;
      Data_Block.Expanded_Model.Set_Model_Hot_Request
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,False);
      Data_Block.Expanded_Model.Set_Model_Has_Parent
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,True);
      Data_Block.Expanded_Model.Set_Model_Ownship
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,True);
      Data_Block.Expanded_Model.Set_Terrain_Following
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,False);
      Data_Block.Expanded_Model.Set_Expanded_Hot
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,False);
      Data_Block.Expanded_Model.Set_Appended_Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,10);
      Data_Block.Expanded_Model.Set_Parent_id
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,0);
      Data_Block.Expanded_Model.Set_Model_Lat_X
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,0.0);
      Data_Block.Expanded_Model.Set_Model_Lon_Y
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,0.0);
      Data_Block.Expanded_Model.Set_Model_Alt_Z
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,0.0);
      Data_Block.Expanded_Model.Set_Model_Heading
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,0.0);
      Data_Block.Expanded_Model.Set_Model_Pitch
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,0.0);
      Data_Block.Expanded_Model.Set_Model_Roll
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model,0.0);
      Data_Block.Status_Block.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status);
      Data_Block.Status_Block.Set_Model_Control
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status,6);
      Data_Block.Status_Block.Set_Model_Control
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status,17);
      Data_Block.Status_Block.Set_Model_Control
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status,18);
      Data_Block.Status_Block.Set_Model_Control
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status,34);
      If not Slow_Data_Container.This_Ios_Interface.Display_Propeller then
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Ownship.The_Control_Status,40);
      end if;
      R_Ail_Pos :=
        Visual_Airport_Utilities.Flimit
        (-JPATS_DCLS.Get_Right_Aileron_Position,-45.0,45.0);
      Data_Block.Orientation_Command.Set_Control
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Right_Aileron_Orient,17);
      Data_Block.Orientation_Command.Set_Pitch
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Right_Aileron_Orient,R_Ail_Pos);
      L_Ail_Pos :=
        Visual_Airport_Utilities.Flimit
        (JPATS_DCLS.Get_Left_Aileron_Position,-45.0,45.0);
      Data_Block.Orientation_Command.Set_Control
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Left_Aileron_Orient,18);
      Data_Block.Orientation_Command.Set_Pitch
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Left_Aileron_Orient,L_Ail_Pos);
      Prop_Spin_Pct :=
        Visual_Airport_Utilities.Flimit
        (((JPATS_Engine_Data_Manager.Ios_Interface.This_Ios_Interface.
         Propeller_Speed_Percent * 1.80) / 100.0),0.0,0.9999);
      Data_Block.Scale_Command.Set_Control
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Scale,34);
      Data_Block.Scale_Command.Set_Scale
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Scale,Prop_Spin_Pct);
      Data_Block.Value_Command.Set_Control
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Value,34);
      Data_Block.Value_Command.Set_Value
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Value,1.0);

-- Set High Precision Ownship Send Data
      Data_Block.High_Precision_Ownship_Send.Compute_Eyepoint
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, X_Cg, Z_Cg);
      Data_Block.High_Precision_Ownship_Send.Set_Ieee_754_Cg
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Wipers
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Wing_Strobe_Light
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Anti_Coll_Beacon_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, Jpats_Lights.Left_Anti_Collision_Light_On);
      Data_Block.High_Precision_Ownship_Send.Set_Anti_Coll_Beacon_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, Jpats_Lights.Right_Anti_Collision_Light_On);
      Data_Block.High_Precision_Ownship_Send.Set_Anti_Coll_Beacon_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Anti_Coll_Beacon_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Anti_Coll_Beacon_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Anti_Coll_Beacon_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Anti_Coll_Beacon_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Weight_On_Wheels
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, Jpats_Aircraft_Body.Get_Wow);
      Data_Block.High_Precision_Ownship_Send.Set_Ambient_Lighting
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, True);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_0
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_8
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_9
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_10
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_11
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_12
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_13
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_14
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Device_Disable_Mask_15
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_High_Precision_Ownship, False);
      Data_Block.High_Precision_Ownship_Send.Set_Vis_Pitch
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_High_Precision_Ownship,
         Jpats_Simulated_Aircraft.Get_Pitch_Angle * 180.0/3.14159265);
      Data_Block.High_Precision_Ownship_Send.Set_Vis_Roll
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_High_Precision_Ownship,
         Jpats_Simulated_Aircraft.Get_Roll_Angle * 180.0/3.14159265);
      Data_Block.High_Precision_Ownship_Send.Set_Vis_Heading
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_High_Precision_Ownship,
         Ac_Heading);
      Data_Block.High_Precision_Ownship_Send.Set_Vis_Position
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_High_Precision_Ownship,
         Ac_Position);

-- Set Ownship Lobes (send)
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_0
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_8
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_9
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_10
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_11
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_12
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_13
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_14
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Device_Disable_Mask_15
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Enable_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Enable_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Enable_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Enable_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Enable_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, True);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Enable_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Enable_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, True);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Enable_8
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes, False);
      Data_Block.Ownship_Lobes.Set_Landing_Lobe_Intensity_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Landing_Lobe_Intensity_1);
      Data_Block.Ownship_Lobes.Set_Landing_Lobe_Intensity_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Landing_Lobe_Intensity_2);
      Data_Block.Ownship_Lobes.Set_Landing_Lobe_Intensity_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Landing_Lobe_Intensity_3);
      Data_Block.Ownship_Lobes.Set_Landing_Lobe_Intensity_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Landing_Lobe_Intensity_4);
      if Jpats_Lights.Taxi_Light_On then
         Temp_Landing_Lobe_Intensity_5 := 1.0;
      else
         Temp_Landing_Lobe_Intensity_5 := 0.0;
      end if;
      Data_Block.Ownship_Lobes.Set_Landing_Lobe_Intensity_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Landing_Lobe_Intensity_5);
      Data_Block.Ownship_Lobes.Set_Landing_Lobe_Intensity_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Landing_Lobe_Intensity_6);
      if JPATS_Lights.Landing_Light_On then
         Temp_Landing_Lobe_Intensity_7 := 1.0;
      else
         Temp_Landing_Lobe_Intensity_7 := 0.0;
      end if;
      Data_Block.Ownship_Lobes.Set_Landing_Lobe_Intensity_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Landing_Lobe_Intensity_7);
      Data_Block.Ownship_Lobes.Set_Landing_Lobe_Intensity_8
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Landing_Lobe_Intensity_8);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Azimuth_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Azimuth_1);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Azimuth_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Azimuth_2);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Azimuth_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Azimuth_3);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Azimuth_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Azimuth_4);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Azimuth_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Azimuth_5);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Azimuth_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Azimuth_6);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Azimuth_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Azimuth_7);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Azimuth_8
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Azimuth_8);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Elevation_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Elevation_1);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Elevation_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Elevation_2);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Elevation_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Elevation_3);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Elevation_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Elevation_4);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Elevation_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Elevation_5);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Elevation_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Elevation_6);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Elevation_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Elevation_7);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Elevation_8
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Elevation_8);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Vertical_Beam_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Vertical_Beam_1);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Vertical_Beam_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Vertical_Beam_2);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Vertical_Beam_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Vertical_Beam_3);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Vertical_Beam_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Vertical_Beam_4);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Vertical_Beam_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Vertical_Beam_5);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Vertical_Beam_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Vertical_Beam_6);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Vertical_Beam_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Vertical_Beam_7);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Vertical_Beam_8
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Vertical_Beam_8);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Horizontal_Beam_1
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Horizontal_Beam_1);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Horizontal_Beam_2
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Horizontal_Beam_2);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Horizontal_Beam_3
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Horizontal_Beam_3);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Horizontal_Beam_4
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Horizontal_Beam_4);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Horizontal_Beam_5
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Horizontal_Beam_5);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Horizontal_Beam_6
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Horizontal_Beam_6);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Horizontal_Beam_7
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Horizontal_Beam_7);
      Data_Block.Ownship_Lobes.Set_Steerable_Light_Horizontal_Beam_8
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes,
         Temp_Steerable_Light_Horizontal_Beam_8);

-- Set Hot Request Data
      Data_Block.Hot_Request.Predict_Ac_Position
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Hot_Request,
         Ac_Position.Latitude, Ac_Position.Longitude, Integration_Constant);
      Data_Block.Hot_Request.Gear_Lat_Lon_Position
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Hot_Request,
         Ac_Position.Latitude, Ac_Heading);

--Set Formation Aircraft Data
      if (JPATS_Visual_Models.Formation_Model_Active) then
         Data_Block.Expanded_Model.Set_Model_Instance_Id
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,
            JPATS_Visual_Models.Formation_Model_Id);
         Data_Block.Expanded_Model.Set_Model_Designation
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,
            Jpats_Visual_Models.Formation_Model_Type);
         Data_Block.Expanded_Model.Set_Model_Hot_Request
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,False);
         Data_Block.Expanded_Model.Set_Model_Has_Parent
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,False);
         Data_Block.Expanded_Model.Set_Model_Ownship
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,False);
         Data_Block.Expanded_Model.Set_Terrain_Following
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,False);
         Data_Block.Expanded_Model.Set_Expanded_Hot
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,False);
         Data_Block.Expanded_Model.Set_Appended_Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,14);
         Data_Block.Expanded_Model.Set_Parent_id
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,0);
         Model_Position := JPATS_Visual_Models.Formation_Model_Position;
         Data_Block.Expanded_Model.Set_Model_Lat_X
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,
            Model_Position.Latitude);
         Data_Block.Expanded_Model.Set_Model_Lon_Y
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,
            Model_Position.Longitude);
         Data_Block.Expanded_Model.Set_Model_Alt_Z
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,
            Model_Position.Altitude);
         Data_Block.Expanded_Model.Set_Model_Heading
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,
            JPATS_Visual_Models.Formation_Model_Heading);
         Data_Block.Expanded_Model.Set_Model_Pitch
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,
            Jpats_Visual_Models.Formation_Model_Pitch);
         Data_Block.Expanded_Model.Set_Model_Roll
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,
            Jpats_Visual_Models.Formation_Model_Roll);
         Data_Block.Status_Block.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status);
         if (JPATS_Formation_Manager.Lead_Gear_Position <= 0.5) then
            Data_Block.Status_Block.Set_Model_Control
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Jpats_Model.The_Control_Status, 0);
         end if;
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 2);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 3);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 4);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 9);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 10);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 15);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 16);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 17);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status, 18);
         Flap_Position :=
           Visual_Airport_Utilities.Flimit
           (Jpats_Formation_Manager.Lead_Flap_Position,
            0.0,49.99);
         Data_Block.Orientation_Command.Set_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Flap_Orient,9);
         Data_Block.Orientation_Command.Set_Pitch
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Flap_Orient,
            Flap_Position);
         Speed_Brake_Position :=
           Visual_Airport_Utilities.Flimit
           (JPATS_Formation_Manager.Lead_Speedbrake_Position*70.0,
            0.0,69.99);
         Data_Block.Orientation_Command.Set_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Speed_Brake_Orient,10);
         Data_Block.Orientation_Command.Set_Pitch
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Speed_Brake_Orient,
            Speed_Brake_Position);
         Elevator_Position :=
           Visual_Airport_Utilities.Flimit
           (-Jpats_Formation_Manager.Lead_Elevator_Position,
            -10.0,45.0);
         Data_Block.Orientation_Command.Set_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Elevator_Orient,15);
         Data_Block.Orientation_Command.Set_Pitch
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Elevator_Orient,
            Elevator_Position);
         Rudder_Position :=
           Visual_Airport_Utilities.Flimit
           (-Jpats_Formation_Manager.Lead_Rudder_Position,
            -35.0,35.0);
         Data_Block.Orientation_Command.Set_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Rudder_Orient,16);
         Data_Block.Orientation_Command.Set_Yaw
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Rudder_Orient,
            Rudder_Position);
         Lead_R_Ail_Pos :=
           Visual_Airport_Utilities.Flimit
           (-Jpats_Formation_Manager.Lead_Right_Aileron_Position,
            -45.0,45.0);
         Data_Block.Orientation_Command.Set_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Right_Aileron_Orient,17);
         Data_Block.Orientation_Command.Set_Pitch
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Right_Aileron_Orient,Lead_R_Ail_Pos);
         Lead_L_Ail_Pos :=
           Visual_Airport_Utilities.Flimit
           (Jpats_Formation_Manager.Lead_Left_Aileron_Position,
            -45.0,45.0);
         Data_Block.Orientation_Command.Set_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Left_Aileron_Orient,18);
         Data_Block.Orientation_Command.Set_Pitch
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Left_Aileron_Orient,Lead_L_Ail_Pos);

         Data_Block.Expanded_Model.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,True);
      else
         Data_Block.Expanded_Model.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model,False);
      end if;

-- Set Lightning Model
      if Jpats_Visual_Weather.Storm_Active and
         Jpats_Visual_Weather.Storm_Lightning_Active then
         Data_Block.Expanded_Model.Set_Model_Instance_Id
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model,26);
         Data_Block.Expanded_Model.Set_Model_Designation
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model,61112);
         Data_Block.Expanded_Model.Set_Model_Has_Parent
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model,True);
         Data_Block.Expanded_Model.Set_Model_Ownship
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model,False);
         Data_Block.Expanded_Model.Set_Appended_Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model,4);
         Data_Block.Expanded_Model.Set_Parent_id
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model,
            Jpats_Visual_Models.Storm_Model_Id(1));
         Data_Block.Status_Block.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Control_Status);
         Data_Block.Status_Block.Set_Model_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Control_Status,0);
         Data_Block.Value_Command.Set_Control
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Lightning_Value,0);
         Data_Block.Value_Command.Set_Value
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Lightning_Value,
            Float(JPATS_Visual_Weather.Storm_Lightning_Frequency));
         Data_Block.Expanded_Model.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model,True);
      else
         Data_Block.Expanded_Model.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model,False);
      end if;


-- Set Air_Hazard Data
      if (Jpats_Visual_Models.Air_Hazard_Active) then
         Data_Block.Air_Hazards.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards,True);
         Data_Block.Air_Hazards.Set_Model_Instance_Id
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards,
            Jpats_Visual_Models.Air_Hazard_Id);
         Data_Block.Air_Hazards.Set_Model_Designation
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards,
            Jpats_Visual_Models.Air_Hazard_Model_Type);
         Data_Block.Air_Hazards.Set_Collision_Bearing
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards,
            Jpats_Visual_Models.Air_Hazard_Bearing);
         Data_Block.Air_Hazards.Set_Time_To_Impact
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards,
            Jpats_Visual_Models.Air_Hazard_Time_To_Impact);
      else
         Data_Block.Air_Hazards.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards,
            False);
      end if;

-- Set Other_Hazards Data
      if (Jpats_Visual_Models.Ground_Hazard_Active) then
         Data_Block.Other_Hazards.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards,
            True);
         Data_Block.Other_Hazards.Set_Model_Instance_Id
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards,
            Jpats_Visual_Models.Ground_Hazard_Id);
         Data_Block.Other_Hazards.Set_Model_Designation
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards,
            Jpats_Visual_Models.Ground_Hazard_Model_Type);
         Data_Block.Other_Hazards.Set_Hazard_Start
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards,
            not Jpats_Visual_Models.Ground_Hazard_Pause);
         Data_Block.Other_Hazards.Set_Hazard_Path_Designation
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards,
            Jpats_Visual_Models.Ground_Hazard_Path);
      else
         Data_Block.Other_Hazards.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards,
            False);
      end if;

-- Four DOF Model Data
      for I in 1..7 loop
         Data_Block.Dof_Models.Four_Dof_Model.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Four_Dof_Models(I),
            False);
      end loop;

      J := 1;
      for i in 1..2 loop
         if (Jpats_Visual_Models.Cloud_Active(I)) then
            Data_Block.Dof_Models.Four_Dof_Model.Set_Use_Data
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(j),
               True);
            Data_Block.Dof_Models.Four_Dof_Model.Set_Hot_Return_Request
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(j),
               Jpats_Visual_Models.Cloud_Hot_Request(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Model_Instance_Id
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(j),
               Jpats_Visual_Models.Cloud_Model_Id(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(j),
               Jpats_Visual_Models.Cloud_Type(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Model_Position
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(j),
               Jpats_Visual_Models.Cloud_Position(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Model_Heading
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(j),
               Jpats_Visual_Models.Cloud_Heading(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Lightning_Enable
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(j),
               Jpats_Visual_Models.Cloud_Lightning(I));
            J := J + 1;
         end if;
      end loop;

      for I in 1..5 loop
         if (Jpats_Visual_Models.Storm_Active(I)) then
            Data_Block.Dof_Models.Four_Dof_Model.Set_Use_Data
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(J), True);
            Data_Block.Dof_Models.Four_Dof_Model.Set_Model_Instance_Id
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(J),
               Jpats_Visual_Models.Storm_Model_Id(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(J),
               Jpats_Visual_Models.Storm_Type(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Model_Position
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(J),
               Jpats_Visual_Models.Storm_Position(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Model_Heading
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(J),
               Jpats_Visual_Models.Storm_Heading(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Hot_Return_Request
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(J),
               Jpats_Visual_Models.Storm_Hot_Request(I));
            Data_Block.Dof_Models.Four_Dof_Model.Set_Lightning_Enable
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(J),
               Jpats_Visual_Models.Storm_Lightning(I));
            J := J + 1;
         end if;
      end loop;

-- Six DOF Models
      J := 1;
      for I in 1..10 loop
         Data_Block.Dof_Models.Six_Dof_Model.Set_Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Six_Dof_Models(J),
            false);

         if (Jpats_Visual_Models.Host_Hazard_Active(I)) then
            Data_Block.Dof_Models.Six_Dof_Model.Set_Use_Data
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(J), True);
            Data_Block.Dof_Models.Six_Dof_Model.Set_Model_Instance_Id
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(J),
               Jpats_Visual_Models.Host_Hazard_Id(I));
            Data_Block.Dof_Models.Six_Dof_Model.Set_Model_Designation
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(J),
               Jpats_Visual_Models.Host_Hazard_Type(I));
            Data_Block.Dof_Models.Six_Dof_Model.Set_Model_Position
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(J),
               Jpats_Visual_Models.Host_Hazard_Position(I));
            Data_Block.Dof_Models.Six_Dof_Model.Set_Model_Heading
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(J),
               Jpats_Visual_Models.Host_Hazard_Heading(I));
            Data_Block.Dof_Models.Six_Dof_Model.Set_Model_Pitch
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(J),
               Jpats_Visual_Models.Host_Hazard_Pitch(I));
            Data_Block.Dof_Models.Six_Dof_Model.Set_Model_Roll
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(J),
               Jpats_Visual_Models.Host_Hazard_Roll(I));
            Data_Block.Dof_Models.Six_Dof_Model.Set_Hot_Return_Request
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(J),
               Jpats_Visual_Models.Host_Hazard_Hot_Request(I));
            J := J + 1;
         end if;
      end loop;

      Data_Block.High_Precision_Ownship_Send.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_High_Precision_Ownship);

      Data_Block.Ownship_Lobes.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes);

      Data_Block.Hot_Request.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Hot_Request);

      if (Data_Block.Air_Hazards.Use_Data
          (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards)) then
         Data_Block.Air_Hazards.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards);
      end if;

      if Data_Block.Other_Hazards.Use_Data
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards) then
         Data_Block.Other_Hazards.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards);
      end if;

      if Data_Block.Dof_Models.Three_Dof_Model.Use_Data
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Three_Dof_Models) then
         Data_Block.Dof_Models.Three_Dof_Model.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Three_Dof_Models);
      end if;
      for I in 1..6 loop
         if Data_Block.Dof_Models.Four_Dof_Model.Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Four_Dof_Models(I)) then
            Data_Block.Dof_Models.Four_Dof_Model.Pack
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(I));
         end if;
      end loop;

      for I in 1..10 loop
         if Data_Block.Dof_Models.Six_Dof_Model.Use_Data
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Six_Dof_Models(I)) then
            Data_Block.Dof_Models.Six_Dof_Model.Pack
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(I));
         end if;
      end loop;

      if Data_Block.Recording_Control.Use_Data
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Recording_Control) then
         Data_Block.Recording_Control.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Recording_Control);
      end if;

      Data_Block.Termination.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Termination);

      Data_Block.Expanded_Model.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model);
      Data_Block.Orientation_Command.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Right_Aileron_Orient);
      Data_Block.Orientation_Command.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Left_Aileron_Orient);
      Data_Block.Scale_Command.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Scale);
      Data_Block.Value_Command.Pack
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Value);

      if Data_Block.Expanded_Model.Use_data
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Model.The_Expanded_Model) then
         Data_Block.Expanded_Model.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model);
         Data_Block.Orientation_Command.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Flap_Orient);
         Data_Block.Orientation_Command.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Speed_Brake_Orient);
         Data_Block.Orientation_Command.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Elevator_Orient);
         Data_Block.Orientation_Command.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Rudder_Orient);
         Data_Block.Orientation_Command.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Right_Aileron_Orient);
         Data_Block.Orientation_Command.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Left_Aileron_Orient);
      end if;

      if Data_Block.Expanded_Model.Use_data
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Lightning.The_Expanded_Model) then
         Data_Block.Expanded_Model.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model);
         Data_Block.Value_Command.Pack
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Lightning_Value);
      end if;

      Get_Data_Block;

      Put_Data_Block;

      Data_Block.Ownship_Return.Unpack
        (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return);
      Data_Block.Hot_Return.Unpack
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return,
         Jpats_Radio_Db_If.Terrain_Elevation,
         Integration_Constant);
      Data_Block.Atmosphere_Return.Unpack
        (Fast_Data_Container.This_Receive_Subsystem.The_Atmosphere_Return);
      Data_Block.Celestial_Control_Return.Unpack
        (Fast_Data_Container.This_Receive_Subsystem.The_Celestial_Control_Return);
      for I in 1..17 loop
         Data_Block.Model_Hot_Return.Unpack
           (Fast_Data_Container.This_Receive_Subsystem.
            The_Model_Hot_Return(I));
      end loop;
      Data_Block.Lightning_Return.Unpack
        (Fast_Data_Container.This_Receive_Subsystem.The_Lightning_Return);


      Slow_Data_Container.This_Ios_Interface.Height_of_Terrain :=
        Data_Block.Hot_Return.Terrain_Height
        (Fast_Data_Container.This_Receive_Subsystem.The_Hot_Return);

   exception
      when others =>
         Log.Report ("Jpats_Visual_Buffer-fast_data_controller.Update()");
         raise;

   end Update;

-- Method Put_Data_Block
   procedure Put_Data_Block is
      J : Integer := 1;
      Block_Size : Integer := 0;
      Bytes_Written : Natural := 0;
      Byte_1 : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Byte_2 : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Byte_3 : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Byte_4 : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      J := 1;

      Block_Size := Data_Block.System_Features.Word_Count
        (Slow_Data_Container.This_Slow_Send_Subsystem.The_System_Features);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.System_Features.Data_Word
         (Slow_Data_Container.This_Slow_Send_Subsystem.The_System_Features));
      J := J + Block_Size;

      Block_Size := Data_Block.High_Precision_Ownship_Send.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_High_Precision_Ownship);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.High_Precision_Ownship_Send.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.The_High_Precision_Ownship));
      J := J + Block_Size;

      Block_Size := Data_Block.Ownship_Lobes.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Ownship_Lobes.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.The_Ownship_Lobes));
      J := J + Block_Size;

      Block_Size := Data_Block.Atmosphere_Control.Word_Count
        (Slow_Data_Container.This_Slow_Send_Subsystem.The_Atmosphere_Control);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Atmosphere_Control.Data_Word
         (Slow_Data_Container.This_Slow_Send_Subsystem.
          The_Atmosphere_Control));
      J := J + Block_Size;

      Block_Size := Data_Block.Airport_Control.Word_Count
        (Slow_Data_Container.This_Slow_Send_Subsystem.The_Airport_Control);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Airport_Control.Data_Word
         (Slow_Data_Container.This_Slow_Send_Subsystem.The_Airport_Control));
      J := J + Block_Size;

      Block_Size := Data_Block.Runway_Control.Word_Count
        (Slow_Data_Container.This_Slow_Send_Subsystem.The_Runway_Control);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Runway_Control.Data_Word
         (Slow_Data_Container.This_Slow_Send_Subsystem.The_Runway_Control));
      J := J + Block_Size;

      Block_Size := Data_Block.Celestial_Control.Word_Count
        (Slow_Data_Container.This_Slow_Send_Subsystem.The_Celestial_Control);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Celestial_Control.Data_Word
         (Slow_Data_Container.This_Slow_Send_Subsystem.The_Celestial_Control));
      J := J + Block_Size;

      if (Data_Block.Dof_Models.Three_Dof_Model.Use_Data
          (Fast_Data_Container.This_Fast_Send_Subsystem.
           The_Three_Dof_Models)) then
         Block_Size := Data_Block.Dof_Models.Three_Dof_Model.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Three_Dof_Models);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Dof_Models.Three_Dof_Model.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Three_Dof_Models));
         J := J + Block_Size;
      end if;

      for I in 1..6 loop
         if (Data_Block.Dof_Models.Four_Dof_Model.Use_Data
             (Fast_Data_Container.This_Fast_Send_Subsystem.
              The_Four_Dof_Models(I))) then
            Block_Size := Data_Block.Dof_Models.Four_Dof_Model.Word_Count
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Four_Dof_Models(I));
            Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
              Jpats_Visual_Buffer_Types.Buffer_Array
              (Data_Block.Dof_Models.Four_Dof_Model.Data_Word
               (Fast_Data_Container.This_Fast_Send_Subsystem.
                The_Four_Dof_Models(I)));
            J := J + Block_Size;
         end if;
      end loop;

      for I in 1..10 loop
         if (Data_Block.Dof_Models.Six_Dof_Model.Use_Data
             (Fast_Data_Container.This_Fast_Send_Subsystem.
              The_Six_Dof_Models(I))) then
            Block_Size := Data_Block.Dof_Models.Six_Dof_Model.Word_Count
              (Fast_Data_Container.This_Fast_Send_Subsystem.
               The_Six_Dof_Models(I));
            Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
              Jpats_Visual_Buffer_Types.Buffer_Array
              (Data_Block.Dof_Models.Six_Dof_Model.Data_Word
               (Fast_Data_Container.This_Fast_Send_Subsystem.
                The_Six_Dof_Models(I)));
            J := J + Block_Size;
         end if;
      end loop;

      Block_Size := Data_Block.Hot_Request.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Hot_Request);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Hot_Request.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.The_Hot_Request));
      J := J + Block_Size;

      if (Data_Block.Test_Pattern.Use_Data
          (Slow_Data_Container.This_Slow_Send_Subsystem.The_Test_Pattern)) then
         Block_Size := Data_Block.Test_Pattern.Word_Count
           (Slow_Data_Container.This_Slow_Send_Subsystem.The_Test_Pattern);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Test_Pattern.Data_Word
            (Slow_Data_Container.This_Slow_Send_Subsystem.The_Test_Pattern));
         J := J + Block_Size;
      end if;

      if (Data_Block.Air_Hazards.Use_Data
          (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards)) then
         Block_Size := Data_Block.Air_Hazards.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Air_Hazards.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.The_Air_Hazards));
         J := J + Block_Size;
      end if;

      if (Data_Block.Other_Hazards.Use_Data
          (Fast_Data_Container.This_Fast_Send_Subsystem.
           The_Other_Hazards)) then
         Block_Size := Data_Block.Other_Hazards.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Other_Hazards.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.The_Other_Hazards));
         J := J + Block_Size;
      end if;

      if (Data_Block.Config_Apt_Cntl.Use_Data
          (Slow_Data_Container.This_Slow_Send_Subsystem.
           The_Config_Apt_Cntl)) then
         Block_Size := Data_Block.Config_Apt_Cntl.Word_Count
           (Slow_Data_Container.This_Slow_Send_Subsystem.The_Config_Apt_Cntl);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Config_Apt_Cntl.Data_Word
            (Slow_Data_Container.This_Slow_Send_Subsystem.
             The_Config_Apt_Cntl));
         J := J + Block_Size;
      end if;

      if (Data_Block.Recording_Control.Use_Data
          (Fast_Data_Container.This_Fast_Send_Subsystem.
           The_Recording_Control)) then
         Block_Size := Data_Block.Recording_Control.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Recording_Control);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Recording_Control.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Recording_Control));
         J := J + Block_Size;
      end if;

      Block_Size := Data_Block.Expanded_Model.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Expanded_Model);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Expanded_Model.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.
          The_Jpats_Ownship.The_Expanded_Model));
      J := J + Block_Size;
      Block_Size := Data_Block.Status_Block.Status_Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Control_Status) + 1;
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Status_Block.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.
          The_Jpats_Ownship.The_Control_Status));
      J := J + Block_Size;
      Block_Size := Data_Block.Orientation_Command.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Right_Aileron_Orient);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Orientation_Command.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.
          The_Jpats_Ownship.The_Right_Aileron_Orient));
      J := J + Block_Size;
      Block_Size := Data_Block.Orientation_Command.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Left_Aileron_Orient);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Orientation_Command.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.
          The_Jpats_Ownship.The_Left_Aileron_Orient));
      J := J + Block_Size;
      Block_Size := Data_Block.Scale_Command.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Scale);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Scale_Command.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.
          The_Jpats_Ownship.The_Prop_Scale));
      J := J + Block_Size;
      Block_Size := Data_Block.Value_Command.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.
         The_Jpats_Ownship.The_Prop_Value);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Value_Command.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.
          The_Jpats_Ownship.The_Prop_Value));
      J := J + Block_Size;

      if (Data_Block.Expanded_Model.Use_Data
          (Fast_Data_Container.This_Fast_Send_Subsystem.
           The_Jpats_Model.The_Expanded_Model)) then
         Block_Size := Data_Block.Expanded_Model.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Expanded_Model);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Expanded_Model.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Model.The_Expanded_Model));
         J := J + Block_Size;
         Block_Size := Data_Block.Status_Block.Status_Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Control_Status) + 1;
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Status_Block.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Model.The_Control_Status));
         J := J + Block_Size;
         Block_Size := Data_Block.Orientation_Command.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Flap_Orient);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Orientation_Command.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Model.The_Flap_Orient));
         J := J + Block_Size;
         Block_Size := Data_Block.Orientation_Command.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Speed_Brake_Orient);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Orientation_Command.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Model.The_Speed_Brake_Orient));
         J := J + Block_Size;
         Block_Size := Data_Block.Orientation_Command.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Elevator_Orient);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Orientation_Command.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Model.The_Elevator_Orient));
         J := J + Block_Size;
         Block_Size := Data_Block.Orientation_Command.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Rudder_Orient);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Orientation_Command.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Model.The_Rudder_Orient));
         J := J + Block_Size;
         Block_Size := Data_Block.Orientation_Command.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Right_Aileron_Orient);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Orientation_Command.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Model.The_Right_Aileron_Orient));
         J := J + Block_Size;
         Block_Size := Data_Block.Orientation_Command.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Model.The_Left_Aileron_Orient);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Orientation_Command.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Model.The_Left_Aileron_Orient));
         J := J + Block_Size;
      end if;

      if (Data_Block.Expanded_Model.Use_Data
          (Fast_Data_Container.This_Fast_Send_Subsystem.
           The_Jpats_Lightning.The_Expanded_Model)) then
         Block_Size := Data_Block.Expanded_Model.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Expanded_Model);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Expanded_Model.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Lightning.The_Expanded_Model));
         J := J + Block_Size;
         Block_Size := Data_Block.Status_Block.Status_Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Control_Status) + 1;
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Status_Block.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Lightning.The_Control_Status));
         J := J + Block_Size;
         Block_Size := Data_Block.Value_Command.Word_Count
           (Fast_Data_Container.This_Fast_Send_Subsystem.
            The_Jpats_Lightning.The_Lightning_Value);
         Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
           Jpats_Visual_Buffer_Types.Buffer_Array
           (Data_Block.Value_Command.Data_Word
            (Fast_Data_Container.This_Fast_Send_Subsystem.
             The_Jpats_Lightning.The_Lightning_Value));
         J := J + Block_Size;
      end if;

      Block_Size := Data_Block.Termination.Word_Count
        (Fast_Data_Container.This_Fast_Send_Subsystem.The_Termination);
      Fast_Data_Container.The_Send_Buffer(J..(J+Block_Size-1)) :=
        Jpats_Visual_Buffer_Types.Buffer_Array
        (Data_Block.Termination.Data_Word
         (Fast_Data_Container.This_Fast_Send_Subsystem.The_Termination));
      J := J + Block_Size;

      for I in 1..J-1 loop
         Byte_1 := Fast_Data_Container.The_Send_Buffer(I) and 16#ff000000#;
         Byte_1 := (Byte_1 / 16#01000000#) and 16#000000ff#;
         Byte_2 := Fast_Data_Container.The_Send_Buffer(I) and 16#00ff0000#;
         Byte_2 := (Byte_2 / 16#00000100#) and 16#0000ff00#;
         Byte_3 := Fast_Data_Container.The_Send_Buffer(I) and 16#0000ff00#;
         Byte_3 := (Byte_3 * 16#00000100#) and 16#00ff0000#;
         Byte_4 := Fast_Data_Container.The_Send_Buffer(I) and 16#000000ff#;
         Byte_4 := (Byte_4 * 16#01000000#) and 16#ff000000#;
         Fast_Data_Container.The_Send_Buffer(I) :=
                    Byte_1 + Byte_2 + Byte_3 + Byte_4;
      end loop;

      for I in J..365 loop
         Fast_Data_Container.The_Send_Buffer(I) := 0;
      end loop;

      if Fast_Data_Container.This_Fast_Send_Subsystem.Visual_Transmit then
         if (Io_Medium.Is_Up(Fast_Data_Container.The_Visual_Ethernet)) then

            Io_Medium.Write(Fast_Data_Container.The_Visual_Ethernet,
                            Fast_Data_Container.The_Send_Buffer'Address,
                            1460,
                            Bytes_Written);
         end if;
      end if;

   exception
      when others =>
         Log.Report ("Jpats_Visual_Buffer-fast_data_controller.Put_Data_Block()");
         raise;

   end Put_Data_Block;

-- Method Get_Data_Block
   procedure Get_Data_Block is
      J : Integer := 1;
      Hot_Return_Number : Integer := 1;
      Block_Code : Jpats_Visual_Buffer_Types.Unsigned_Int := 0;
      Block_Size : Integer := 0;
      Bytes_Read : Natural := 0;
      Byte_1 : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Byte_2 : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Byte_3 : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Byte_4 : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin

      Bytes_Read := 0;
      if Fast_Data_Container.This_Fast_Send_Subsystem.Visual_Transmit then
         if (Io_Medium.Is_Up(Fast_Data_Container.The_Visual_Ethernet)) then

            Io_Medium.Read(Fast_Data_Container.The_Visual_Ethernet,
                           Fast_Data_Container.The_Receive_Buffer'Address,
                           1460,
                           Bytes_Read);
         end if;
      end if;

      for I in 1..365 loop
         if (Fast_Data_Container.The_Receive_Buffer(I) /= 0) then
            Byte_1 := Fast_Data_Container.The_Receive_Buffer(I)
              and 16#ff000000#;
            Byte_1 := (Byte_1 / 16#01000000#) and 16#000000ff#;
            Byte_2 := Fast_Data_Container.The_Receive_Buffer(I)
              and 16#00ff0000#;
            Byte_2 := (Byte_2 / 16#00000100#) and 16#0000ff00#;
            Byte_3 := Fast_Data_Container.The_Receive_Buffer(I)
              and 16#0000ff00#;
            Byte_3 := (Byte_3 * 16#00000100#) and 16#00ff0000#;
            Byte_4 := Fast_Data_Container.The_Receive_Buffer(I)
              and 16#000000ff#;
            Byte_4 := (Byte_4 * 16#01000000#) and 16#ff000000#;
            Fast_Data_Container.The_Receive_Buffer(I) :=
                    Byte_1 + Byte_2 + Byte_3 + Byte_4;
         end if;
      end loop;

      Hot_Return_Number := 1;
      J := 1;
      if (Bytes_Read > 0) then

         Block_Code := Fast_Data_Container.The_Receive_Buffer(J) and
           16#Ff000000#;

         if (Block_Code = 16#0e000000#) then
            Block_Size := Data_Block.Ownship_Return.Word_Count
             (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return);
            Data_Block.Ownship_Return.Set_Data_Block
             (Fast_Data_Container.This_Receive_Subsystem.The_Ownship_Return,
              Jpats_Visual_Buffer_Types.Block_Array
              (Fast_Data_Container.The_Receive_Buffer(J..J+Block_Size-1)));
            Data_Block.Ownship_Return.Set_Use_Data
              (Fast_Data_Container.This_Receive_Subsystem.
               The_Ownship_Return, True);
            J := J + Block_Size;

            Block_Code := Fast_Data_Container.The_Receive_Buffer(J)
             and 16#Ff000000#;

            while ( (Block_Code = 16#12000000# ) or
                    (Block_Code = 16#11000000#) or
                    (Block_Code = 16#10000000#) or
                    (Block_Code = 16#0f000000#) or
                    (Block_Code = 16#03000000#) or
                    (Block_Code = 16#25000000#) ) loop
               case Block_Code is
                  when 16#12000000# =>
                     Block_Size := Data_Block.Lightning_Return.Word_Count
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Lightning_Return);
                     Data_Block.Lightning_Return.Set_Data_Block
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Lightning_Return,
                        Jpats_Visual_Buffer_Types.Block_Array
                        (Fast_Data_Container.The_Receive_Buffer
                         (J..J+Block_Size-1)));
                     J := J + Block_Size;
                     Data_Block.Lightning_Return.Set_Use_Data
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Lightning_Return, True);
                  when 16#11000000# =>
                     Block_Size := Data_Block.Model_Hot_Return.Word_Count
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Model_Hot_Return(Hot_Return_Number));
                     Data_Block.Model_Hot_Return.Set_Data_Block
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Model_Hot_Return(Hot_Return_Number),
                        Jpats_Visual_Buffer_Types.Block_Array
                        (Fast_Data_Container.The_Receive_Buffer
                         (J..J+Block_Size-1)));
                     J := J + Block_Size;
                     Hot_Return_Number := Hot_Return_Number + 1;
                     Data_Block.Model_Hot_Return.Set_Use_Data
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Model_Hot_Return(Hot_Return_Number), True);
                  when 16#10000000# =>
                     Block_Size := Data_Block.Hot_Return.Word_Count
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Hot_Return);
                     Data_Block.Hot_Return.Set_Data_Block
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Hot_Return,
                        Jpats_Visual_Buffer_Types.Block_Array
                        (Fast_Data_Container.The_Receive_Buffer
                         (J..J+Block_Size-1)));
                     J := J + Block_Size;
                     Data_Block.Hot_Return.Set_Use_Data
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Hot_Return, True);
                  when 16#0f000000# =>
                     Block_Size := Data_Block.Atmosphere_Return.Word_Count
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Atmosphere_Return);
                     Data_Block.Atmosphere_Return.Set_Data_Block
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Atmosphere_Return,
                        Jpats_Visual_Buffer_Types.Block_Array
                        (Fast_Data_Container.The_Receive_Buffer
                         (J..J+Block_Size-1)));
                     J := J + Block_Size;
                     Data_Block.Atmosphere_Return.Set_Use_Data
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Atmosphere_Return, True);
                  when 16#25000000# =>
                     Block_Size := Data_Block.Celestial_Control_Return.Word_Count
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Celestial_Control_Return);
                     Data_Block.Celestial_Control_Return.Set_Data_Block
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Celestial_Control_Return,
                        Jpats_Visual_Buffer_Types.Block_Array
                        (Fast_Data_Container.The_Receive_Buffer
                         (J..J+Block_Size-1)));
                     J := J + Block_Size;
                     Data_Block.Celestial_Control_Return.Set_Use_Data
                       (Fast_Data_Container.This_Receive_Subsystem.
                        The_Celestial_Control_Return, True);
                  when 16#03000000# =>
                     Block_Size := Data_Block.Runway_Control.Word_Count
                       (Slow_Data_Container.This_Slow_Send_Subsystem.
                        The_Runway_Control);
                     J := J + Block_Size;
                  when others =>
                     null;
               end case;
               Block_Code := Fast_Data_Container.The_Receive_Buffer(J)
                 and 16#Ff000000#;
           end loop;
         end if;
      end if;

   exception
      when others =>
         Log.Report ("Jpats_Visual_Buffer-fast_data_controller.Get_Data_Block()");
         raise;

   end Get_Data_Block;

end JPATS_Visual_Buffer.Fast_Data_Controller;