-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block.High_Precision_Ownship_Send;
with Data_Block.Ownship_Lobes;
with Data_Block.Hot_Request;
with Data_Block.Air_Hazards;
with Data_Block.Other_Hazards;
with Data_Block.Dof_Models.Three_Dof_Model;
with Data_Block.Dof_Models.Four_Dof_Model;
with Data_Block.Dof_Models.Six_Dof_Model;
with Data_Block.Recording_Control;
with Data_Block.Ownship_Return;
with Data_Block.Atmosphere_Return;
with Data_Block.Celestial_Control_Return;
with Data_Block.Hot_Return;
with Data_Block.Model_Hot_Return;
with Data_Block.Lightning_Return;
with Data_Block.Termination;
with Data_Block.Expanded_Model;
with Data_Block.Status_Block;
with Data_Block.Motion_Command;
with Data_Block.Scale_Command;
with Data_Block.Orientation_Command;
with Data_Block.Position_Command;
with Data_Block.Six_Dof_Command;
with Data_Block.Value_Command;
with Io_Medium;
with Io_Medium.Udp;

private package JPATS_Visual_Buffer.Fast_Data_Container is

   type Four_Dof_Array is array (1..7) of
     Data_Block.Dof_Models.Four_Dof_Model.Instance;
   type Six_Dof_Array is array (1..10) of
     Data_Block.Dof_Models.Six_Dof_Model.Instance;
   type Model_Hot_Array is array (1..17) of
     Data_Block.Model_Hot_Return.Instance;

   type Jpats_Model_Instance is record
      The_Expanded_Model : Data_Block.Expanded_Model.Instance;
      The_Control_Status : Data_Block.Status_Block.Instance;
      The_Flap_Orient : Data_Block.Orientation_Command.Instance;
      The_Speed_Brake_Orient : Data_Block.Orientation_Command.Instance;
      The_Elevator_Orient : Data_Block.Orientation_Command.Instance;
      The_Rudder_Orient : Data_Block.Orientation_Command.Instance;
      The_Right_Aileron_Orient : Data_Block.Orientation_Command.Instance;
      The_Left_Aileron_Orient : Data_Block.Orientation_Command.Instance;
   end record;

   type Jpats_Ownship_Model is record
      The_Expanded_Model : Data_Block.Expanded_Model.Instance;
      The_Control_Status : Data_Block.Status_Block.Instance;
      The_Right_Aileron_Orient : Data_Block.Orientation_Command.Instance;
      The_Left_Aileron_Orient : Data_Block.Orientation_Command.Instance;
      The_Prop_Scale : Data_Block.Scale_Command.Instance;
      The_Prop_Value : Data_Block.Value_Command.Instance;
   end record;

   type Jpats_Lightning_Model is record
      The_Expanded_Model : Data_Block.Expanded_Model.Instance;
      The_Control_Status : Data_Block.Status_Block.Instance;
      The_Lightning_Value : Data_Block.Value_Command.Instance;
   end record;

   type Fast_Send_Instance is record
      The_High_Precision_Ownship : Data_Block.High_Precision_Ownship_Send.Instance;
      The_Ownship_Lobes : Data_Block.Ownship_Lobes.Instance;
      The_Hot_Request : Data_Block.Hot_Request.Instance;
      The_Air_Hazards : Data_Block.Air_Hazards.Instance;
      The_Other_Hazards : Data_Block.Other_Hazards.Instance;
      The_Three_Dof_Models : Data_Block.Dof_Models.Three_Dof_Model.Instance;
      The_Four_Dof_Models : Four_Dof_Array;
      The_Six_Dof_Models : Six_Dof_Array;
      The_Recording_Control : Data_Block.Recording_Control.Instance;
      The_Termination : Data_Block.Termination.Instance;
      Visual_Transmit : Boolean;
      The_Jpats_Model : Jpats_Model_Instance;
      The_Jpats_Ownship : Jpats_Ownship_Model;
      The_Jpats_Lightning : Jpats_Lightning_Model;
   end record;

   type Receive_Instance is record
      The_Ownship_Return : Data_Block.Ownship_Return.Instance;
      The_Atmosphere_Return : Data_Block.Atmosphere_Return.Instance;
      The_Celestial_Control_Return : Data_Block.Celestial_Control_Return.Instance;
      The_Hot_Return : Data_Block.Hot_Return.Instance;
      The_Model_Hot_Return : Model_Hot_Array;
      The_Lightning_Return : Data_Block.Lightning_Return.Instance;
   end record;

   This_Fast_Send_Subsystem : Fast_Send_Instance;

   This_Receive_Subsystem : Receive_Instance;

   The_Send_Buffer : Jpats_Visual_Buffer_Types.Buffer_Array(1..365);

   The_Receive_Buffer : Jpats_Visual_Buffer_Types.Buffer_Array(1..365);

   The_Visual_Ethernet : Io_Medium.Handle;

end JPATS_Visual_Buffer.Fast_Data_Container;
