-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;

package Data_Block is


  type Instance is tagged private;

-- Access Data_Block_Code
   function  Data_Block_Code (An_Instance : in Instance) return Integer;
   procedure Set_Data_Block_Code
     (An_Instance : in out Instance;
      A_Code : in Integer);

-- Access Use_Data
   function  Use_Data (An_Instance : in Instance) return Boolean;
   procedure Set_Use_Data
     (An_Instance : in out Instance;
      Data_Valid : in Boolean);

-- Access Word_Count
   function Word_Count (An_Instance : in Instance) return Integer;

-- Method Pack
   procedure Pack (An_Instance : in out Instance);

-- Method Unpack
   procedure Unpack (An_Instance : in out Instance);


private

  type Instance is tagged record
    Data_Block_Code : Integer;
    Use_Data : Boolean;
    Word_Count : Natural;
  end record;


end Data_Block;
