-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Value_Command is


-- Access Control
   function  Control
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Control;
   end Control;

   procedure Set_Control
     (An_Instance : in out Instance;
      A_Control : in Integer) is
   begin
      An_Instance.Control := A_Control;
   end Set_Control;

-- Access Value
   function  Value
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Value;
   end Value;

   procedure Set_Value
     (An_Instance : in out Instance;
      A_Value : in Float) is
   begin
      An_Instance.Value := A_Value;
   end Set_Value;


   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 2;
      An_Instance.Data_Block_Code := 16#07000000#;
      An_Instance.Use_Data := False;

      An_Instance.Control := 0;
      An_Instance.Value := 0.0;
      An_Instance.Value_Command_Block(1) := 0;
      An_Instance.Value_Command_Block(2) := 0;
   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
      Scaled_Value : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.Value_Command_Block(I) := 0;
      end loop;

      An_Instance.Value_Command_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      An_Instance.Value_Command_Block(1) :=
        An_Instance.Value_Command_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Control) * 16#00010000#;

      An_Instance.Value_Command_Block(2) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Value *
                 Jpats_Visual_Buffer_Types.Sb23_Scale));

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.Value_Command_Block;
   end Data_Word;


end Data_Block.Value_Command;
