-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;
with Lat_Long_Types;

package Data_Block.Test_Pattern is


  type Instance is new Data_Block.Instance with private;

-- Access Name
  function  Name (An_Instance : in Instance)
                  return Jpats_Visual_Buffer_Types.Test_Name_String;
   procedure Set_Name
     (An_Instance : in out Instance;
      A_Name : in Jpats_Visual_Buffer_Types.Test_Name_String);

-- Access Heading
   function  Heading (An_Instance : in Instance) return Float;
   procedure Set_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float);

-- Access Latitude
   function  Position (An_Instance : in Instance)
     return Lat_Long_Types.Position;
   procedure Set_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position);

-- Data_Block Methods
   procedure Initialize (An_Instance : in out Instance);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

  type Instance is new Data_Block.Instance with record
    Name : Jpats_Visual_Buffer_Types.Test_Name_String;
    Heading : Float;
    Position : Lat_Long_Types.Position;
    The_Test_Pattern_Block : Jpats_Visual_Buffer_Types.Block_Array (1..6);
  end record;


end Data_Block.Test_Pattern;
