-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Visual_Airport_Utilities;

package body Data_Block.Test_Pattern is


-- Access Name
   function  Name
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Test_Name_String is
   begin
      return An_Instance.Name;
   end Name;

   procedure Set_Name
     (An_Instance : in out Instance;
      A_Name : in Jpats_Visual_Buffer_Types.Test_Name_String) is
   begin
      An_Instance.Name := A_Name;
   end Set_Name;

-- Access Heading
   function  Heading
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Heading;
   end Heading;

   procedure Set_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      An_Instance.Heading := A_Heading;
   end Set_Heading;

-- Access Position
   function  Position
     (An_Instance : in Instance)
      return Lat_Long_Types.Position is
   begin
      return An_Instance.Position;
   end Position;

   procedure Set_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position) is
   begin
      An_Instance.Position := A_Position;
   end Set_Position;


   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 6;
      An_Instance.Data_Block_Code := 16#0d000000#;
      An_Instance.Use_Data := False;

      An_Instance.Name := "        ";
      An_Instance.Heading := 0.0;
      An_Instance.Position.Latitude := 0.0;
      An_Instance.Position.Longitude := 0.0;
      An_Instance.Position.Altitude := 0.0;

      for I in 1..6 loop
         An_Instance.The_Test_Pattern_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
      Int_Letter : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_Test_Pattern_Block(I) := 0;
      end loop;

      An_Instance.The_Test_Pattern_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);

      if (An_Instance.Name(1) = ' ') then
         Int_Letter := 0;
      else
         Int_Letter := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Character'Pos(An_Instance.Name(1)));
      end if;
      An_Instance.The_Test_Pattern_Block(1) :=
        An_Instance.The_Test_Pattern_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(Int_Letter * 16#00000100#);
      if (An_Instance.Name(2) = ' ') then
         Int_Letter := 0;
      else
         Int_Letter := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Character'Pos(An_Instance.Name(2)));
      end if;
      An_Instance.The_Test_Pattern_Block(1) :=
        An_Instance.The_Test_Pattern_Block(1) + Int_Letter;

      for I in 3..6 loop
         if (An_Instance.Name(I) = ' ') then
            Int_Letter := 0;
         else
            Int_Letter := Jpats_Visual_Buffer_Types.Unsigned_Int
              (Character'Pos(An_Instance.Name(I)));
         end if;
         An_Instance.The_Test_Pattern_Block(2) :=
           An_Instance.The_Test_Pattern_Block(2) +
           Jpats_Visual_Buffer_Types.Unsigned_Int(Int_Letter * 256**(6-I));
      end loop;

      for I in 7..8 loop
         if (An_Instance.Name(I) = ' ') then
            Int_Letter := 0;
         else
            Int_Letter := Jpats_Visual_Buffer_Types.Unsigned_Int
              (Character'Pos(An_Instance.Name(I)));
         end if;
         An_Instance.The_Test_Pattern_Block(3) :=
           An_Instance.The_Test_Pattern_Block(3) +
           Jpats_Visual_Buffer_Types.Unsigned_Int(Int_Letter * 256**(10-I));
      end loop;

      An_Instance.The_Test_Pattern_Block(3) :=
        An_Instance.The_Test_Pattern_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(Visual_Airport_Utilities.Xn180(An_Instance.Heading) *
                 Jpats_Visual_Buffer_Types.Bams_16bit));

      An_Instance.The_Test_Pattern_Block(4) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Position.Latitude *
                 Jpats_Visual_Buffer_Types.Bams_32bit));

      An_Instance.The_Test_Pattern_Block(5) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Position.Longitude *
                 Jpats_Visual_Buffer_Types.Bams_32bit));

      An_Instance.The_Test_Pattern_Block(6) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Position.Altitude) * 16#00000100#);
   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Test_Pattern_Block;
   end Data_Word;


end Data_Block.Test_Pattern;
