-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Termination is


-- Access Data_Transfer_Seq_Num
   function  Data_Transfer_Seq_Num
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Data_Transfer_Seq_Num;
   end Data_Transfer_Seq_Num;

   procedure Set_Data_Transfer_Seq_Num
     (An_Instance : in out Instance;
      A_Seq_Num : in Integer) is
   begin
      An_Instance.Data_Transfer_Seq_Num := A_Seq_Num;
   end Set_Data_Transfer_Seq_Num;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 1;
      An_Instance.Data_Block_Code := 16#13000000#;
      An_Instance.Use_Data := True;

      An_Instance.Data_Transfer_Seq_Num := 1;
      An_Instance.The_Termination_Block(1) := 0;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
   begin
      An_Instance.Data_Transfer_Seq_Num :=
        An_Instance.Data_Transfer_Seq_Num + 1;
      if (An_Instance.Data_Transfer_Seq_Num > 8388607) then
         An_Instance.Data_Transfer_Seq_Num := 0;
      end if;

      An_Instance.The_Termination_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Data_Transfer_Seq_Num);
   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Termination_Block;
   end Data_Word;


end Data_Block.Termination;
