-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Data_Block;
with Jpats_Visual_Buffer_Types;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.System_Features is


  type Instance is new Data_Block.Instance with private;

-- Access Visual_Freeze
   function  Visual_Freeze (An_Instance : in Instance) return Boolean;
   procedure Set_Visual_Freeze
     (An_Instance : in out Instance;
      Freeze_Visual : in Boolean);

-- Access Visual_On_Off
   function  Visual_On_Off (An_Instance : in Instance) return Boolean;
   procedure Set_Visual_On_Off
     (An_Instance : in out Instance;
      Visual_On : in Boolean);

-- Access Generic_Scene_Type
   function  Generic_Scene_Type (An_Instance : in Instance) return Boolean;
   procedure Set_Generic_Scene_Type
     (An_Instance : in out Instance;
      Scene_Type : in Boolean);

-- Access Crash_Indicator
   function  Crash_Indicator (An_Instance : in Instance) return Boolean;
   procedure Set_Crash_Indicator
     (An_Instance : in out Instance;
      Crash_On : in Boolean);

-- Access Persistence_Reset
   function  Persistence_Reset (An_Instance : in Instance) return Boolean;
   procedure Set_Persistence_Reset
     (An_Instance : in out Instance;
      Reset_Persistence : in Boolean);

-- Access Window_Select
   function  Window_Select (An_Instance : in Instance) return Boolean;
   procedure Set_Window_Select
     (An_Instance : in out Instance;
      Selected_Window : in Boolean);

-- Access Morning_Readiness_TST
   function  Morning_Readiness_TST (An_Instance : in Instance) return Integer;
   procedure Set_Morning_Readiness_TST
     (An_Instance : in out Instance;
      Test_Number : in Integer);

-- Access Eyepoint_Select
   function  Eyepoint_Select (An_Instance : in Instance) return Integer;
   procedure Set_Eyepoint_Select
     (An_Instance : in out Instance;
      Selected_Eyepoint : in Integer);

-- Access Coordinate_System
   function  Coordinate_System (An_Instance : in Instance) return Integer;
   procedure Set_Coordinate_System
     (An_Instance : in out Instance;
      A_Coordinate_System : in Integer);

-- Access Host_Buffer_Save
   function  Host_Buffer_Save (An_Instance : in Instance) return Boolean;
   procedure Set_Host_Buffer_Save
     (An_Instance : in out Instance;
      Save_Buffer : in Boolean);

-- Access Data_Block
   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;

-- Initialize Method
   procedure Initialize (An_Instance : in out Instance);

-- Method Pack
   procedure Pack (An_Instance : in out Instance);

-- Method Determine_Visual_On_Off
   procedure Determine_Visual_On_Off
     (An_Instance : in out Instance;
      Ac_Lat : in Long_Float;
      Ac_Lon : in Long_Float;
      Ac_Pitch : in Float;
      Ac_Roll : in Float;
      Ac_Yaw : in Float;
      Integration_Constant : in Float);


private

   type Instance is new Data_Block.Instance with record
      Visual_Freeze : Boolean;
      Visual_On_Off : Boolean;
      Generic_Scene_Type : Boolean;
      Crash_Indicator : Boolean;
      Persistence_Reset : Boolean;
      Window_Select : Boolean;
      Morning_Readiness_TST : Integer;
      Eyepoint_Select : Integer;
      Coordinate_System : Integer;
      Host_Buffer_Save : Boolean;
      The_System_Block : Jpats_Visual_Buffer_Types.Block_Array (1..1);
   end record;


end Data_Block.System_Features;
