-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.System_Features is

   Max_Time : constant := 900.0;  --15 minutes time out
   Visual_On_Off_Timer : Float := 0.0;
   Last_Lat : Long_Float;
   Last_Lon : Long_Float;
   Last_Pitch : Float;
   Last_Roll : Float;
   Last_Yaw : Float;

-- Access Visual_Freeze
   function  Visual_Freeze
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Visual_Freeze;
   end Visual_Freeze;

   procedure Set_Visual_Freeze
     (An_Instance : in out Instance;
      Freeze_Visual : in Boolean) is
   begin
      An_Instance.Visual_Freeze := Freeze_Visual;
   end Set_Visual_Freeze;

-- Access Visual_On_Off
   function  Visual_On_Off
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Visual_On_Off;
   end Visual_On_Off;

   procedure Set_Visual_On_Off
     (An_Instance : in out Instance;
      Visual_On : in Boolean) is
   begin
      An_Instance.Visual_On_Off := Visual_On;
      Visual_On_Off_Timer := Max_Time;
   end Set_Visual_On_Off;

-- Access Generic_Scene_Type
   function  Generic_Scene_Type
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Generic_Scene_Type;
   end Generic_Scene_Type;

   procedure Set_Generic_Scene_Type
     (An_Instance : in out Instance;
      Scene_Type : in Boolean) is
   begin
      An_Instance.Generic_Scene_Type := Scene_Type;
   end Set_Generic_Scene_Type;

-- Access Crash_Indicator
   function  Crash_Indicator
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Crash_Indicator;
   end Crash_Indicator;

   procedure Set_Crash_Indicator
     (An_Instance : in out Instance;
      Crash_On : in Boolean) is
   begin
      An_Instance.Crash_Indicator := Crash_On;
   end Set_Crash_Indicator;

-- Access Persistence_Reset
   function  Persistence_Reset
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Persistence_Reset;
   end Persistence_Reset;

   procedure Set_Persistence_Reset
     (An_Instance : in out Instance;
      Reset_Persistence : in Boolean) is
   begin
      An_Instance.Persistence_Reset := Reset_Persistence;
   end Set_Persistence_Reset;

-- Access Window_Select
   function  Window_Select
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Window_Select;
   end Window_Select;

   procedure Set_Window_Select
     (An_Instance : in out Instance;
      Selected_Window : in Boolean) is
   begin
      An_Instance.Window_Select := Selected_Window;
   end Set_Window_Select;

-- Access Morning_Readiness_TST
   function  Morning_Readiness_TST
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Morning_Readiness_TST;
   end Morning_Readiness_TST;

   procedure Set_Morning_Readiness_TST
     (An_Instance : in out Instance;
      Test_Number : in Integer) is
   begin
      An_Instance.Morning_Readiness_Tst := Test_Number;
   end Set_Morning_Readiness_TST;

-- Access Eyepoint_Select
   function  Eyepoint_Select
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Eyepoint_Select;
   end Eyepoint_Select;

   procedure Set_Eyepoint_Select
     (An_Instance : in out Instance;
      Selected_Eyepoint : in Integer) is
   begin
      An_Instance.Eyepoint_Select := Selected_Eyepoint;
   end Set_Eyepoint_Select;

-- Access Coordinate_System
   function  Coordinate_System
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Coordinate_System;
   end Coordinate_System;

   procedure Set_Coordinate_System
     (An_Instance : in out Instance;
      A_Coordinate_System : in Integer) is
   begin
      An_Instance.Coordinate_System := A_Coordinate_System;
   end Set_Coordinate_System;

-- Access Host_Buffer_Save
   function  Host_Buffer_Save
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Host_Buffer_Save;
   end Host_Buffer_Save;

   procedure Set_Host_Buffer_Save
     (An_Instance : in out Instance;
      Save_Buffer : in Boolean) is
   begin
      An_Instance.Host_Buffer_Save := Save_Buffer;
   end Set_Host_Buffer_Save;

-- Access Data_Block
   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_System_Block;
   end Data_Word;

-- Method Pack
   procedure Pack
     (An_Instance : in out Instance) is
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_System_Block(I) := 0;
      end loop;

      An_Instance.The_System_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);

      if (An_Instance.Visual_Freeze) then
         An_Instance.The_System_Block(1) :=
           An_Instance.The_System_Block(1) + 16#00800000#;
      end if;

      if (An_Instance.Visual_On_Off) then
         An_Instance.The_System_Block(1) :=
           An_Instance.The_System_Block(1) + 16#00400000#;
      end if;

      if (An_Instance.Host_Buffer_Save) then
         An_Instance.The_System_Block(1) :=
           An_Instance.The_System_Block(1) + 16#00200000#;
      end if;

      if (An_Instance.Generic_Scene_Type) then
         An_Instance.The_System_Block(1) :=
           An_Instance.The_System_Block(1) + 16#00100000#;
      end if;

      -- if (An_Instance.Crash_Indicator) then
      --    An_Instance.The_System_Block(1) :=
      --      An_Instance.The_System_Block(1) + 16#00080000#;
      -- end if;

      if (An_Instance.Persistence_Reset) then
         An_Instance.The_System_Block(1) :=
           An_Instance.The_System_Block(1) + 16#00040000#;
      end if;

      if (An_Instance.Window_Select) then
         An_Instance.The_System_Block(1) :=
           An_Instance.The_System_Block(1) + 16#00020000#;
      end if;

      An_Instance.The_System_Block(1) :=
        An_Instance.The_System_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Morning_Readiness_Tst) * 16#00000100#;

      An_Instance.The_System_Block(1) :=
        An_Instance.The_System_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Eyepoint_Select) * 16#00000020#;

      An_Instance.The_System_Block(1) :=
        An_Instance.The_System_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Coordinate_System);

   end Pack;

-- Method Initialize
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 1;
      An_Instance.Data_Block_Code := 0;
      An_Instance.Use_Data := True;

      An_Instance.Visual_Freeze := False;
      An_Instance.Visual_On_Off := True;
      An_Instance.Generic_Scene_Type := False;
      An_Instance.Crash_Indicator := False;
      An_Instance.Persistence_Reset := False;
      An_Instance.Window_Select := False;
      An_Instance.Morning_Readiness_Tst := 0;
      An_Instance.Eyepoint_Select := 0;
      An_Instance.Coordinate_System := 3;
      An_Instance.Host_Buffer_Save := False;
      An_Instance.The_System_Block(1) := 0;

   end Initialize;

-- Method Determine_Visual_On_Off
   procedure Determine_Visual_On_Off
     (An_Instance : in out Instance;
      Ac_Lat : in Long_Float;
      Ac_Lon : in Long_Float;
      Ac_Pitch : in Float;
      Ac_Roll : in Float;
      Ac_Yaw : in Float;
      Integration_Constant : in Float) is
      Delta_Lat : Long_Float;
      Delta_Lon : Long_Float;
      Delta_Pitch : Float;
      Delta_Roll : Float;
      Delta_Yaw : Float;
   begin
      Delta_Lat := Ac_Lat - Last_Lat;
      Delta_Lon := Ac_Lon - Last_Lon;
      Delta_Pitch := Ac_Pitch - Last_Pitch;
      Delta_Roll := Ac_Roll - Last_Roll;
      Delta_Yaw := Ac_Yaw - Last_Yaw;

      if (( Delta_Lat >= 0.000001 ) or
          ( Delta_Lon >= 0.000001 ) or
          ( Delta_Pitch >= 0.1 ) or
          ( Delta_Roll  >= 0.1 ) or
          ( Delta_Yaw   >= 0.1 )) then
         Visual_On_Off_Timer := Max_Time;
         An_Instance.Visual_On_Off := True;

         Last_Lat := Ac_Lat;
         Last_Lon := Ac_Lon;
         Last_Pitch := Ac_Pitch;
         Last_Roll := Ac_Roll;
         Last_Yaw := Ac_Yaw;

      elsif (An_Instance.Visual_On_Off and (Visual_On_Off_Timer > 0.0)) then
         Visual_On_Off_Timer := Visual_On_Off_Timer - Integration_Constant;
      else
         An_Instance.Visual_On_Off := False;
      end if;
   end Determine_Visual_On_Off;


end Data_Block.System_Features;
