-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Status_Block is


-- Access Control
   function  Control
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Control;
   end Control;

   procedure Set_Control
     (An_Instance : in out Instance;
      A_Control : in Integer) is
   begin
      An_Instance.Control := A_Control;
   end Set_Control;

-- Access Command_Count
   function  Command_Count
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Command_Count;
   end Command_Count;

   procedure Set_Command_Count
     (An_Instance : in out Instance;
      A_Count : in Integer) is
   begin
      An_Instance.Command_Count := A_Count;
   end Set_Command_Count;

-- Access Status_Word_Count
   function  Status_Word_Count
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Status_Word_Count;
   end Status_Word_Count;

   procedure Set_Status_Word_Count
     (An_Instance : in out Instance;
      A_Count : in Integer) is
   begin
      An_Instance.Status_Word_Count := A_Count;
   end Set_Status_Word_Count;


   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 16;
      An_Instance.Data_Block_Code := 16#01000000#;
      An_Instance.Use_Data := False;

      An_Instance.Control := 0;
      An_Instance.Command_Count := 0;
      An_Instance.Status_Word_Count := 0;
      for I in 1..16 loop
         An_Instance.Host_Status_Block(i) := 0;
      end loop;
   end Initialize;

   procedure Set_Model_Control
     (An_Instance : in out Instance;
      A_Control : in Integer) is
      Offset : Integer;
      Word_Index : Integer;
      Control_Value : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      Offset := A_Control/32;
      Word_Index := A_Control - Offset*32;
      Control_Value := 16#00000001#;
      for I in 1..Word_Index loop
        Control_Value := Control_Value * 2;
      end loop;

      An_Instance.Host_Status_Block(Offset+2) :=
        An_Instance.Host_Status_Block(Offset+2) + Control_Value;

   end Set_Model_Control;

   procedure Pack
     (An_Instance : in out Instance) is
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.Host_Status_Block(I) := 0;
      end loop;

      An_Instance.Host_Status_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      An_Instance.Host_Status_Block(1) :=
        An_Instance.Host_Status_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Command_Count) * 16#00010000#;
      An_Instance.Host_Status_Block(1) :=
        An_Instance.Host_Status_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Status_Word_Count) * 16#00001000#;

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.Host_Status_Block(1..An_Instance.Status_Word_Count+1);
   end Data_Word;


end Data_Block.Status_Block;
