-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Six_Dof_Command is


-- Access Control
   function  Control
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Control;
   end Control;

   procedure Set_Control
     (An_Instance : in out Instance;
      A_Control : in Integer) is
   begin
      An_Instance.Control := A_Control;
   end Set_Control;

-- Access Yaw
   function  Yaw
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Yaw;
   end Yaw;

   procedure Set_Yaw
     (An_Instance : in out Instance;
      An_Angle : in Float) is
   begin
      An_Instance.Yaw := An_Angle;
   end Set_Yaw;

-- Access Roll
   function  Roll
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Roll;
   end Roll;

   procedure Set_Roll
     (An_Instance : in out Instance;
      An_Angle : in Float) is
   begin
      An_Instance.Roll := An_Angle;
   end Set_Roll;

-- Access Pitch
   function  Pitch
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Pitch;
   end Pitch;

   procedure Set_Pitch
     (An_Instance : in out Instance;
      An_Angle : in Float) is
   begin
      An_Instance.Pitch := An_Angle;
   end Set_Pitch;

-- Access X_Position
   function  X_Position
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.X_Position;
   end X_Position;

   procedure Set_X_Position
     (An_Instance : in out Instance;
      A_Position : in Float) is
   begin
      An_Instance.X_Position := A_Position;
   end Set_X_Position;

-- Access Y_Position
   function  Y_Position
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Y_Position;
   end Y_Position;

   procedure Set_Y_Position
     (An_Instance : in out Instance;
      A_Position : in Float) is
   begin
      An_Instance.Y_Position := A_Position;
   end Set_Y_Position;

-- Access Z_Position
   function  Z_Position
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Z_Position;
   end Z_Position;

   procedure Set_Z_Position
     (An_Instance : in out Instance;
      A_Position : in Float) is
   begin
      An_Instance.Z_Position := A_Position;
   end Set_Z_Position;


   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 5;
      An_Instance.Data_Block_Code := 16#06000000#;
      An_Instance.Use_Data := False;

      An_Instance.Control := 0;
      An_Instance.Yaw := 0.0;
      An_Instance.Roll := 0.0;
      An_Instance.Pitch := 0.0;
      An_Instance.X_Position := 0.0;
      An_Instance.Y_Position := 0.0;
      An_Instance.Z_Position := 0.0;
      An_Instance.Six_Dof_Command_Block(1):= 0;
      An_Instance.Six_Dof_Command_Block(2) := 0;
      An_Instance.Six_Dof_Command_Block(3) := 0;
      An_Instance.Six_Dof_Command_Block(4) := 0;
      An_Instance.Six_Dof_Command_Block(5) := 0;
   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
      Scaled_Value : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.Six_Dof_Command_Block(I) := 0;
      end loop;

      An_Instance.Six_Dof_Command_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      An_Instance.Six_Dof_Command_Block(1) :=
        An_Instance.Six_Dof_Command_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Control) * 16#00010000#;
      Scaled_Value := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Yaw *
                 Jpats_Visual_Buffer_Types.Sb1_Scale))
        and 16#0000ffff#;
      An_Instance.Six_Dof_Command_Block(1) :=
        An_Instance.Six_Dof_Command_Block(1) + Scaled_Value;

      Scaled_Value := (Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Roll *
                 Jpats_Visual_Buffer_Types.Sb1_Scale))
        and 16#0000ffff#) * 16#00010000#;
      An_Instance.Six_Dof_Command_Block(2) := Scaled_Value;
      Scaled_Value := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Pitch *
                 Jpats_Visual_Buffer_Types.Sb1_Scale))
        and 16#0000ffff#;
      An_Instance.Six_Dof_Command_Block(2) :=
        An_Instance.Six_Dof_Command_Block(2) + Scaled_Value;

      An_Instance.Six_Dof_Command_Block(3) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.X_Position *
         Jpats_Visual_Buffer_Types.Sb23_Scale));

      An_Instance.Six_Dof_Command_Block(4) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Y_Position *
         Jpats_Visual_Buffer_Types.Sb23_Scale));

      An_Instance.Six_Dof_Command_Block(5) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Z_Position *
         Jpats_Visual_Buffer_Types.Sb23_Scale));

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.Six_Dof_Command_Block;
   end Data_Word;


end Data_Block.Six_Dof_Command;
