-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim F. Narrin
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-- This is the package that handles the runway control data block

with JPATS_Visual_Buffer_Types;
with Data_Block;
use type JPATS_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Runway_Control is

   type Instance is new Data_Block.Instance with private;


 -- Procedures for setting the attributes of the class
   procedure Set_Read_Write_Request
     (An_Instance : in out Instance;
      A_Request : in Boolean);

   procedure Set_Request_Number
     (An_Instance : in out Instance;
      A_Request : in Integer);

   procedure Set_Runway_Number
     (An_Instance : in out Instance;
      A_Runway_Number : in Integer);

   procedure Set_Runway_Letter
     (An_Instance : in out Instance;
      A_Runway_Letter : in Integer);

   procedure Set_Wet_Contamination
     (An_Instance : in out Instance;
      The_Wet_Contamination : in Boolean);

   procedure Set_Icy_Contamination
     (An_Instance : in out Instance;
      The_Icy_Contamination : in Boolean);

   procedure Set_Snow_Contamination
     (An_Instance : in out Instance;
      The_Snow_Contamination : in Boolean);

   procedure Set_Slush_Contamination
     (An_Instance : in out Instance;
      The_Slush_Contamination : in Boolean);

   procedure Set_Patchy_Contamination
     (An_Instance : in out Instance;
      The_Patchy_Contamination : in Boolean);

   procedure Set_MIRL_HIRL_Select
     (An_Instance : in out Instance;
      MIRL_HIRL_Selected : in Boolean);

   procedure Set_Approach_LI
     (An_Instance : in out Instance;
      An_Intensity : Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Runway_Edge_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Center_Line_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Runway_SI
      (An_Instance : in out Instance;
       An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Runway_MI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Runway_Strobe_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_VASI_PAPI_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_REIL_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Fixed_Distance_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Threshold_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Stop_Bar_Light_Select
     (An_Instance : in out Instance;
      Stop_Bar_Light_Selected : in Boolean);

   procedure Set_Touchdown_Zone_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_AGL_LDIN_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Runway_End_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity);

   procedure Set_Airport_Ident
     (An_Instance : in out Instance;
      An_Airport_Ident : in Jpats_Visual_Buffer_Types.Airport_Name_Type);

-- Functions for returning the class attributes
   function Read_Write_Request
     (An_Instance : in Instance)
      return Boolean;

   function Request_Number
     (An_Instance : in Instance)
      return Integer;

   function Runway_Number
     (An_Instance : in Instance)
      return Integer;

   function Runway_Letter
     (An_Instance : in Instance)
      return Integer;

   function Wet_Contamination
     (An_Instance : in Instance)
      return Boolean;

   function Icy_Contamination
     (An_Instance : in Instance)
      return Boolean;

   function Snow_Contamination
     (An_Instance : in Instance)
      return Boolean;

   function Slush_Contamination
     (An_Instance : in Instance)
      return Boolean;

   function Patchy_Contamination
     (An_Instance : in Instance)
      return Boolean;

   function MIRL_HIRL_Select
     (An_Instance : in Instance)
      return Boolean;

   function Approach_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Runway_Edge_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Center_Line_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Runway_SI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Runway_MI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Runway_Strobe_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function VASI_PAPI_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function REIL_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Fixed_Distance_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Threshold_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Stop_Bar_Light_Select
     (An_Instance : in Instance)
      return Boolean;

   function Touchdown_Zone_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function AGL_LDIN_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Runway_End_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity;

   function Airport_Ident
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Airport_Name_Type;

 -- Procedure prototype overrides
   procedure Initialize
     (An_Instance :in out Instance);

   procedure Pack
     (An_Instance: in out Instance);

-- Access Data_Block
   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;

private

    type Instance is new Data_Block.Instance with
        record
            Read_Write_Request : Boolean;  -- true = write
            Request_Number : Integer;
            Runway_Number : Integer;
            Runway_Letter : Integer;
            Wet_Contamination : Boolean;
            Icy_Contamination : Boolean;
            Snow_Contamination : Boolean;
            Slush_Contamination : Boolean;
            Patchy_Contamination : Boolean;
            MIRL_HIRL_Select : Boolean;
            Approach_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Runway_Edge_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Center_Line_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Runway_SI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Runway_MI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Runway_Strobe_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            VASI_PAPI_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            REIL_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Fixed_Distance_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Threshold_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Stop_Bar_Light_Select : Boolean;
            Touchdown_Zone_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            AGL_LDIN_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Runway_End_LI : Jpats_Visual_Buffer_Types.Visual_If_Intensity;
            Airport_Ident : Jpats_Visual_Buffer_Types.Airport_Name_Type;
            The_Runway_Block : Jpats_Visual_Buffer_Types.Block_Array (1..4);
        end record;

end Data_Block.Runway_Control;

