-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim F. Narrin
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Runway_Control is

 -- Procedures for setting the attributes of the class
   procedure Set_Read_Write_Request
     (An_Instance : in out Instance;
      A_Request : in Boolean) is
   begin
      An_Instance.Read_Write_Request := A_Request;
   end Set_Read_Write_Request;

   procedure Set_Request_Number
     (An_Instance : in out Instance;
      A_Request : in Integer) is
   begin
      An_Instance.Request_Number := A_Request;
   end Set_Request_Number;

   procedure Set_Runway_Number
     (An_Instance : in out Instance;
      A_Runway_Number : in Integer) is
   begin
      An_Instance.Runway_Number := A_Runway_Number;
   end Set_Runway_Number;

   procedure Set_Runway_Letter
     (An_Instance : in out Instance;
      A_Runway_Letter : in Integer) is
   begin
      An_Instance.Runway_Letter := A_Runway_Letter;
   end Set_Runway_Letter;

   procedure Set_Wet_Contamination
     (An_Instance : in out Instance;
      The_Wet_Contamination : in Boolean) is
   begin
      An_Instance.Wet_Contamination := The_Wet_Contamination;
   end Set_Wet_Contamination;

   procedure Set_Icy_Contamination
     (An_Instance : in out Instance;
      The_Icy_Contamination : in Boolean) is
   begin
      An_Instance.Icy_Contamination := The_Icy_Contamination;
   end Set_Icy_Contamination;

   procedure Set_Snow_Contamination
     (An_Instance : in out Instance;
      The_Snow_Contamination : in Boolean) is
   begin
      An_Instance.Snow_Contamination := The_Snow_Contamination;
   end Set_Snow_Contamination;

   procedure Set_Slush_Contamination
     (An_Instance : in out Instance;
      The_Slush_Contamination : in Boolean) is
   begin
      An_Instance.Slush_Contamination := The_Slush_Contamination;
   end Set_Slush_Contamination;

   procedure Set_Patchy_Contamination
     (An_Instance : in out Instance;
      The_Patchy_Contamination : in Boolean) is
   begin
      An_Instance.Patchy_Contamination := The_Patchy_Contamination;
   end Set_Patchy_Contamination;

   procedure Set_MIRL_HIRL_Select
     (An_Instance : in out Instance;
      MIRL_HIRL_Selected : in Boolean) is
   begin
      An_Instance.MIRL_HIRL_Select := MIRL_HIRL_Selected;
   end Set_MIRL_HIRL_Select;

   procedure Set_Approach_LI
     (An_Instance : in out Instance;
      An_Intensity : Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Approach_LI := An_Intensity;
   end Set_Approach_LI;

   procedure Set_Runway_Edge_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Runway_Edge_LI := An_Intensity;
   end Set_Runway_Edge_LI;

   procedure Set_Center_Line_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Center_Line_LI := An_Intensity;
   end Set_Center_Line_LI;

   procedure Set_Runway_SI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Runway_SI := An_Intensity;
   end Set_Runway_SI;

   procedure Set_Runway_MI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Runway_MI := An_Intensity;
   end Set_Runway_MI;

   procedure Set_Runway_Strobe_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Runway_Strobe_LI := An_Intensity;
   end Set_Runway_Strobe_LI;

   procedure Set_VASI_PAPI_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.VASI_PAPI_LI := An_Intensity;
   end Set_VASI_PAPI_LI;

   procedure Set_REIL_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.REIL_LI := An_Intensity;
   end Set_REIL_LI;

   procedure Set_Fixed_Distance_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Fixed_Distance_LI := An_Intensity;
   end Set_Fixed_Distance_LI;

   procedure Set_Threshold_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Threshold_LI := An_Intensity;
   end Set_Threshold_LI;

   procedure Set_Stop_Bar_Light_Select
     (An_Instance : in out Instance;
      Stop_Bar_Light_Selected : in Boolean) is
   begin
      An_Instance.Stop_Bar_Light_Select := Stop_Bar_Light_Selected;
   end Set_Stop_Bar_Light_Select;

   procedure Set_Touchdown_Zone_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Touchdown_Zone_LI := An_Intensity;
   end Set_Touchdown_Zone_LI;

   procedure Set_AGL_LDIN_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.AGL_LDIN_LI := An_Intensity;
   end Set_AGL_LDIN_LI;

   procedure Set_Runway_End_LI
     (An_Instance : in out Instance;
      An_Intensity : in Jpats_Visual_Buffer_Types.Visual_If_Intensity) is
   begin
      An_Instance.Runway_End_LI := An_Intensity;
   end Set_Runway_End_LI;

   procedure Set_Airport_Ident
     (An_Instance : in out Instance;
      An_Airport_Ident : in Jpats_Visual_Buffer_Types.Airport_Name_Type) is
   begin
      An_Instance.Airport_Ident := An_Airport_Ident;
   end Set_Airport_Ident;

   -- Functions for returning the class attributes
   function Read_Write_Request
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Read_Write_Request;
   end Read_Write_Request;

   function Request_Number
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Request_Number;
   end Request_Number;

   function Runway_Number
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Runway_Number;
   end Runway_Number;

   function Runway_Letter
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Runway_Letter;
   end Runway_Letter;

   function Wet_Contamination
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Wet_Contamination;
   end Wet_Contamination;

   function Icy_Contamination
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Icy_Contamination;
   end Icy_Contamination;

   function Snow_Contamination
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Snow_Contamination;
   end Snow_Contamination;

   function Slush_Contamination
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Slush_Contamination;
   end Slush_Contamination;

   function Patchy_Contamination
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Patchy_Contamination;
   end Patchy_Contamination;

   function MIRL_HIRL_Select
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.MIRL_HIRL_Select;
   end MIRL_HIRL_Select;

   function Approach_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Approach_LI;
   end Approach_LI;

   function Runway_Edge_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Runway_Edge_LI;
   end Runway_Edge_LI;

   function Center_Line_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Center_Line_LI;
   end Center_Line_LI;

   function Runway_SI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Runway_SI;
   end Runway_SI;

   function Runway_MI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Runway_MI;
   end Runway_MI;

   function Runway_Strobe_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Runway_Strobe_LI;
   end Runway_Strobe_LI;

   function VASI_PAPI_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.VASI_PAPI_LI;
   end VASI_PAPI_LI;

   function REIL_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.REIL_LI;
   end REIL_LI;

   function Fixed_Distance_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Fixed_Distance_LI;
   end Fixed_Distance_LI;

   function Threshold_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Threshold_LI;
   end Threshold_LI;

   function Stop_Bar_Light_Select
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Stop_Bar_Light_Select;
   end Stop_Bar_Light_Select;

   function Touchdown_Zone_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Touchdown_Zone_LI;
   end Touchdown_Zone_LI;

   function AGL_LDIN_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.AGL_LDIN_LI;
   end AGL_LDIN_LI;

   function Runway_End_LI
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Visual_If_Intensity is
   begin
      return An_Instance.Runway_End_LI;
   end Runway_End_LI;

   function Airport_Ident
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Airport_Name_Type is
   begin
      return An_Instance.Airport_Ident;
   end Airport_Ident;

   -- Initializes the data for the Airport Data Block
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 4;
      An_Instance.Data_Block_Code := 16#03000000#;
      An_Instance.Use_Data := True;

      An_Instance.Read_Write_Request := true;
      An_Instance.Request_Number := 0;
      An_Instance.Runway_Number := 28;
      An_Instance.Runway_Letter := 2;
      An_Instance.Wet_Contamination := false;
      An_Instance.Icy_Contamination := false;
      An_Instance.Snow_Contamination := false;
      An_Instance.Slush_Contamination := false;
      An_Instance.Patchy_Contamination := false;
      An_Instance.MIRL_HIRL_Select := false;
      An_Instance.Approach_LI := 3;
      An_Instance.Runway_Edge_LI := 3;
      An_Instance.Center_Line_LI := 3;
      An_Instance.Runway_SI := 3;
      An_Instance.Runway_MI := 3;
      An_Instance.Runway_Strobe_LI := 3;
      An_Instance.VASI_PAPI_LI := 3;
      An_Instance.REIL_LI := 3;
      An_Instance.Fixed_Distance_LI := 3;
      An_Instance.Threshold_LI := 3;
      An_Instance.Stop_Bar_Light_Select := false;
      An_Instance.Touchdown_Zone_LI := 3;
      An_Instance.AGL_LDIN_LI := 3;
      An_Instance.Runway_End_LI := 3;
      An_Instance.Airport_Ident := "KTST";

      for I in 1..4 loop
         An_Instance.The_Runway_Block(I) := 0;
      end loop;

   end Initialize;


   -- Packs the Data into the Airport Data block
   -- See the VSS Vital VIII Interface Control Document
   procedure Pack
     (An_Instance: in out Instance) is
      Int_Letter : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      for i in 1..An_Instance.Word_Count loop
         An_Instance.The_Runway_Block(i) := 0;
      end loop;

      An_Instance.The_Runway_Block(1) := 16#03000000#;

      if An_Instance.Read_Write_Request then
         An_Instance.The_Runway_Block(1) :=
           An_Instance.The_Runway_Block(1) + 16#00800000#;
      end if;

      An_Instance.The_Runway_Block(1) :=
        An_Instance.The_Runway_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Request_Number) * 16#00010000#;

      An_Instance.The_Runway_Block(1) :=
        An_Instance.The_Runway_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_Number) * 16#00000400#;

      An_Instance.The_Runway_Block(1) :=
        An_Instance.The_Runway_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_Letter) * 16#00000100#;

      if An_Instance.Wet_Contamination then
         An_Instance.The_Runway_Block(1) :=
           An_Instance.The_Runway_Block(1) + 16#00000080#;
      end if;

      if An_Instance.Icy_Contamination then
         An_Instance.The_Runway_Block(1) :=
           An_Instance.The_Runway_Block(1) + 16#00000040#;
      end if;

      if An_Instance.Snow_Contamination then
         An_Instance.The_Runway_Block(1) :=
           An_Instance.The_Runway_Block(1) + 16#00000020#;
      end if;

      if An_Instance.Slush_Contamination then
         An_Instance.The_Runway_Block(1) :=
           An_Instance.The_Runway_Block(1) + 16#00000010#;
      end if;

      if An_Instance.Patchy_Contamination then
         An_Instance.The_Runway_Block(1) :=
           An_Instance.The_Runway_Block(1) + 16#00000008#;
      end if;

      for i in 1..4 loop
         Int_Letter := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Character'Pos(An_Instance.Airport_Ident(i)));
         An_Instance.The_Runway_Block(2) :=
           An_Instance.The_Runway_Block(2) +
           Jpats_Visual_Buffer_Types.Unsigned_Int(Int_Letter * 256**(4-i));
      end loop;

      if An_Instance.MIRL_HIRL_Select then
         An_Instance.The_Runway_Block(3) := 16#80000000#;
      end if;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Approach_LI) * 16#10000000#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_Edge_LI) * 16#02000000#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Center_Line_LI) * 16#00400000#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_SI) * 16#00080000#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_MI) * 16#00010000#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_Strobe_LI) * 16#00001000#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.VASI_PAPI_LI) * 16#00000200#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.REIL_LI) * 16#00000040#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Fixed_Distance_LI) * 16#00000008#;

      An_Instance.The_Runway_Block(3) := An_Instance.The_Runway_Block(3) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Threshold_LI) * 16#00000001#;

      if An_Instance.Stop_Bar_Light_Select then
         An_Instance.The_Runway_Block(4) := 16#80000000#;
      end if;


      An_Instance.The_Runway_Block(4) := An_Instance.The_Runway_Block(4) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Touchdown_Zone_LI) * 16#10000000#;

      An_Instance.The_Runway_Block(4) := An_Instance.The_Runway_Block(4) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.AGL_LDIN_LI) * 16#02000000#;

      An_Instance.The_Runway_Block(4) := An_Instance.The_Runway_Block(4) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_End_LI) * 16#00400000#;

   end Pack;

-- Access Data_Block
   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Runway_Block;
   end Data_Word;


end Data_Block.Runway_Control;
