-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Recording_Control is


  type Instance is new Data_Block.Instance with private;

-- Access Record
   function  Recording (An_Instance : in Instance) return Boolean;
   procedure Set_Recording
     (An_Instance : in out Instance;
      Is_Recording : in Boolean);

-- Access Pause
   function  Pause (An_Instance : in Instance) return Boolean;
   procedure Set_Pause
     (An_Instance : in out Instance;
      Is_Paused : in Boolean);

-- Access Comment
   function  Comment (An_Instance : in Instance) return Integer;
   procedure Set_Comment
     (An_Instance : in out Instance;
      A_Comment : in Integer);

-- Access Comment_ACK
   function  Comment_ACK (An_Instance : in Instance) return Integer;
   procedure Set_Comment_ACK
     (An_Instance : in out Instance;
      An_Ack : in Integer);

-- Access Single_Step
   function  Single_Step (An_Instance : in Instance) return Boolean;
   procedure Set_Single_Step
     (An_Instance : in out Instance;
      A_Step : in Boolean);

-- Access Reverse
   function  Reversing (An_Instance : in Instance) return Boolean;
   procedure Set_Reversing
     (An_Instance : in out Instance;
      Is_Reversing : in Boolean);

-- Access Rate
   function  Rate (An_Instance : in Instance) return Float;
   procedure Set_Rate
     (An_Instance : in out Instance;
      A_Rate : in Float);

-- Access Text
   function  Text (An_Instance : in Instance) return Integer;
   procedure Set_Text
     (An_Instance : in out Instance;
      A_Text : in Integer);

-- Access Time_Stamp
   function  Time_Stamp (An_Instance : in Instance) return Integer;
   procedure Set_Time_Stamp
     (An_Instance : in out Instance;
      A_Stamp : in Integer);

-- Data_Block Methods
   procedure Initialize (An_Instance : in out Instance);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

  type Instance is new Data_Block.Instance with record
    Recording : Boolean;
    Pause : Boolean;
    Comment : Integer;
    Comment_ACK : Integer;
    Single_Step : Boolean;
    Reversing : Boolean;
    Rate : Float;
    Text : Integer;
    Time_Stamp : Integer;
    The_Recording_Block : Jpats_Visual_Buffer_Types.Block_Array (1..22);
  end record;


end Data_Block.Recording_Control;
