-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Recording_Control is


-- Access Record
   function  Recording
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Recording;
   end Recording;

   procedure Set_Recording
     (An_Instance : in out Instance;
      Is_Recording : in Boolean) is
   begin
      An_Instance.Recording := Is_Recording;
   end Set_Recording;

-- Access Pause
   function  Pause
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Pause;
   end Pause;

   procedure Set_Pause
     (An_Instance : in out Instance;
      Is_Paused : in Boolean) is
   begin
      An_Instance.Pause := Is_Paused;
   end Set_Pause;

-- Access Comment
   function  Comment
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Comment;
   end Comment;

   procedure Set_Comment
     (An_Instance : in out Instance;
      A_Comment : in Integer) is
   begin
      An_Instance.Comment := A_Comment;
   end Set_Comment;

-- Access Comment_ACK
   function  Comment_ACK
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Comment_ACK;
   end Comment_ACK;

   procedure Set_Comment_ACK
     (An_Instance : in out Instance;
      An_Ack : in Integer) is
   begin
      An_Instance.Comment_Ack := An_ACk;
   end Set_Comment_ACK;

-- Access Single_Step
   function  Single_Step
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Single_Step;
   end Single_Step;

   procedure Set_Single_Step
     (An_Instance : in out Instance;
      A_Step : in Boolean) is
   begin
      An_Instance.Single_Step := A_Step;
   end Set_Single_Step;

-- Access Reverse
   function  Reversing
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Reversing;
   end Reversing;

   procedure Set_Reversing
     (An_Instance : in out Instance;
      Is_Reversing : in Boolean) is
   begin
      An_Instance.Reversing := Is_Reversing;
   end Set_Reversing;

-- Access Rate
   function  Rate
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Rate;
   end Rate;

   procedure Set_Rate
     (An_Instance : in out Instance;
      A_Rate : in Float) is
   begin
      An_Instance.Rate := A_Rate;
   end Set_Rate;

-- Access Text
   function  Text
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Text;
   end Text;

   procedure Set_Text
     (An_Instance : in out Instance;
      A_Text : in Integer) is
   begin
      An_Instance.Text := A_Text;
   end Set_Text;

-- Access Time_Stamp
   function  Time_Stamp
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Time_Stamp;
   end Time_Stamp;

   procedure Set_Time_Stamp
     (An_Instance : in out Instance;
      A_Stamp : in Integer) is
   begin
      An_Instance.Time_Stamp := A_Stamp;
   end Set_Time_Stamp;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 22;
      An_Instance.Data_Block_Code := 16#14000000#;
      An_Instance.Use_Data := False;

      An_Instance.Recording := False;
      An_Instance.Pause := False;
      An_Instance.Comment := 0;
      An_Instance.Comment_Ack := 0;
      An_Instance.Single_Step := False;
      An_Instance.Reversing := False;
      An_Instance.Rate := 0.0;
      An_Instance.Text := 0;
      An_Instance.Time_Stamp := 0;

      for I in 1..22 loop
         An_Instance.The_Recording_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
   begin
      null;
   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Recording_Block;
   end Data_Word;


end Data_Block.Recording_Control;
