-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Position_Command is

  type Instance is new Data_Block.Instance with private;

-- Access Control
   function  Control (An_Instance : in Instance) return Integer;
   procedure Set_Control
     (An_Instance : in out Instance;
      A_Control : in Integer);

-- Access Point_Count
   function Point_Count  (An_Instance : in Instance) return Integer;
   procedure Set_Point_Count
     (An_Instance : in out Instance;
      A_Count : in Integer);

-- Access X_Position
   function  X_Position (An_Instance : in Instance;
                         A_Point : in Integer) return Float;
   procedure Set_X_Position
     (An_Instance : in out Instance;
      A_Point : in Integer;
      A_Position : in Float);

-- Access Y_Position
   function  Y_Position (An_Instance : in Instance;
                         A_Point : in Integer) return Float;
   procedure Set_Y_Position
     (An_Instance : in out Instance;
      A_Point : in Integer;
      A_Position : in Float);

-- Access Z_Position
   function  Z_Position (An_Instance : in Instance;
                         A_Point : in Integer) return Float;
   procedure Set_Z_Position
     (An_Instance : in out Instance;
      A_Point : in Integer;
      A_Position : in Float);

-- Data Block Methods
   procedure Initialize (An_Instance : in out Instance);

   procedure Pack (An_Instance : in out Instance);

-- Access Data_Block
   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

   type Float_Array is array (1..5) of Float;

  type Instance is new Data_Block.Instance with record
    Control : Integer;
    Point_Count : Integer;
    X_Position : Float_Array;
    Y_Position : Float_Array;
    Z_Position : Float_Array;
    Position_Command_Block : Jpats_Visual_Buffer_Types.Block_Array (1..16);
  end record;


end Data_Block.Position_Command;
