-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Position_Command is


-- Access Control
   function  Control
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Control;
   end Control;

   procedure Set_Control
     (An_Instance : in out Instance;
      A_Control : in Integer) is
   begin
      An_Instance.Control := A_Control;
   end Set_Control;

-- Access Point_Count
   function  Point_Count
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Point_Count;
   end Point_Count;

   procedure Set_Point_Count
     (An_Instance : in out Instance;
      A_Count : in Integer) is
   begin
      An_Instance.Point_Count := A_Count;
   end Set_Point_Count;

-- Access X_Position
   function  X_Position
     (An_Instance : in Instance;
      A_Point : in Integer)
     return Float is
      The_Point : Integer;
   begin
      if A_Point > 5 then
         The_Point := 5;
      elsif A_Point < 1 then
         The_Point := 1;
      else
         The_Point := A_Point;
      end if;
      return An_Instance.X_Position(The_Point);
   end X_Position;

   procedure Set_X_Position
     (An_Instance : in out Instance;
      A_Point : in Integer;
      A_Position : in Float) is
      The_Point : Integer;
   begin
      if A_Point > 5 then
         The_Point := 5;
      elsif A_Point < 1 then
         The_Point := 1;
      else
         The_Point := A_Point;
      end if;
      An_Instance.X_Position(The_Point) := A_Position;
   end Set_X_Position;

-- Access Y_Position
   function  Y_Position
     (An_Instance : in Instance;
      A_Point : in Integer)
     return Float is
      The_Point : Integer;
   begin
      if A_Point > 5 then
         The_Point := 5;
      elsif A_Point < 1 then
         The_Point := 1;
      else
         The_Point := A_Point;
      end if;
      return An_Instance.Y_Position(The_Point);
   end Y_Position;

   procedure Set_Y_Position
     (An_Instance : in out Instance;
      A_Point : in Integer;
      A_Position : in Float) is
      The_Point : Integer;
   begin
      if A_Point > 5 then
         The_Point := 5;
      elsif A_Point < 1 then
         The_Point := 1;
      else
         The_Point := A_Point;
      end if;
      An_Instance.Y_Position(The_Point) := A_Position;
   end Set_Y_Position;

-- Access Z_Position
   function  Z_Position
     (An_Instance : in Instance;
      A_Point : in Integer)
     return Float is
      The_Point : Integer;
   begin
      if A_Point > 5 then
         The_Point := 5;
      elsif A_Point < 1 then
         The_Point := 1;
      else
         The_Point := A_Point;
      end if;
      return An_Instance.Z_Position(The_Point);
   end Z_Position;

   procedure Set_Z_Position
     (An_Instance : in out Instance;
      A_Point : in Integer;
      A_Position : in Float) is
      The_Point : Integer;
   begin
      if A_Point > 5 then
         The_Point := 5;
      elsif A_Point < 1 then
         The_Point := 1;
      else
         The_Point := A_Point;
      end if;
      An_Instance.Z_Position(The_Point) := A_Position;
   end Set_Z_Position;


   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 16;
      An_Instance.Data_Block_Code := 16#05000000#;
      An_Instance.Use_Data := False;

      An_Instance.Control := 0;
      An_Instance.Point_Count := 0;
      for I in 1..5 loop
         An_Instance.X_Position(I) := 0.0;
         An_Instance.Y_Position(I) := 0.0;
         An_Instance.Z_Position(I) := 0.0;
      end loop;
      for I in 1..16 loop
         An_Instance.Position_Command_Block(i) := 0;
      end loop;
   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
      Scale_Value : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.Position_Command_Block(I) := 0;
      end loop;

      An_Instance.Position_Command_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      An_Instance.Position_Command_Block(1) :=
        An_Instance.Position_Command_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Control) * 16#00010000# +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Point_Count);

      for I in 1..An_Instance.Point_Count loop
         An_Instance.Position_Command_Block(3*I-1) :=
           Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.X_Position(I) *
                    Jpats_Visual_Buffer_Types.Sb23_Scale));
         An_Instance.Position_Command_Block(3*I) :=
           Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Y_Position(I) *
                    Jpats_Visual_Buffer_Types.Sb23_Scale));
         An_Instance.Position_Command_Block(3*I+1) :=
           Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Z_Position(I) *
                    Jpats_Visual_Buffer_Types.Sb23_Scale));
      end loop;
   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.Position_Command_Block
        (1..An_Instance.Point_Count*3+1);
   end Data_Word;


end Data_Block.Position_Command;
