-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Ownship_Return is


  type Instance is new Data_Block.Instance with private;

-- Access Fuselage_Collision
   function  Fuselage_Collision (An_Instance : in Instance) return Boolean;
   procedure Set_Fuselage_Collision
     (An_Instance : in out Instance;
      A_Collision : in Boolean);

-- Access Right_Wing_Collision
   function  Right_Wing_Collision (An_Instance : in Instance) return Boolean;
   procedure Set_Right_Wing_Collision
     (An_Instance : in out Instance;
      A_Collision : in Boolean);

-- Access Left_Wing_Collision
   function  Left_Wing_Collision (An_Instance : in Instance) return Boolean;
   procedure Set_Left_Wing_Collision
     (An_Instance : in out Instance;
      A_Collision : in Boolean);

-- Access Fuselage_Collision_Latch
   function  Fuselage_Collision_Latch (An_Instance : in Instance) return Boolean;
   procedure Set_Fuselage_Collision_Latch
     (An_Instance : in out Instance;
      A_Collision : in Boolean);

-- Access Right_Wing_Collision_Latch
   function  Right_Wing_Collision_Latch (An_Instance : in Instance) return Boolean;
   procedure Set_Right_Wing_Collision_Latch
     (An_Instance : in out Instance;
      A_Collision : in Boolean);

-- Access Left_Wing_Collision_Latch
   function  Left_Wing_Collision_Latch (An_Instance : in Instance) return Boolean;
   procedure Set_Left_Wing_Collision_Latch
     (An_Instance : in out Instance;
      A_Collision : in Boolean);

-- Access Video_On
   function  Video_On (An_Instance : in Instance) return Boolean;
   procedure Set_Video_On
     (An_Instance : in out Instance;
      Video_Is_On : in Boolean);

-- Access Cloud_Type_Penetrated
   function  Cloud_Type_Penetrated (An_Instance : in Instance) return Integer;
   procedure Set_Cloud_Type_Penetrated
     (An_Instance : in out Instance;
      A_Cloud_Type : in Integer);

-- Access Warning_Code
   function  Warning_Code (An_Instance : in Instance) return Integer;
   procedure Set_Warning_Code
     (An_Instance : in out Instance;
      A_Code : in Integer);

-- Data_Block Methods
   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array);
   procedure Initialize (An_Instance : in out Instance);
   procedure Unpack (An_Instance : in out Instance);


private

  type Instance is new Data_Block.Instance with record
    Fuselage_Collision : Boolean;
    Fuselage_Collision_Latch : Boolean;
    Right_Wing_Collision : Boolean;
    Right_Wing_Collision_Latch : Boolean;
    Left_Wing_Collision : Boolean;
    Left_Wing_Collision_Latch : Boolean;
    Video_On : Boolean;
    Cloud_Type_Penetrated : Integer;
    Warning_Code : Integer;
    The_Ownship_Return_Block : Jpats_Visual_Buffer_Types.Block_Array (1..2);
  end record;


end Data_Block.Ownship_Return;
