-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Ownship_Return is


-- Access Fuselage_Collision
   function  Fuselage_Collision
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Fuselage_Collision;
   end Fuselage_Collision;

   procedure Set_Fuselage_Collision
     (An_Instance : in out Instance;
      A_Collision : in Boolean) is
   begin
      An_Instance.Fuselage_Collision := A_Collision;
   end Set_Fuselage_Collision;

-- Access Right_Wing_Collision
   function  Right_Wing_Collision
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Right_Wing_Collision;
   end Right_Wing_Collision;

   procedure Set_Right_Wing_Collision
     (An_Instance : in out Instance;
      A_Collision : in Boolean) is
   begin
      An_Instance.Right_Wing_Collision := A_Collision;
   end Set_Right_Wing_Collision;

-- Access Left_Wing_Collision
   function  Left_Wing_Collision
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Left_Wing_Collision;
   end Left_Wing_Collision;

   procedure Set_Left_Wing_Collision
     (An_Instance : in out Instance;
      A_Collision : in Boolean) is
   begin
      An_Instance.Left_Wing_Collision := A_Collision;
   end Set_Left_Wing_Collision;

-- Access Fuselage_Collision_Latch
   function  Fuselage_Collision_Latch
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Fuselage_Collision_Latch;
   end Fuselage_Collision_Latch;

   procedure Set_Fuselage_Collision_Latch
     (An_Instance : in out Instance;
      A_Collision : in Boolean) is
   begin
      An_Instance.Fuselage_Collision_Latch := A_Collision;
   end Set_Fuselage_Collision_Latch;

-- Access Right_Wing_Collision_Latch
   function  Right_Wing_Collision_Latch
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Right_Wing_Collision_Latch;
   end Right_Wing_Collision_Latch;

   procedure Set_Right_Wing_Collision_Latch
     (An_Instance : in out Instance;
      A_Collision : in Boolean) is
   begin
      An_Instance.Right_Wing_Collision_Latch := A_Collision;
   end Set_Right_Wing_Collision_Latch;

-- Access Left_Wing_Collision_Latch
   function  Left_Wing_Collision_Latch
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Left_Wing_Collision_Latch;
   end Left_Wing_Collision_Latch;

   procedure Set_Left_Wing_Collision_Latch
     (An_Instance : in out Instance;
      A_Collision : in Boolean) is
   begin
      An_Instance.Left_Wing_Collision_Latch := A_Collision;
   end Set_Left_Wing_Collision_Latch;

-- Access Video_On
   function  Video_On
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Video_On;
   end Video_On;

   procedure Set_Video_On
     (An_Instance : in out Instance;
      Video_Is_On : in Boolean) is
   begin
      An_Instance.Video_On := Video_Is_On;
   end Set_Video_On;

-- Access Cloud_Type_Penetrated
   function  Cloud_Type_Penetrated
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Cloud_Type_Penetrated;
   end Cloud_Type_Penetrated;

   procedure Set_Cloud_Type_Penetrated
     (An_Instance : in out Instance;
      A_Cloud_Type : in Integer) is
   begin
      An_Instance.Cloud_Type_Penetrated := A_Cloud_Type;
   end Set_Cloud_Type_Penetrated;

-- Access Warning_Code
   function  Warning_Code
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Warning_Code;
   end Warning_Code;

   procedure Set_Warning_Code
     (An_Instance : in out Instance;
      A_Code : in Integer) is
   begin
      An_Instance.Warning_Code := A_Code;
   end Set_Warning_Code;

   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array) is
   begin
      An_Instance.The_Ownship_Return_Block := A_Block;
   end Set_Data_Block;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 2;
      An_Instance.Data_Block_Code := 16#0e000000#;
      An_Instance.Use_Data := False;

      An_Instance.Fuselage_Collision := False;
      An_Instance.Right_Wing_Collision := False;
      An_Instance.Left_Wing_Collision := False;
      An_Instance.Fuselage_Collision_Latch := False;
      An_Instance.Right_Wing_Collision_Latch := False;
      An_Instance.Left_Wing_Collision_Latch := False;
      An_Instance.Video_On := True;
      An_Instance.Cloud_Type_Penetrated := 0;
      An_Instance.Warning_Code := 0;

      for I in 1..2 loop
         An_Instance.The_Ownship_Return_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Unpack
     (An_Instance : in out Instance) is
   begin
--    The three ownship collision flags sent from the VCC to the host.
      if (An_Instance.Use_Data) then
         An_Instance.Fuselage_Collision :=
             (An_Instance.The_Ownship_Return_Block(1) and 16#00800000#) =
             16#00800000#;
         An_Instance.Right_Wing_Collision :=
               (An_Instance.The_Ownship_Return_Block(1) and 16#00400000#) =
               16#00400000#;
         An_Instance.Left_Wing_Collision :=
               (An_Instance.The_Ownship_Return_Block(1) and 16#00200000#) =
               16#00200000#;
         An_Instance.Video_On :=
           (An_Instance.The_Ownship_Return_Block(1) and 16#00100000#) =
           16#00100000#;
         An_Instance.Cloud_Type_Penetrated :=
           Integer(((An_Instance.The_Ownship_Return_Block(1)
                     and 16#00070000#) /
                    16#00010000#) and 16#00000007#);
         An_Instance.Use_Data := False;

         if (An_Instance.Fuselage_Collision) then
            An_Instance.Fuselage_Collision_Latch := True;
         end if;

         if (An_Instance.Right_Wing_Collision) then
            An_Instance.Right_Wing_Collision_Latch := True;
         end if;

         if (An_Instance.Left_Wing_Collision) then
            An_Instance.Left_Wing_Collision_Latch := True;
         end if;

      end if;
   end Unpack;


end Data_Block.Ownship_Return;
