-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6B Texan-II Flight Training Device
--
--
--  Engineer:  Pamela Danner
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;
with Lat_Long_Types;

package Data_Block.Ownship_Lobes is


  type Instance is new Data_Block.Instance with private;

-- Access Number Lobes
  function Number_Lobes (An_Instance : in Instance) return Integer;
  procedure Set_Number_Lobes
    (An_Instance : in out Instance;
     Number_Lobes : in Integer);

-- Access Device Disable Mask 0
   function Device_Disable_Mask_0 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_0
     (An_Instance : in out Instance;
      Device_Disable_Mask_0 : in Boolean);

-- Access Device Disable Mask 1
   function Device_Disable_Mask_1 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_1
     (An_Instance : in out Instance;
      Device_Disable_Mask_1 : in Boolean);

-- Access Device Disable Mask 2
   function Device_Disable_Mask_2 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_2
     (An_Instance : in out Instance;
      Device_Disable_Mask_2 : in Boolean);

-- Access Device Disable Mask 3
   function Device_Disable_Mask_3 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_3
     (An_Instance : in out Instance;
      Device_Disable_Mask_3 : in Boolean);

-- Access Device Disable Mask 4
   function Device_Disable_Mask_4 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_4
     (An_Instance : in out Instance;
      Device_Disable_Mask_4 : in Boolean);

-- Access Device Disable Mask 5
   function Device_Disable_Mask_5 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_5
     (An_Instance : in out Instance;
      Device_Disable_Mask_5 : in Boolean);

-- Access Device Disable Mask 6
   function Device_Disable_Mask_6 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_6
     (An_Instance : in out Instance;
      Device_Disable_Mask_6 : in Boolean);

-- Access Device Disable Mask 7
   function Device_Disable_Mask_7 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_7
     (An_Instance : in out Instance;
      Device_Disable_Mask_7 : in Boolean);

-- Access Device Disable Mask 8
   function Device_Disable_Mask_8 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_8
     (An_Instance : in out Instance;
      Device_Disable_Mask_8 : in Boolean);

-- Access Device Disable Mask 9
   function Device_Disable_Mask_9 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_9
     (An_Instance : in out Instance;
      Device_Disable_Mask_9 : in Boolean);

-- Access Device Disable Mask 10
   function Device_Disable_Mask_10 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_10
     (An_Instance : in out Instance;
      Device_Disable_Mask_10 : in Boolean);

-- Access Device Disable Mask 11
   function Device_Disable_Mask_11 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_11
     (An_Instance : in out Instance;
      Device_Disable_Mask_11 : in Boolean);

-- Access Device Disable Mask 12
   function Device_Disable_Mask_12 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_12
     (An_Instance : in out Instance;
      Device_Disable_Mask_12 : in Boolean);

-- Access Device Disable Mask 13
   function Device_Disable_Mask_13 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_13
     (An_Instance : in out Instance;
      Device_Disable_Mask_13 : in Boolean);

-- Access Device Disable Mask 14
   function Device_Disable_Mask_14 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_14
     (An_Instance : in out Instance;
      Device_Disable_Mask_14 : in Boolean);

-- Access Device Disable Mask 15
   function Device_Disable_Mask_15 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_15
     (An_Instance : in out Instance;
      Device_Disable_Mask_15 : in Boolean);

-- Access Steerable Light Enable 1
   function Steerable_Light_Enable_1 (An_Instance : in Instance) return Boolean;
   procedure Set_Steerable_Light_Enable_1
     (An_Instance : in out Instance;
      Steerable_Light_Enable_1 : in Boolean);

-- Access Steerable Light Enable 2
   function Steerable_Light_Enable_2 (An_Instance : in Instance) return Boolean;
   procedure Set_Steerable_Light_Enable_2
     (An_Instance : in out Instance;
      Steerable_Light_Enable_2 : in Boolean);

-- Access Steerable Light Enable 3
   function Steerable_Light_Enable_3 (An_Instance : in Instance) return Boolean;
   procedure Set_Steerable_Light_Enable_3
     (An_Instance : in out Instance;
      Steerable_Light_Enable_3 : in Boolean);

-- Access Steerable Light Enable 4
   function Steerable_Light_Enable_4 (An_Instance : in Instance) return Boolean;
   procedure Set_Steerable_Light_Enable_4
     (An_Instance : in out Instance;
      Steerable_Light_Enable_4 : in Boolean);

-- Access Steerable Light Enable 5
   function Steerable_Light_Enable_5 (An_Instance : in Instance) return Boolean;
   procedure Set_Steerable_Light_Enable_5
     (An_Instance : in out Instance;
      Steerable_Light_Enable_5 : in Boolean);

-- Access Steerable Light Enable 6
   function Steerable_Light_Enable_6 (An_Instance : in Instance) return Boolean;
   procedure Set_Steerable_Light_Enable_6
     (An_Instance : in out Instance;
      Steerable_Light_Enable_6 : in Boolean);

-- Access Steerable Light Enable 7
   function Steerable_Light_Enable_7 (An_Instance : in Instance) return Boolean;
   procedure Set_Steerable_Light_Enable_7
     (An_Instance : in out Instance;
      Steerable_Light_Enable_7 : in Boolean);

-- Access Steerable Light Enable 8
   function Steerable_Light_Enable_8 (An_Instance : in Instance) return Boolean;
   procedure Set_Steerable_Light_Enable_8
     (An_Instance : in out Instance;
      Steerable_Light_Enable_8 : in Boolean);

 -- Access Landing Lobe Intensity 1
   function Landing_Lobe_Intensity_1 (An_Instance : in Instance) return Float;
   procedure Set_Landing_Lobe_Intensity_1
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_1 : in Float);

-- Access Landing Lobe Intensity 2
   function Landing_Lobe_Intensity_2 (An_Instance : in Instance) return Float;
   procedure Set_Landing_Lobe_Intensity_2
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_2 : in Float);

-- Access Landing Lobe Intensity 3
   function Landing_Lobe_Intensity_3 (An_Instance : in Instance) return Float;
   procedure Set_Landing_Lobe_Intensity_3
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_3 : in Float);

-- Access Landing Lobe Intensity 4
   function Landing_Lobe_Intensity_4 (An_Instance : in Instance) return Float;
   procedure Set_Landing_Lobe_Intensity_4
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_4 : in Float);

-- Access Landing Lobe Intensity 5
   function Landing_Lobe_Intensity_5 (An_Instance : in Instance) return Float;
   procedure Set_Landing_Lobe_Intensity_5
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_5 : in Float);

-- Access Landing Lobe Intensity 6
   function Landing_Lobe_Intensity_6 (An_Instance : in Instance) return Float;
   procedure Set_Landing_Lobe_Intensity_6
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_6 : in Float);

-- Access Landing Lobe Intensity 7
   function Landing_Lobe_Intensity_7 (An_Instance : in Instance) return Float;
   procedure Set_Landing_Lobe_Intensity_7
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_7 : in Float);

-- Access Landing Lobe Intensity 8
   function Landing_Lobe_Intensity_8 (An_Instance : in Instance) return Float;
   procedure Set_Landing_Lobe_Intensity_8
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_8 : in Float);

-- Access Steerable Light Azimuth 1
   function Steerable_Light_Azimuth_1 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Azimuth_1
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_1 : in Float);

-- Access Steerable Light Azimuth 2
   function Steerable_Light_Azimuth_2 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Azimuth_2
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_2 : in Float);

-- Access Steerable Light Azimuth 3
   function Steerable_Light_Azimuth_3 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Azimuth_3
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_3 : in Float);

-- Access Steerable Light Azimuth 4
   function Steerable_Light_Azimuth_4 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Azimuth_4
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_4 : in Float);

-- Access Steerable Light Azimuth 5
   function Steerable_Light_Azimuth_5 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Azimuth_5
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_5 : in Float);

-- Access Steerable Light Azimuth 6
   function Steerable_Light_Azimuth_6 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Azimuth_6
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_6 : in Float);

-- Access Steerable Light Azimuth 7
   function Steerable_Light_Azimuth_7 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Azimuth_7
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_7 : in Float);

-- Access Steerable Light Azimuth 8
   function Steerable_Light_Azimuth_8 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Azimuth_8
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_8 : in Float);

-- Access Steerable Light Elevation 1
   function Steerable_Light_Elevation_1 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Elevation_1
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_1 : in Float);

-- Access Steerable Light Elevation 2
   function Steerable_Light_Elevation_2 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Elevation_2
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_2 : in Float);

-- Access Steerable Light Elevation 3
   function Steerable_Light_Elevation_3 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Elevation_3
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_3 : in Float);

-- Access Steerable Light Elevation 4
   function Steerable_Light_Elevation_4 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Elevation_4
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_4 : in Float);

-- Access Steerable Light Elevation 5
   function Steerable_Light_Elevation_5 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Elevation_5
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_5 : in Float);

-- Access Steerable Light Elevation 6
   function Steerable_Light_Elevation_6 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Elevation_6
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_6 : in Float);

-- Access Steerable Light Elevation 7
   function Steerable_Light_Elevation_7 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Elevation_7
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_7 : in Float);

-- Access Steerable Light Elevation 8
   function Steerable_Light_Elevation_8 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Elevation_8
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_8 : in Float);-- Access Steerable Light Vertical Beam 1

-- Access Steerable Light Vertical Beam 1
   function Steerable_Light_Vertical_Beam_1 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Vertical_Beam_1
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_1 : in Float);

-- Access Steerable Light Vertical Beam 2
   function Steerable_Light_Vertical_Beam_2 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Vertical_Beam_2
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_2 : in Float);

-- Access Steerable Light Vertical Beam 3
   function Steerable_Light_Vertical_Beam_3 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Vertical_Beam_3
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_3 : in Float);

-- Access Steerable Light Vertical Beam 4
   function Steerable_Light_Vertical_Beam_4 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Vertical_Beam_4
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_4 : in Float);

-- Access Steerable Light Vertical Beam 5
   function Steerable_Light_Vertical_Beam_5 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Vertical_Beam_5
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_5 : in Float);

-- Access Steerable Light Vertical Beam 6
   function Steerable_Light_Vertical_Beam_6 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Vertical_Beam_6
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_6 : in Float);

-- Access Steerable Light Vertical Beam 7
   function Steerable_Light_Vertical_Beam_7 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Vertical_Beam_7
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_7 : in Float);

-- Access Steerable Light Vertical Beam 8
   function Steerable_Light_Vertical_Beam_8 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Vertical_Beam_8
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_8 : in Float);

-- Access Steerable Light Horizontal Beam 1
   function Steerable_Light_Horizontal_Beam_1 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Horizontal_Beam_1
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_1 : in Float);

-- Access Steerable Light Horizontal Beam 2
   function Steerable_Light_Horizontal_Beam_2 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Horizontal_Beam_2
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_2 : in Float);

-- Access Steerable Light Horizontal Beam 3
   function Steerable_Light_Horizontal_Beam_3 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Horizontal_Beam_3
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_3 : in Float);

-- Access Steerable Light Horizontal Beam 4
   function Steerable_Light_Horizontal_Beam_4 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Horizontal_Beam_4
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_4 : in Float);

-- Access Steerable Light Horizontal Beam 5
   function Steerable_Light_Horizontal_Beam_5 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Horizontal_Beam_5
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_5 : in Float);

-- Access Steerable Light Horizontal Beam 6
   function Steerable_Light_Horizontal_Beam_6 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Horizontal_Beam_6
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_6 : in Float);

-- Access Steerable Light Horizontal Beam 7
   function Steerable_Light_Horizontal_Beam_7 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Horizontal_Beam_7
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_7 : in Float);

-- Access Steerable Light Horizontal Beam 8
   function Steerable_Light_Horizontal_Beam_8 (An_Instance : in Instance) return Float;
   procedure Set_Steerable_Light_Horizontal_Beam_8
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_8 : in Float);


---- Access Landing_Lobe_Intensity
--   function Landing_Lobe_Intensity (An_Instance : in Instance)
--     return Jpats_Visual_Buffer_Types.Steerable_Light_Array;
--   procedure Set_Landing_Lobe_Intensity
--     (An_Instance : in out Instance;
--      A_Landing_Lobe_Intensity : in Jpats_Visual_Buffer_Types.Steerable_Light_Array);
--
---- Access Steerable_Light_Azimuth
--   function Steerable_Light_Azimuth (An_Instance : in Instance)
--     return Jpats_Visual_Buffer_Types.Steerable_Light_Array;
--   procedure Set_Steerable_Light_Azimuth
--     (An_Instance : in out Instance;
--      A_Steerable_Light_Azimuth : in Jpats_Visual_Buffer_Types.Steerable_Light_Array);
--
---- Access Steerable_Light_Elevation
--   function Steerable_Light_Elevation (An_Instance : in Instance)
--     return Jpats_Visual_Buffer_Types.Steerable_Light_Array;
--   procedure Set_Steerable_Light_Elevation
--     (An_Instance : in out Instance;
--      A_Steerable_Light_Elevation : in Jpats_Visual_Buffer_Types.Steerable_Light_Array);
--
---- Access Steerable_Light_Vertical_Beam
--   function Steerable_Light_Vertical_Beam (An_Instance : in Instance)
--     return Jpats_Visual_Buffer_Types.Steerable_Light_Array;
--   procedure Set_Steerable_Light_Vertical_Beam
--     (An_Instance : in out Instance;
--      A_Steerable_Light_Vertical_Beam : in Jpats_Visual_Buffer_Types.Steerable_Light_Array);
--
---- Access Steerable_Light_Horizontal_Beam
--   function Steerable_Light_Horizontal_Beam (An_Instance : in Instance)
--     return Jpats_Visual_Buffer_Types.Steerable_Light_Array;
--   procedure Set_Steerable_Light_Horizontal_Beam
--     (An_Instance : in out Instance;
--      A_Steerable_Light_Horizontal_Beam : in Jpats_Visual_Buffer_Types.Steerable_Light_Array);

-- Method Compute_Ambient_Light
   procedure Compute_Ambient_Light
     (An_Instance : in out Instance;
      A_Time_Of_Day : in Integer);

-- Data_Block Methods
   procedure Initialize (An_Instance : in out Instance);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

   type Instance is new Data_Block.Instance with record
      Number_Lobes : Integer;
      Device_Disable_Mask_0 : Boolean;
      Device_Disable_Mask_1 : Boolean;
      Device_Disable_Mask_2 : Boolean;
      Device_Disable_Mask_3 : Boolean;
      Device_Disable_Mask_4 : Boolean;
      Device_Disable_Mask_5 : Boolean;
      Device_Disable_Mask_6 : Boolean;
      Device_Disable_Mask_7 : Boolean;
      Device_Disable_Mask_8 : Boolean;
      Device_Disable_Mask_9 : Boolean;
      Device_Disable_Mask_10 : Boolean;
      Device_Disable_Mask_11 : Boolean;
      Device_Disable_Mask_12 : Boolean;
      Device_Disable_Mask_13 : Boolean;
      Device_Disable_Mask_14 : Boolean;
      Device_Disable_Mask_15 : Boolean;
      Steerable_Light_Enable_1 : Boolean;
      Steerable_Light_Enable_2 : Boolean;
      Steerable_Light_Enable_3 : Boolean;
      Steerable_Light_Enable_4 : Boolean;
      Steerable_Light_Enable_5 : Boolean;
      Steerable_Light_Enable_6 : Boolean;
      Steerable_Light_Enable_7 : Boolean;
      Steerable_Light_Enable_8 : Boolean;
      Landing_Lobe_Intensity_1 : Float;
      Landing_Lobe_Intensity_2 : Float;
      Landing_Lobe_Intensity_3 : Float;
      Landing_Lobe_Intensity_4 : Float;
      Landing_Lobe_Intensity_5 : Float;
      Landing_Lobe_Intensity_6 : Float;
      Landing_Lobe_Intensity_7 : Float;
      Landing_Lobe_Intensity_8 : Float;
      Steerable_Light_Azimuth_1 : Float;
      Steerable_Light_Azimuth_2 : Float;
      Steerable_Light_Azimuth_3 : Float;
      Steerable_Light_Azimuth_4 : Float;
      Steerable_Light_Azimuth_5 : Float;
      Steerable_Light_Azimuth_6 : Float;
      Steerable_Light_Azimuth_7 : Float;
      Steerable_Light_Azimuth_8 : Float;
      Steerable_Light_Elevation_1 : Float;
      Steerable_Light_Elevation_2 : Float;
      Steerable_Light_Elevation_3 : Float;
      Steerable_Light_Elevation_4 : Float;
      Steerable_Light_Elevation_5 : Float;
      Steerable_Light_Elevation_6 : Float;
      Steerable_Light_Elevation_7 : Float;
      Steerable_Light_Elevation_8 : Float;
      Steerable_Light_Vertical_Beam_1 : Float;
      Steerable_Light_Vertical_Beam_2 : Float;
      Steerable_Light_Vertical_Beam_3 : Float;
      Steerable_Light_Vertical_Beam_4 : Float;
      Steerable_Light_Vertical_Beam_5 : Float;
      Steerable_Light_Vertical_Beam_6 : Float;
      Steerable_Light_Vertical_Beam_7 : Float;
      Steerable_Light_Vertical_Beam_8 : Float;
      Steerable_Light_Horizontal_Beam_1 : Float;
      Steerable_Light_Horizontal_Beam_2 : Float;
      Steerable_Light_Horizontal_Beam_3 : Float;
      Steerable_Light_Horizontal_Beam_4 : Float;
      Steerable_Light_Horizontal_Beam_5 : Float;
      Steerable_Light_Horizontal_Beam_6 : Float;
      Steerable_Light_Horizontal_Beam_7 : Float;
      Steerable_Light_Horizontal_Beam_8 : Float;

      The_Ownship_Lobes_Block : Jpats_Visual_Buffer_Types.Block_Array (1..41); --*pd
  end record;


end Data_Block.Ownship_Lobes;
