-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6B Texan-II Flight Training Device
--
--
--  Engineer:  Pamela Danner
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Text_Io;
with Ada.Float_Text_Io;
with Jpats_Visual_Buffer_Types;
use Ada.Text_Io;
use Ada.Float_Text_Io;
use Jpats_Visual_Buffer_Types;

package body Data_Block.Ownship_Lobes is

   Temp_Word_Count : Integer := 6;
   Max_Word_Count : Integer := 41;
   Temp_Num_Lobes : Integer := 1;
   Temp_Index : Integer := 1;
   Lobe_Id : Float;
   J : Integer;

-- Access Number_Lobes
   function Number_Lobes
     (An_Instance : in Instance)
     return Integer is
   begin
      return An_Instance.Number_Lobes;
   end Number_Lobes;

   procedure Set_Number_Lobes
     (An_Instance : in out Instance;
      Number_Lobes : in Integer) is
   begin
      An_Instance.Number_Lobes := Number_Lobes;
   end Set_Number_Lobes;

-- Access Device Disable Mask 0
   function Device_Disable_Mask_0
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_0;
   end Device_Disable_Mask_0;

   procedure Set_Device_Disable_Mask_0
     (An_Instance : in out Instance;
      Device_Disable_Mask_0 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_0 := Device_Disable_Mask_0;
   end Set_Device_Disable_Mask_0;

-- Access Device Disable Mask 1
   function Device_Disable_Mask_1
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_1;
   end Device_Disable_Mask_1;

   procedure Set_Device_Disable_Mask_1
     (An_Instance : in out Instance;
      Device_Disable_Mask_1 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_1 := Device_Disable_Mask_1;
   end Set_Device_Disable_Mask_1;

-- Access Device Disable Mask 2
   function Device_Disable_Mask_2
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_2;
   end Device_Disable_Mask_2;

   procedure Set_Device_Disable_Mask_2
     (An_Instance : in out Instance;
      Device_Disable_Mask_2 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_2 := Device_Disable_Mask_2;
   end Set_Device_Disable_Mask_2;

-- Access Device Disable Mask 3
   function Device_Disable_Mask_3
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_3;
   end Device_Disable_Mask_3;

   procedure Set_Device_Disable_Mask_3
     (An_Instance : in out Instance;
      Device_Disable_Mask_3 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_3 := Device_Disable_Mask_3;
   end Set_Device_Disable_Mask_3;

-- Access Device Disable Mask 4
   function Device_Disable_Mask_4
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_4;
   end Device_Disable_Mask_4;

   procedure Set_Device_Disable_Mask_4
     (An_Instance : in out Instance;
      Device_Disable_Mask_4 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_4 := Device_Disable_Mask_4;
   end Set_Device_Disable_Mask_4;

-- Access Device Disable Mask 5
   function Device_Disable_Mask_5
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_5;
   end Device_Disable_Mask_5;

   procedure Set_Device_Disable_Mask_5
     (An_Instance : in out Instance;
      Device_Disable_Mask_5 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_5 := Device_Disable_Mask_5;
   end Set_Device_Disable_Mask_5;

-- Access Device Disable Mask 6
   function Device_Disable_Mask_6
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_6;
   end Device_Disable_Mask_6;

   procedure Set_Device_Disable_Mask_6
     (An_Instance : in out Instance;
      Device_Disable_Mask_6 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_6 := Device_Disable_Mask_6;
   end Set_Device_Disable_Mask_6;

-- Access Device Disable Mask 7
   function Device_Disable_Mask_7
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_7;
   end Device_Disable_Mask_7;

   procedure Set_Device_Disable_Mask_7
     (An_Instance : in out Instance;
      Device_Disable_Mask_7 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_7 := Device_Disable_Mask_7;
   end Set_Device_Disable_Mask_7;

-- Access Device Disable Mask 8
   function Device_Disable_Mask_8
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_8;
   end Device_Disable_Mask_8;

   procedure Set_Device_Disable_Mask_8
     (An_Instance : in out Instance;
      Device_Disable_Mask_8 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_8 := Device_Disable_Mask_8;
   end Set_Device_Disable_Mask_8;

-- Access Device Disable Mask 9
   function Device_Disable_Mask_9
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_9;
   end Device_Disable_Mask_9;

   procedure Set_Device_Disable_Mask_9
     (An_Instance : in out Instance;
      Device_Disable_Mask_9 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_9 := Device_Disable_Mask_9;
   end Set_Device_Disable_Mask_9;

-- Access Device Disable Mask 10
   function Device_Disable_Mask_10
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_10;
   end Device_Disable_Mask_10;

   procedure Set_Device_Disable_Mask_10
     (An_Instance : in out Instance;
      Device_Disable_Mask_10 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_10 := Device_Disable_Mask_10;
   end Set_Device_Disable_Mask_10;

-- Access Device Disable Mask 11
   function Device_Disable_Mask_11
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_11;
   end Device_Disable_Mask_11;

   procedure Set_Device_Disable_Mask_11
     (An_Instance : in out Instance;
      Device_Disable_Mask_11 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_11 := Device_Disable_Mask_11;
   end Set_Device_Disable_Mask_11;

-- Access Device Disable Mask 12
   function Device_Disable_Mask_12
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_12;
   end Device_Disable_Mask_12;

   procedure Set_Device_Disable_Mask_12
     (An_Instance : in out Instance;
      Device_Disable_Mask_12 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_12 := Device_Disable_Mask_12;
   end Set_Device_Disable_Mask_12;

-- Access Device Disable Mask 13
   function Device_Disable_Mask_13
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_13;
   end Device_Disable_Mask_13;

   procedure Set_Device_Disable_Mask_13
     (An_Instance : in out Instance;
      Device_Disable_Mask_13 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_13 := Device_Disable_Mask_13;
   end Set_Device_Disable_Mask_13;

-- Access Device Disable Mask 14
   function Device_Disable_Mask_14
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_14;
   end Device_Disable_Mask_14;

   procedure Set_Device_Disable_Mask_14
     (An_Instance : in out Instance;
      Device_Disable_Mask_14 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_14 := Device_Disable_Mask_14;
   end Set_Device_Disable_Mask_14;

-- Access Device Disable Mask 15
   function Device_Disable_Mask_15
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_15;
   end Device_Disable_Mask_15;

   procedure Set_Device_Disable_Mask_15
     (An_Instance : in out Instance;
      Device_Disable_Mask_15 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_15 := Device_Disable_Mask_15;
   end Set_Device_Disable_Mask_15;

-- Access Steerable Light Enable 1
   function Steerable_Light_Enable_1
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Steerable_Light_Enable_1;
   end Steerable_Light_Enable_1;

   procedure Set_Steerable_Light_Enable_1
     (An_Instance : in out Instance;
      Steerable_Light_Enable_1 : in Boolean) is
   begin
      An_Instance.Steerable_Light_Enable_1 := Steerable_Light_Enable_1;
   end Set_Steerable_Light_Enable_1;

-- Access Steerable Light Enable 2
   function Steerable_Light_Enable_2
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Steerable_Light_Enable_2;
   end Steerable_Light_Enable_2;

   procedure Set_Steerable_Light_Enable_2
     (An_Instance : in out Instance;
      Steerable_Light_Enable_2 : in Boolean) is
   begin
      An_Instance.Steerable_Light_Enable_2 := Steerable_Light_Enable_2;
   end Set_Steerable_Light_Enable_2;

-- Access Steerable Light Enable 3
   function Steerable_Light_Enable_3
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Steerable_Light_Enable_3;
   end Steerable_Light_Enable_3;

   procedure Set_Steerable_Light_Enable_3
     (An_Instance : in out Instance;
      Steerable_Light_Enable_3 : in Boolean) is
   begin
      An_Instance.Steerable_Light_Enable_3 := Steerable_Light_Enable_3;
   end Set_Steerable_Light_Enable_3;

-- Access Steerable Light Enable 4
   function Steerable_Light_Enable_4
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Steerable_Light_Enable_4;
   end Steerable_Light_Enable_4;

   procedure Set_Steerable_Light_Enable_4
     (An_Instance : in out Instance;
      Steerable_Light_Enable_4 : in Boolean) is
   begin
      An_Instance.Steerable_Light_Enable_4 := Steerable_Light_Enable_4;
   end Set_Steerable_Light_Enable_4;

-- Access Steerable Light Enable 5
   function Steerable_Light_Enable_5
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Steerable_Light_Enable_5;
   end Steerable_Light_Enable_5;

   procedure Set_Steerable_Light_Enable_5
     (An_Instance : in out Instance;
      Steerable_Light_Enable_5 : in Boolean) is
   begin
      An_Instance.Steerable_Light_Enable_5 := Steerable_Light_Enable_5;
   end Set_Steerable_Light_Enable_5;

-- Access Steerable Light Enable 6
   function Steerable_Light_Enable_6
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Steerable_Light_Enable_6;
   end Steerable_Light_Enable_6;

   procedure Set_Steerable_Light_Enable_6
     (An_Instance : in out Instance;
      Steerable_Light_Enable_6 : in Boolean) is
   begin
      An_Instance.Steerable_Light_Enable_6 := Steerable_Light_Enable_6;
   end Set_Steerable_Light_Enable_6;

-- Access Steerable Light Enable 7
   function Steerable_Light_Enable_7
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Steerable_Light_Enable_7;
   end Steerable_Light_Enable_7;

   procedure Set_Steerable_Light_Enable_7
     (An_Instance : in out Instance;
      Steerable_Light_Enable_7 : in Boolean) is
   begin
      An_Instance.Steerable_Light_Enable_7 := Steerable_Light_Enable_7;
   end Set_Steerable_Light_Enable_7;

-- Access Steerable Light Enable 8
   function Steerable_Light_Enable_8
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Steerable_Light_Enable_8;
   end Steerable_Light_Enable_8;

   procedure Set_Steerable_Light_Enable_8
     (An_Instance : in out Instance;
      Steerable_Light_Enable_8 : in Boolean) is
   begin
      An_Instance.Steerable_Light_Enable_8 := Steerable_Light_Enable_8;
   end Set_Steerable_Light_Enable_8;

-- Access Landing Lobe Intensity 1
   function Landing_Lobe_Intensity_1
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Landing_Lobe_Intensity_1;
   end Landing_Lobe_Intensity_1;

   procedure Set_Landing_Lobe_Intensity_1
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_1 : in Float) is
   begin
      An_Instance.Landing_Lobe_Intensity_1 := Landing_Lobe_Intensity_1;
   end Set_Landing_Lobe_Intensity_1;

-- Access Landing Lobe Intensity 2
   function Landing_Lobe_Intensity_2
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Landing_Lobe_Intensity_2;
   end Landing_Lobe_Intensity_2;

   procedure Set_Landing_Lobe_Intensity_2
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_2 : in Float) is
   begin
      An_Instance.Landing_Lobe_Intensity_2 := Landing_Lobe_Intensity_2;
   end Set_Landing_Lobe_Intensity_2;

-- Access Landing Lobe Intensity 3
   function Landing_Lobe_Intensity_3
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Landing_Lobe_Intensity_3;
   end Landing_Lobe_Intensity_3;

   procedure Set_Landing_Lobe_Intensity_3
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_3 : in Float) is
   begin
      An_Instance.Landing_Lobe_Intensity_3 := Landing_Lobe_Intensity_3;
   end Set_Landing_Lobe_Intensity_3;

-- Access Landing Lobe Intensity 4
   function Landing_Lobe_Intensity_4
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Landing_Lobe_Intensity_4;
   end Landing_Lobe_Intensity_4;

   procedure Set_Landing_Lobe_Intensity_4
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_4 : in Float) is
   begin
      An_Instance.Landing_Lobe_Intensity_4 := Landing_Lobe_Intensity_4;
   end Set_Landing_Lobe_Intensity_4;

-- Access Landing Lobe Intensity 5
   function Landing_Lobe_Intensity_5
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Landing_Lobe_Intensity_5;
   end Landing_Lobe_Intensity_5;

   procedure Set_Landing_Lobe_Intensity_5
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_5 : in Float) is
   begin
      An_Instance.Landing_Lobe_Intensity_5 := Landing_Lobe_Intensity_5;
   end Set_Landing_Lobe_Intensity_5;

-- Access Landing Lobe Intensity 6
   function Landing_Lobe_Intensity_6
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Landing_Lobe_Intensity_6;
   end Landing_Lobe_Intensity_6;

   procedure Set_Landing_Lobe_Intensity_6
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_6 : in Float) is
   begin
      An_Instance.Landing_Lobe_Intensity_6 := Landing_Lobe_Intensity_6;
   end Set_Landing_Lobe_Intensity_6;

-- Access Landing Lobe Intensity 7
   function Landing_Lobe_Intensity_7
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Landing_Lobe_Intensity_7;
   end Landing_Lobe_Intensity_7;

   procedure Set_Landing_Lobe_Intensity_7
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_7 : in Float) is
   begin
      An_Instance.Landing_Lobe_Intensity_7 := Landing_Lobe_Intensity_7;
   end Set_Landing_Lobe_Intensity_7;

-- Access Landing Lobe Intensity 8
   function Landing_Lobe_Intensity_8
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Landing_Lobe_Intensity_8;
   end Landing_Lobe_Intensity_8;

   procedure Set_Landing_Lobe_Intensity_8
     (An_Instance : in out Instance;
      Landing_Lobe_Intensity_8 : in Float) is
   begin
      An_Instance.Landing_Lobe_Intensity_8 := Landing_Lobe_Intensity_8;
   end Set_Landing_Lobe_Intensity_8;

-- Access Steerable Light Azimuth 1
   function Steerable_Light_Azimuth_1
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Azimuth_1;
   end Steerable_Light_Azimuth_1;

   procedure Set_Steerable_Light_Azimuth_1
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_1 : in Float) is
   begin
      An_Instance.Steerable_Light_Azimuth_1 := Steerable_Light_Azimuth_1;
   end Set_Steerable_Light_Azimuth_1;

-- Access Steerable Light Azimuth 2
   function Steerable_Light_Azimuth_2
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Azimuth_2;
   end Steerable_Light_Azimuth_2;

   procedure Set_Steerable_Light_Azimuth_2
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_2 : in Float) is
   begin
      An_Instance.Steerable_Light_Azimuth_2 := Steerable_Light_Azimuth_2;
   end Set_Steerable_Light_Azimuth_2;

-- Access Steerable Light Azimuth 3
   function Steerable_Light_Azimuth_3
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Azimuth_3;
   end Steerable_Light_Azimuth_3;

   procedure Set_Steerable_Light_Azimuth_3
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_3 : in Float) is
   begin
      An_Instance.Steerable_Light_Azimuth_3 := Steerable_Light_Azimuth_3;
   end Set_Steerable_Light_Azimuth_3;

-- Access Steerable Light Azimuth 4
   function Steerable_Light_Azimuth_4
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Azimuth_4;
   end Steerable_Light_Azimuth_4;

   procedure Set_Steerable_Light_Azimuth_4
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_4 : in Float) is
   begin
      An_Instance.Steerable_Light_Azimuth_4 := Steerable_Light_Azimuth_4;
   end Set_Steerable_Light_Azimuth_4;

-- Access Steerable Light Azimuth 5
   function Steerable_Light_Azimuth_5
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Azimuth_5;
   end Steerable_Light_Azimuth_5;

   procedure Set_Steerable_Light_Azimuth_5
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_5 : in Float) is
   begin
      An_Instance.Steerable_Light_Azimuth_5 := Steerable_Light_Azimuth_5;
   end Set_Steerable_Light_Azimuth_5;

-- Access Steerable Light Azimuth 6
   function Steerable_Light_Azimuth_6
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Azimuth_6;
   end Steerable_Light_Azimuth_6;

   procedure Set_Steerable_Light_Azimuth_6
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_6 : in Float) is
   begin
      An_Instance.Steerable_Light_Azimuth_6 := Steerable_Light_Azimuth_6;
   end Set_Steerable_Light_Azimuth_6;

-- Access Steerable Light Azimuth 7
   function Steerable_Light_Azimuth_7
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Azimuth_7;
   end Steerable_Light_Azimuth_7;

   procedure Set_Steerable_Light_Azimuth_7
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_7 : in Float) is
   begin
      An_Instance.Steerable_Light_Azimuth_7 := Steerable_Light_Azimuth_7;
   end Set_Steerable_Light_Azimuth_7;

-- Access Steerable Light Azimuth 8
   function Steerable_Light_Azimuth_8
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Azimuth_8;
   end Steerable_Light_Azimuth_8;

   procedure Set_Steerable_Light_Azimuth_8
     (An_Instance : in out Instance;
      Steerable_Light_Azimuth_8 : in Float) is
   begin
      An_Instance.Steerable_Light_Azimuth_8 := Steerable_Light_Azimuth_8;
   end Set_Steerable_Light_Azimuth_8;

-- Access Steerable Light Elevation 1
   function Steerable_Light_Elevation_1
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Elevation_1;
   end Steerable_Light_Elevation_1;

   procedure Set_Steerable_Light_Elevation_1
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_1 : in Float) is
   begin
      An_Instance.Steerable_Light_Elevation_1 := Steerable_Light_Elevation_1;
   end Set_Steerable_Light_Elevation_1;

-- Access Steerable Light Elevation 2
   function Steerable_Light_Elevation_2
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Elevation_2;
   end Steerable_Light_Elevation_2;

   procedure Set_Steerable_Light_Elevation_2
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_2 : in Float) is
   begin
      An_Instance.Steerable_Light_Elevation_2 := Steerable_Light_Elevation_2;
   end Set_Steerable_Light_Elevation_2;

-- Access Steerable Light Elevation 3
   function Steerable_Light_Elevation_3
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Elevation_3;
   end Steerable_Light_Elevation_3;

   procedure Set_Steerable_Light_Elevation_3
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_3 : in Float) is
   begin
      An_Instance.Steerable_Light_Elevation_3 := Steerable_Light_Elevation_3;
   end Set_Steerable_Light_Elevation_3;

-- Access Steerable Light Elevation 4
   function Steerable_Light_Elevation_4
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Elevation_4;
   end Steerable_Light_Elevation_4;

   procedure Set_Steerable_Light_Elevation_4
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_4 : in Float) is
   begin
      An_Instance.Steerable_Light_Elevation_4 := Steerable_Light_Elevation_4;
   end Set_Steerable_Light_Elevation_4;

-- Access Steerable Light Elevation 5
   function Steerable_Light_Elevation_5
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Elevation_5;
   end Steerable_Light_Elevation_5;

   procedure Set_Steerable_Light_Elevation_5
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_5 : in Float) is
   begin
      An_Instance.Steerable_Light_Elevation_5 := Steerable_Light_Elevation_5;
   end Set_Steerable_Light_Elevation_5;

-- Access Steerable Light Elevation 6
   function Steerable_Light_Elevation_6
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Elevation_6;
   end Steerable_Light_Elevation_6;

   procedure Set_Steerable_Light_Elevation_6
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_6 : in Float) is
   begin
      An_Instance.Steerable_Light_Elevation_6 := Steerable_Light_Elevation_6;
   end Set_Steerable_Light_Elevation_6;

-- Access Steerable Light Elevation 7
   function Steerable_Light_Elevation_7
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Elevation_7;
   end Steerable_Light_Elevation_7;

   procedure Set_Steerable_Light_Elevation_7
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_7 : in Float) is
   begin
      An_Instance.Steerable_Light_Elevation_7 := Steerable_Light_Elevation_7;
   end Set_Steerable_Light_Elevation_7;

-- Access Steerable Light Elevation 8
   function Steerable_Light_Elevation_8
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Elevation_8;
   end Steerable_Light_Elevation_8;

   procedure Set_Steerable_Light_Elevation_8
     (An_Instance : in out Instance;
      Steerable_Light_Elevation_8 : in Float) is
   begin
      An_Instance.Steerable_Light_Elevation_8 := Steerable_Light_Elevation_8;
   end Set_Steerable_Light_Elevation_8;

-- Access Steerable Light Vertical Beam 1
   function Steerable_Light_Vertical_Beam_1
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Vertical_Beam_1;
   end Steerable_Light_Vertical_Beam_1;

   procedure Set_Steerable_Light_Vertical_Beam_1
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_1 : in Float) is
   begin
      An_Instance.Steerable_Light_Vertical_Beam_1 := Steerable_Light_Vertical_Beam_1;
   end Set_Steerable_Light_Vertical_Beam_1;

-- Access Steerable Light Vertical Beam 2
   function Steerable_Light_Vertical_Beam_2
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Vertical_Beam_2;
   end Steerable_Light_Vertical_Beam_2;

   procedure Set_Steerable_Light_Vertical_Beam_2
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_2 : in Float) is
   begin
      An_Instance.Steerable_Light_Vertical_Beam_2 := Steerable_Light_Vertical_Beam_2;
   end Set_Steerable_Light_Vertical_Beam_2;

-- Access Steerable Light Vertical Beam 3
   function Steerable_Light_Vertical_Beam_3
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Vertical_Beam_3;
   end Steerable_Light_Vertical_Beam_3;

   procedure Set_Steerable_Light_Vertical_Beam_3
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_3 : in Float) is
   begin
      An_Instance.Steerable_Light_Vertical_Beam_3 := Steerable_Light_Vertical_Beam_3;
   end Set_Steerable_Light_Vertical_Beam_3;

-- Access Steerable Light Vertical Beam 4
   function Steerable_Light_Vertical_Beam_4
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Vertical_Beam_4;
   end Steerable_Light_Vertical_Beam_4;

   procedure Set_Steerable_Light_Vertical_Beam_4
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_4 : in Float) is
   begin
      An_Instance.Steerable_Light_Vertical_Beam_4 := Steerable_Light_Vertical_Beam_4;
   end Set_Steerable_Light_Vertical_Beam_4;

-- Access Steerable Light Vertical Beam 5
   function Steerable_Light_Vertical_Beam_5
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Vertical_Beam_5;
   end Steerable_Light_Vertical_Beam_5;

   procedure Set_Steerable_Light_Vertical_Beam_5
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_5 : in Float) is
   begin
      An_Instance.Steerable_Light_Vertical_Beam_5 := Steerable_Light_Vertical_Beam_5;
   end Set_Steerable_Light_Vertical_Beam_5;

-- Access Steerable Light Vertical Beam 6
   function Steerable_Light_Vertical_Beam_6
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Vertical_Beam_6;
   end Steerable_Light_Vertical_Beam_6;

   procedure Set_Steerable_Light_Vertical_Beam_6
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_6 : in Float) is
   begin
      An_Instance.Steerable_Light_Vertical_Beam_6 := Steerable_Light_Vertical_Beam_6;
   end Set_Steerable_Light_Vertical_Beam_6;

-- Access Steerable Light Vertical Beam 7
   function Steerable_Light_Vertical_Beam_7
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Vertical_Beam_7;
   end Steerable_Light_Vertical_Beam_7;

   procedure Set_Steerable_Light_Vertical_Beam_7
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_7 : in Float) is
   begin
      An_Instance.Steerable_Light_Vertical_Beam_7 := Steerable_Light_Vertical_Beam_7;
   end Set_Steerable_Light_Vertical_Beam_7;

-- Access Steerable Light Vertical Beam 8
   function Steerable_Light_Vertical_Beam_8
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Vertical_Beam_8;
   end Steerable_Light_Vertical_Beam_8;

   procedure Set_Steerable_Light_Vertical_Beam_8
     (An_Instance : in out Instance;
      Steerable_Light_Vertical_Beam_8 : in Float) is
   begin
      An_Instance.Steerable_Light_Vertical_Beam_8 := Steerable_Light_Vertical_Beam_8;
   end Set_Steerable_Light_Vertical_Beam_8;

-- Access Steerable Light Horizontal Beam 1
   function Steerable_Light_Horizontal_Beam_1
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Horizontal_Beam_1;
   end Steerable_Light_Horizontal_Beam_1;

   procedure Set_Steerable_Light_Horizontal_Beam_1
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_1 : in Float) is
   begin
      An_Instance.Steerable_Light_Horizontal_Beam_1 := Steerable_Light_Horizontal_Beam_1;
   end Set_Steerable_Light_Horizontal_Beam_1;

-- Access Steerable Light Horizontal Beam 2
   function Steerable_Light_Horizontal_Beam_2
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Horizontal_Beam_2;
   end Steerable_Light_Horizontal_Beam_2;

   procedure Set_Steerable_Light_Horizontal_Beam_2
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_2 : in Float) is
   begin
      An_Instance.Steerable_Light_Horizontal_Beam_2 := Steerable_Light_Horizontal_Beam_2;
   end Set_Steerable_Light_Horizontal_Beam_2;

-- Access Steerable Light Horizontal Beam 3
   function Steerable_Light_Horizontal_Beam_3
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Horizontal_Beam_3;
   end Steerable_Light_Horizontal_Beam_3;

   procedure Set_Steerable_Light_Horizontal_Beam_3
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_3 : in Float) is
   begin
      An_Instance.Steerable_Light_Horizontal_Beam_3 := Steerable_Light_Horizontal_Beam_3;
   end Set_Steerable_Light_Horizontal_Beam_3;

-- Access Steerable Light Horizontal Beam 4
   function Steerable_Light_Horizontal_Beam_4
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Horizontal_Beam_4;
   end Steerable_Light_Horizontal_Beam_4;

   procedure Set_Steerable_Light_Horizontal_Beam_4
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_4 : in Float) is
   begin
      An_Instance.Steerable_Light_Horizontal_Beam_4 := Steerable_Light_Horizontal_Beam_4;
   end Set_Steerable_Light_Horizontal_Beam_4;

-- Access Steerable Light Horizontal Beam 5
   function Steerable_Light_Horizontal_Beam_5
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Horizontal_Beam_5;
   end Steerable_Light_Horizontal_Beam_5;

   procedure Set_Steerable_Light_Horizontal_Beam_5
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_5 : in Float) is
   begin
      An_Instance.Steerable_Light_Horizontal_Beam_5 := Steerable_Light_Horizontal_Beam_5;
   end Set_Steerable_Light_Horizontal_Beam_5;

-- Access Steerable Light Horizontal Beam 6
   function Steerable_Light_Horizontal_Beam_6
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Horizontal_Beam_6;
   end Steerable_Light_Horizontal_Beam_6;

   procedure Set_Steerable_Light_Horizontal_Beam_6
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_6 : in Float) is
   begin
      An_Instance.Steerable_Light_Horizontal_Beam_6 := Steerable_Light_Horizontal_Beam_6;
   end Set_Steerable_Light_Horizontal_Beam_6;

-- Access Steerable Light Horizontal Beam 7
   function Steerable_Light_Horizontal_Beam_7
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Horizontal_Beam_7;
   end Steerable_Light_Horizontal_Beam_7;

   procedure Set_Steerable_Light_Horizontal_Beam_7
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_7 : in Float) is
   begin
      An_Instance.Steerable_Light_Horizontal_Beam_7 := Steerable_Light_Horizontal_Beam_7;
   end Set_Steerable_Light_Horizontal_Beam_7;

-- Access Steerable Light Horizontal Beam 8
   function Steerable_Light_Horizontal_Beam_8
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Steerable_Light_Horizontal_Beam_8;
   end Steerable_Light_Horizontal_Beam_8;

   procedure Set_Steerable_Light_Horizontal_Beam_8
     (An_Instance : in out Instance;
      Steerable_Light_Horizontal_Beam_8 : in Float) is
   begin
      An_Instance.Steerable_Light_Horizontal_Beam_8 := Steerable_Light_Horizontal_Beam_8;
   end Set_Steerable_Light_Horizontal_Beam_8;


-- Method Compute_Ambient_Light
   procedure Compute_Ambient_Light
     (An_Instance : in out Instance;
      A_Time_Of_Day : in Integer) is
   begin
      null;
   end Compute_Ambient_Light;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      Temp_Word_Count := Max_Word_Count; --max size
      An_Instance.Word_Count := Temp_Word_Count;
      An_Instance.Data_Block_Code := 16#28000000#;
      An_Instance.Use_Data := True;
      An_Instance.Number_Lobes := 8;

      An_Instance.Device_Disable_Mask_0 := False;
      An_Instance.Device_Disable_Mask_1 := False;
      An_Instance.Device_Disable_Mask_2 := False;
      An_Instance.Device_Disable_Mask_3 := False;
      An_Instance.Device_Disable_Mask_4 := False;
      An_Instance.Device_Disable_Mask_5 := False;
      An_Instance.Device_Disable_Mask_6 := False;
      An_Instance.Device_Disable_Mask_7 := False;
      An_Instance.Device_Disable_Mask_8 := False;
      An_Instance.Device_Disable_Mask_9 := False;
      An_Instance.Device_Disable_Mask_10 := False;
      An_Instance.Device_Disable_Mask_11 := False;
      An_Instance.Device_Disable_Mask_12 := False;
      An_Instance.Device_Disable_Mask_13 := False;
      An_Instance.Device_Disable_Mask_14 := False;
      An_Instance.Device_Disable_Mask_15 := False;
      An_Instance.Steerable_Light_Enable_1 := False;
      An_Instance.Steerable_Light_Enable_2 := False;
      An_Instance.Steerable_Light_Enable_3 := False;
      An_Instance.Steerable_Light_Enable_4 := False;
      An_Instance.Steerable_Light_Enable_5 := False;
      An_Instance.Steerable_Light_Enable_6 := False;
      An_Instance.Steerable_Light_Enable_7 := False;
      An_Instance.Steerable_Light_Enable_8 := False;
      An_Instance.Landing_Lobe_Intensity_1 := 0.0;
      An_Instance.Landing_Lobe_Intensity_2 := 0.0;
      An_Instance.Landing_Lobe_Intensity_3 := 0.0;
      An_Instance.Landing_Lobe_Intensity_4 := 0.0;
      An_Instance.Landing_Lobe_Intensity_5 := 0.0;
      An_Instance.Landing_Lobe_Intensity_6 := 0.0;
      An_Instance.Landing_Lobe_Intensity_7 := 0.0;
      An_Instance.Landing_Lobe_Intensity_8 := 0.0;
      An_Instance.Steerable_Light_Azimuth_1 := 0.0;
      An_Instance.Steerable_Light_Azimuth_2 := 0.0;
      An_Instance.Steerable_Light_Azimuth_3 := 0.0;
      An_Instance.Steerable_Light_Azimuth_4 := 0.0;
      An_Instance.Steerable_Light_Azimuth_5 := 0.0;
      An_Instance.Steerable_Light_Azimuth_6 := 0.0;
      An_Instance.Steerable_Light_Azimuth_7 := 0.0;
      An_Instance.Steerable_Light_Azimuth_8 := 0.0;
      An_Instance.Steerable_Light_Elevation_1 := 0.0;
      An_Instance.Steerable_Light_Elevation_2 := 0.0;
      An_Instance.Steerable_Light_Elevation_3 := 0.0;
      An_Instance.Steerable_Light_Elevation_4 := 0.0;
      An_Instance.Steerable_Light_Elevation_5 := 0.0;
      An_Instance.Steerable_Light_Elevation_6 := 0.0;
      An_Instance.Steerable_Light_Elevation_7 := 0.0;
      An_Instance.Steerable_Light_Elevation_8 := 0.0;
      An_Instance.Steerable_Light_Vertical_Beam_1 := 0.0;
      An_Instance.Steerable_Light_Vertical_Beam_2 := 0.0;
      An_Instance.Steerable_Light_Vertical_Beam_3 := 0.0;
      An_Instance.Steerable_Light_Vertical_Beam_4 := 0.0;
      An_Instance.Steerable_Light_Vertical_Beam_5 := 0.0;
      An_Instance.Steerable_Light_Vertical_Beam_6 := 0.0;
      An_Instance.Steerable_Light_Vertical_Beam_7 := 0.0;
      An_Instance.Steerable_Light_Vertical_Beam_8 := 0.0;
      An_Instance.Steerable_Light_Horizontal_Beam_1 := 0.0;
      An_Instance.Steerable_Light_Horizontal_Beam_2 := 0.0;
      An_Instance.Steerable_Light_Horizontal_Beam_3 := 0.0;
      An_Instance.Steerable_Light_Horizontal_Beam_4 := 0.0;
      An_Instance.Steerable_Light_Horizontal_Beam_5 := 0.0;
      An_Instance.Steerable_Light_Horizontal_Beam_6 := 0.0;
      An_Instance.Steerable_Light_Horizontal_Beam_7 := 0.0;
      An_Instance.Steerable_Light_Horizontal_Beam_8 := 0.0;

      for I in 1..Max_Word_Count loop
         An_Instance.The_Ownship_Lobes_Block(I) := 0;
      end loop;

   end Initialize;


   procedure Pack
     (An_Instance : in out Instance) is
      Temp : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin

      --Zero out all words before starting each time
      for I in 1..Max_Word_Count loop
         An_Instance.The_Ownship_Lobes_Block(I) := 0;
      end loop;

      --Calculate # of words needed
      Temp_Num_Lobes := 0;
      if (An_Instance.Steerable_Light_Enable_1) then
         Temp_Num_Lobes := Temp_Num_Lobes + 1;
      end if;
      if (An_Instance.Steerable_Light_Enable_2) then
         Temp_Num_Lobes := Temp_Num_Lobes + 1;
      end if;
      if (An_Instance.Steerable_Light_Enable_3) then
         Temp_Num_Lobes := Temp_Num_Lobes + 1;
      end if;
      if (An_Instance.Steerable_Light_Enable_4) then
         Temp_Num_Lobes := Temp_Num_Lobes + 1;
      end if;
      if (An_Instance.Steerable_Light_Enable_5) then
         Temp_Num_Lobes := Temp_Num_Lobes + 1;
      end if;
      if (An_Instance.Steerable_Light_Enable_6) then
         Temp_Num_Lobes := Temp_Num_Lobes + 1;
      end if;
      if (An_Instance.Steerable_Light_Enable_7) then
         Temp_Num_Lobes := Temp_Num_Lobes + 1;
      end if;
      if (An_Instance.Steerable_Light_Enable_8) then
         Temp_Num_Lobes := Temp_Num_Lobes + 1;
      end if;

      Temp_Word_Count := (Temp_Num_Lobes * 5) + 1;
      An_Instance.Word_Count := Temp_Word_Count;
      An_Instance.Number_Lobes := Temp_Num_Lobes;

--31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01
----------db code--------|--------------device disable mask--------------|------num lobes-----|
----------lobe id--------|--------spare-------|-------------------intensity-------------------|
-------------------------------------steerable light azimuth----------------------------------|
------------------------------------steerable light elevation---------------------------------|
---------------------------------------vertical beam width------------------------------------|
--------------------------------------horizontal beam width-----------------------------------|

--Pack word 1
      An_Instance.The_Ownship_Lobes_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);

      if (An_Instance.Device_Disable_Mask_15) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00800000#;
      end if;
      if (An_Instance.Device_Disable_Mask_14) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00400000#;
      end if;
      if (An_Instance.Device_Disable_Mask_13) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00200000#;
      end if;
      if (An_Instance.Device_Disable_Mask_12) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00100000#;
      end if;
      if (An_Instance.Device_Disable_Mask_11) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00080000#;
      end if;
      if (An_Instance.Device_Disable_Mask_10) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00040000#;
      end if;
      if (An_Instance.Device_Disable_Mask_9) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00020000#;
      end if;
      if (An_Instance.Device_Disable_Mask_8) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00010000#;
      end if;
      if (An_Instance.Device_Disable_Mask_7) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00008000#;
      end if;
      if (An_Instance.Device_Disable_Mask_6) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00004000#;
      end if;
      if (An_Instance.Device_Disable_Mask_5) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00002000#;
      end if;
      if (An_Instance.Device_Disable_Mask_4) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00001000#;
      end if;
      if (An_Instance.Device_Disable_Mask_3) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00000800#;
      end if;
      if (An_Instance.Device_Disable_Mask_2) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00000400#;
      end if;
      if (An_Instance.Device_Disable_Mask_1) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00000200#;
      end if;
      if (An_Instance.Device_Disable_Mask_0) then
         An_Instance.The_Ownship_Lobes_Block(1) :=
           An_Instance.The_Ownship_Lobes_Block(1) + 16#00000100#;
      end if;

      An_Instance.The_Ownship_Lobes_Block(1) :=
        An_Instance.The_Ownship_Lobes_Block(1) +
        (Jpats_Visual_Buffer_Types.Unsigned_Int(Temp_Num_Lobes)
         and 16#000000ff#);

-- Pack Remaining Words (2 - 41)

      --To get around a constraint error that happens when you try to convert
      --floating point numbers into full scale 32 bits in one line, the
      --numbers are scaled by 20 or 24 bits below, then once converted to an
      --integer, are shifted up into the correct position. This causes a small
      --loss of data, but should not affect simulation.

      J := 2; --Word count

      --Lobe 0
      if (An_Instance.Steerable_Light_Enable_1) then
         --Word 2, 7, 12, 17, 22, 27, 32, 37
         An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#00000000#;
         if (An_Instance.Landing_Lobe_Intensity_1 > 0.0) then
            An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#0000ffff#;
         end if;
         J := J + 1;

         --Word 3, 8, 13, 18, 23, 28, 33, 38
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Azimuth_1 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 4, 9, 14, 19, 24, 29, 34, 39
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Elevation_1 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 5, 10, 15, 20, 25, 30, 25, 40
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Vertical_Beam_1 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;

         --Word 6, 11, 16, 21, 26, 31, 36, 41
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Horizontal_Beam_1 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;
      end if;

      --Lobe 1
      if (An_Instance.Steerable_Light_Enable_2) then
         --Word 2, 7, 12, 17, 22, 27, 32, 37
         An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#01000000#;
         if (An_Instance.Landing_Lobe_Intensity_2 > 0.0) then
            An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#0000ffff#;
         end if;
         J := J + 1;

         --Word 3, 8, 13, 18, 23, 28, 33, 38
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Azimuth_2 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 4, 9, 14, 19, 24, 29, 34, 39
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Elevation_2 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 5, 10, 15, 20, 25, 30, 25, 40
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Vertical_Beam_2 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;

         --Word 6, 11, 16, 21, 26, 31, 36, 41
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Horizontal_Beam_2 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;
      end if;

      --Lobe 2
      if (An_Instance.Steerable_Light_Enable_3) then
         --Word 2, 7, 12, 17, 22, 27, 32, 37
         An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#02000000#;
         if (An_Instance.Landing_Lobe_Intensity_3 > 0.0) then
            An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#0000ffff#;
         end if;
         J := J + 1;

         --Word 3, 8, 13, 18, 23, 28, 33, 38
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Azimuth_3 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 4, 9, 14, 19, 24, 29, 34, 39
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Elevation_3 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 5, 10, 15, 20, 25, 30, 25, 40
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Vertical_Beam_3 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;

         --Word 6, 11, 16, 21, 26, 31, 36, 41
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Horizontal_Beam_3 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;
      end if;

      --Lobe 3
      if (An_Instance.Steerable_Light_Enable_4) then
         --Word 2, 7, 12, 17, 22, 27, 32, 37
         An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#03000000#;
         if (An_Instance.Landing_Lobe_Intensity_4 > 0.0) then
            An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#0000ffff#;
         end if;
         J := J + 1;

         --Word 3, 8, 13, 18, 23, 28, 33, 38
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Azimuth_4 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 4, 9, 14, 19, 24, 29, 34, 39
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Elevation_4 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 5, 10, 15, 20, 25, 30, 25, 40
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Vertical_Beam_4 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;

         --Word 6, 11, 16, 21, 26, 31, 36, 41
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Horizontal_Beam_4 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;
      end if;

      --Lobe 4
      if (An_Instance.Steerable_Light_Enable_5) then
         --Word 2, 7, 12, 17, 22, 27, 32, 37
         An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#04000000#;
         if (An_Instance.Landing_Lobe_Intensity_5 > 0.0) then
            An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#0000ffff#;
         end if;
         J := J + 1;

         --Word 3, 8, 13, 18, 23, 28, 33, 38
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Azimuth_5 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 4, 9, 14, 19, 24, 29, 34, 39
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Elevation_5 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 5, 10, 15, 20, 25, 30, 25, 40
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Vertical_Beam_5 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;

         --Word 6, 11, 16, 21, 26, 31, 36, 41
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Horizontal_Beam_5 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;
      end if;

      --Lobe 5
      if (An_Instance.Steerable_Light_Enable_6) then
         --Word 2, 7, 12, 17, 22, 27, 32, 37
         An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#05000000#;
         if (An_Instance.Landing_Lobe_Intensity_6 > 0.0) then
            An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#0000ffff#;
         end if;
         J := J + 1;

         --Word 3, 8, 13, 18, 23, 28, 33, 38
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Azimuth_6 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 4, 9, 14, 19, 24, 29, 34, 39
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Elevation_6 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 5, 10, 15, 20, 25, 30, 25, 40
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Vertical_Beam_6 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;

         --Word 6, 11, 16, 21, 26, 31, 36, 41
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Horizontal_Beam_6 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;
      end if;

      --Lobe 6
      if (An_Instance.Steerable_Light_Enable_7) then
         --Word 2, 7, 12, 17, 22, 27, 32, 37
         An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#06000000#;
         if (An_Instance.Landing_Lobe_Intensity_7 > 0.0) then
            An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#0000ffff#;
         end if;
         J := J + 1;

         --Word 3, 8, 13, 18, 23, 28, 33, 38
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Azimuth_7 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 4, 9, 14, 19, 24, 29, 34, 39
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Elevation_7 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 5, 10, 15, 20, 25, 30, 25, 40
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Vertical_Beam_7 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;

         --Word 6, 11, 16, 21, 26, 31, 36, 41
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Horizontal_Beam_7 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;
      end if;

      --Lobe 7
      if (An_Instance.Steerable_Light_Enable_8) then
         --Word 2, 7, 12, 17, 22, 27, 32, 37
         An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#07000000#;
         if (An_Instance.Landing_Lobe_Intensity_8 > 0.0) then
            An_Instance.The_Ownship_Lobes_Block(J) := An_Instance.The_Ownship_Lobes_Block(J) +
            16#0000ffff#;
         end if;
         J := J + 1;

         --Word 3, 8, 13, 18, 23, 28, 33, 38
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Azimuth_8 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 4, 9, 14, 19, 24, 29, 34, 39
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Elevation_8 *
                    Jpats_Visual_Buffer_Types.Sb1_20bit_Scale)) * 4096
           and 16#Ffffffff#;
         J := J + 1;

         --Word 5, 10, 15, 20, 25, 30, 25, 40
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Vertical_Beam_8 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;

         --Word 6, 11, 16, 21, 26, 31, 36, 41
         An_Instance.The_Ownship_Lobes_Block(J) := Jpats_Visual_Buffer_Types.Unsigned_Int
           (Integer(An_Instance.Steerable_Light_Horizontal_Beam_8 *
                    Jpats_Visual_Buffer_Types.Ub1_24bit_Scale)) * 256
           and 16#Ffffffff#;
         J := J + 1;
      end if;

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
     return Jpats_Visual_Buffer_Types.Block_Array is
      Num_Words : Natural;
   begin
      Num_Words := An_Instance.Number_Lobes * 5 + 1;
      return An_Instance.The_Ownship_Lobes_Block(1..Num_Words);
   end Data_Word;

end Data_Block.Ownship_Lobes;
