-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Other_Hazards is


-- Access Model_Instance_ID
   function  Model_Instance_ID
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Model_Instance_ID;
   end Model_Instance_ID;

   procedure Set_Model_Instance_ID
     (An_Instance : in out Instance;
      An_Id : in Integer) is
   begin
      An_Instance.Model_Instance_Id := An_Id;
   end Set_Model_Instance_ID;

-- Access Model_Designation
   function  Model_Designation
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Model_Designation;
   end Model_Designation;

   procedure Set_Model_Designation
     (An_Instance : in out Instance;
      A_Designation : in Integer) is
   begin
      An_Instance.Model_Designation := A_Designation;
   end Set_Model_Designation;

-- Access Hazard_Start
   function  Hazard_Start
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Hazard_Start;
   end Hazard_Start;

   procedure Set_Hazard_Start
     (An_Instance : in out Instance;
      Start_Hazard : in Boolean) is
   begin
      An_Instance.Hazard_Start := Start_Hazard;
   end Set_Hazard_Start;

-- Access Hazard_Path_Designation
   function  Hazard_Path_Designation
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Hazard_Path_Designation;
   end Hazard_Path_Designation;

   procedure Set_Hazard_Path_Designation
     (An_Instance : in out Instance;
      A_Path : in Integer) is
   begin
      An_Instance.Hazard_Path_Designation := A_Path;
   end Set_Hazard_Path_Designation;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 2;
      An_Instance.Data_Block_Code := 16#0b000000#;
      An_Instance.Use_Data := False;

      An_Instance.Model_Instance_Id := 2;
      An_Instance.Model_Designation := 0;
      An_Instance.Hazard_Start := False;
      An_Instance.Hazard_Path_Designation := 0;

      for I in 1..2 loop
         An_Instance.The_Other_Hazard_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_Other_Hazard_Block(I) := 0;
      end loop;

      An_Instance.The_Other_Hazard_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      if (An_Instance.Hazard_Start) then
         An_Instance.The_Other_Hazard_Block(1) :=
           An_Instance.The_Other_Hazard_Block(1) + 16#00800000#;
      end if;
      An_Instance.The_Other_Hazard_Block(1) :=
        An_Instance.The_Other_Hazard_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Model_Instance_Id) * 16#00010000#;
      if (An_Instance.Model_Designation > 0) then
         An_Instance.The_Other_Hazard_Block(1) :=
           An_Instance.The_Other_Hazard_Block(1) +
           Jpats_Visual_Buffer_Types.Unsigned_Int
           (An_Instance.Model_Designation);
      end if;

      An_Instance.The_Other_Hazard_Block(2) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Hazard_Path_Designation);
   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Other_Hazard_Block;
   end Data_Word;


end Data_Block.Other_Hazards;
