-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Motion_Command is

  type Instance is new Data_Block.Instance with private;

-- Access Control
   function  Control (An_Instance : in Instance) return Integer;
   procedure Set_Control
     (An_Instance : in out Instance;
      A_Control : in Integer);

-- Access Motion_Angle
   function Motion_Angle  (An_Instance : in Instance) return Float;
   procedure Set_Motion_Angle
     (An_Instance : in out Instance;
      An_Angle : in Float);

-- Access U_Rotation
   function  U_Rotation (An_Instance : in Instance) return Float;
   procedure Set_U_Rotation
     (An_Instance : in out Instance;
      A_Rotation : in Float);

-- Access V_Rotation
   function  V_Rotation (An_Instance : in Instance) return Float;
   procedure Set_V_Rotation
     (An_Instance : in out Instance;
      A_Rotation : in Float);

-- Data Block Methods
   procedure Initialize (An_Instance : in out Instance);

   procedure Pack (An_Instance : in out Instance);

-- Access Data_Block
   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

  type Instance is new Data_Block.Instance with record
    Control : Integer;
    Motion_Angle : Float;
    U_Rotation : Float;
    V_Rotation : Float;
    Motion_Command_Block : Jpats_Visual_Buffer_Types.Block_Array (1..2);
  end record;


end Data_Block.Motion_Command;
