-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Model_HOT_Return is


  type Instance is new Data_Block.Instance with private;

-- Access Data_Valid
   function  Data_Valid (An_Instance : in Instance) return Boolean;
   procedure Set_Data_Valid
     (An_Instance : in out Instance;
      Data_Is_Valid : in Boolean);

-- Access Model_Instance_ID
   function  Model_Instance_ID (An_Instance : in Instance) return Integer;
   procedure Set_Model_Instance_ID
     (An_Instance : in out Instance;
      An_Instance_Id : in Integer);

-- Access Height_Of_Terrain
   function  Height_Of_Terrain (An_Instance : in Instance) return Float;
   procedure Set_Height_Of_Terrain
     (An_Instance : in out Instance;
      A_Height_Of_Terrain : in Float);

-- Data_Block Methods
   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array);
   procedure Initialize (An_Instance : in out Instance);
   procedure Unpack (An_Instance : in out Instance);


private

  type Instance is new Data_Block.Instance with record
    Data_Valid : Boolean;
    Model_Instance_ID : Integer;
    Height_Of_Terrain : Float;
    The_Model_Hot_Return_Block : Jpats_Visual_Buffer_Types.Block_Array (1..2);
  end record;


end Data_Block.Model_HOT_Return;
