-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Model_HOT_Return is


-- Access Data_Valid
   function  Data_Valid
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Data_Valid;
   end Data_Valid;

   procedure Set_Data_Valid
     (An_Instance : in out Instance;
      Data_Is_Valid : in Boolean) is
   begin
      An_Instance.Data_Valid := Data_Is_Valid;
   end Set_Data_Valid;

-- Access Model_Instance_ID
   function  Model_Instance_ID
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Model_Instance_ID;
   end Model_Instance_ID;

   procedure Set_Model_Instance_ID
     (An_Instance : in out Instance;
      An_Instance_Id : in Integer) is
   begin
      An_Instance.Model_Instance_Id := An_Instance_Id;
   end Set_Model_Instance_ID;

-- Access Height_Of_Terrain
   function  Height_Of_Terrain
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Height_Of_Terrain;
   end Height_Of_Terrain;

   procedure Set_Height_Of_Terrain
     (An_Instance : in out Instance;
      A_Height_Of_Terrain : in Float) is
   begin
      An_Instance.Height_Of_Terrain := A_Height_Of_Terrain;
   end Set_Height_Of_Terrain;

   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array) is
   begin
      An_Instance.The_Model_Hot_Return_Block := A_Block;
   end Set_Data_Block;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 2;
      An_Instance.Data_Block_Code := 16#11000000#;
      An_Instance.Use_Data := False;

      An_Instance.Data_Valid := False;
      An_Instance.Model_Instance_Id := 0;
      An_Instance.Height_Of_Terrain := 0.0;

      for I in 1..2 loop
         An_Instance.The_Model_Hot_Return_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Unpack
     (An_Instance : in out Instance) is
   begin
      if (An_Instance.Use_Data) then
         An_Instance.Data_Valid :=
           (An_Instance.The_Model_Hot_Return_Block(1) and 16#00800000#) = 0;
         An_Instance.Model_Instance_Id :=
           Integer(An_Instance.The_Model_Hot_Return_Block(1) and 16#0000001f#);
         An_Instance.Height_Of_Terrain :=
           Float(An_Instance.The_Model_Hot_Return_Block(2) / 16#00000100#);
         An_Instance.Use_Data := False;
      end if;
   end Unpack;


end Data_Block.Model_HOT_Return;
