-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Lightning_Return is


-- Access Lightning_ID
   function  Lightning_ID
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Lightning_ID;
   end Lightning_ID;

   procedure Set_Lightning_ID
     (An_Instance : in out Instance;
      An_Id : in Integer) is
   begin
      An_Instance.Lightning_Id := An_Id;
   end Set_Lightning_ID;

-- Access Latitude
   function  Latitude
     (An_Instance : in Instance)
      return Long_Float is
   begin
      return An_Instance.Latitude;
   end Latitude;

   procedure Set_Latitude
     (An_Instance : in out Instance;
      A_Latitude : in Long_Float) is
   begin
      An_Instance.Latitude := A_Latitude;
   end Set_Latitude;

-- Access Longitude
   function  Longitude
     (An_Instance : in Instance)
      return Long_Float is
   begin
      return An_Instance.Longitude;
   end Longitude;

   procedure Set_Longitude
     (An_Instance : in out Instance;
      A_Longitude : in Long_Float) is
   begin
      An_Instance.Longitude := A_Longitude;
   end Set_Longitude;

   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array) is
   begin
      An_Instance.The_Lightning_Return_Block := A_Block;
   end Set_Data_Block;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 3;
      An_Instance.Data_Block_Code := 16#12000000#;
      An_Instance.Use_Data := False;

      An_Instance.Lightning_Id := 0;
      An_Instance.Latitude := 0.0;
      An_Instance.Longitude := 0.0;

      for I in 1..3 loop
         An_Instance.The_Lightning_Return_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Unpack
     (An_Instance : in out Instance) is
   begin
      if (An_Instance.Use_Data) then
         An_Instance.Lightning_Id :=
           Integer(An_Instance.The_Lightning_Return_Block(1) and 16#0000ffff#);
         An_Instance.Latitude :=
           Long_Float(An_Instance.The_Lightning_Return_Block(2) /
                 Jpats_Visual_Buffer_Types.Unsigned_Int
                 (Jpats_Visual_Buffer_Types.Bams_32bit));
         An_Instance.Longitude :=
           Long_Float(An_Instance.The_Lightning_Return_Block(3) /
                 Jpats_Visual_Buffer_Types.Unsigned_Int
                 (Jpats_Visual_Buffer_Types.Bams_32bit));
         An_Instance.Use_Data := False;
      end if;
   end Unpack;


end Data_Block.Lightning_Return;
