-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.HOT_Return is


   type Instance is new Data_Block.Instance with private;

-- Access Num_HOT_Points
   function  Num_HOT_Points (An_Instance : in Instance) return Integer;
   procedure Set_Num_HOT_Points
     (An_Instance : in out Instance;
      A_Number_Of_Points : in Integer);

-- Access HOT_ID
   function  HOT_ID
     (An_Instance : in Instance;
      Element : in Integer) return Integer;
   procedure Set_HOT_ID
     (An_Instance : in out Instance;
      Element : in Integer;
      An_Id : in Integer);

-- Access Data_Valid
   function  Data_Valid
     (An_Instance : in Instance;
      Element : in Integer) return Boolean;
   procedure Set_Data_Valid
     (An_Instance : in out Instance;
      Element : in Integer;
      Data_Is_Valid : in Boolean);

-- Access Material_Code_Valid
   function  Material_Code_Valid
     (An_Instance : in Instance;
      Element : in Integer) return Boolean;
   procedure Set_Material_Code_Valid
     (An_Instance : in out Instance;
      Element : in Integer;
      Code_Is_Valid : in Boolean);

-- Access Plane_Coefficient_Valid
   function  Plane_Coefficient_Valid
     (An_Instance : in Instance;
      Element : in Integer) return Boolean;
   procedure Set_Plane_Coefficient_Valid
     (An_Instance : in out Instance;
      Element : in Integer;
      Coefficient_Is_Valid : in Boolean);

-- Access Material_Code
   function  Material_Code
     (An_Instance : in Instance;
      Element : in Integer) return Jpats_Visual_Buffer_Types.Material_Enum;
   procedure Set_Material_Code
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Material_Code : in Jpats_Visual_Buffer_Types.Material_Enum);

-- Access Contaminant_Value
   function  Contaminant_Value
     (An_Instance : in Instance;
      Element : in Integer) return Integer;
   procedure Set_Contaminant_Value
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Contaminant_Value : in Integer);

-- Access Contaminant_Material_Code
   function  Contaminant_Material_Code
     (An_Instance : in Instance;
      Element : in Integer) return Jpats_Visual_Buffer_Types.Material_Enum;
   procedure Set_Contaminant_Material_Code
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Material_Code : in Jpats_Visual_Buffer_Types.Material_Enum);

-- Access Aircraft_On_Runway
   function  Aircraft_On_Runway
     (An_Instance : in Instance;
      Element : in Integer) return Boolean;
   procedure Set_Aircraft_On_Runway
     (An_Instance : in out Instance;
      Element : in Integer;
      Is_On_Runway : in Boolean);

-- Access Height_Of_Terrain
   function  Height_Of_Terrain
     (An_Instance : in Instance;
      Element : in Integer) return Float;
   procedure Set_Height_Of_Terrain
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Height_Of_Terrain : in Float);

-- Access X_Distance_From_Plane
   function  X_Distance_From_Plane
     (An_Instance : in Instance;
      Element : in Integer) return Float;
   procedure Set_X_Distance_From_Plane
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Distance : in Float);

-- Access Y_Distance_From_Plane
   function  Y_Distance_From_Plane
     (An_Instance : in Instance;
      Element : in Integer) return Float;
   procedure Set_Y_Distance_From_Plane
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Distance : in Float);

-- Access Z_Distance_From_Plane
   function  Z_Distance_From_Plane
     (An_Instance : in Instance;
      Element : in Integer) return Float;
   procedure Set_Z_Distance_From_Plane
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Distance : in Float);

-- Access Perpendicular_Distance
   function  Perpendicular_Distance
     (An_Instance : in Instance;
      Element : in Integer) return Float;
   procedure Set_Perpendicular_Distance
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Distance : in Float);

-- Access Terrain_Height
   function Terrain_Height (An_Instance : in Instance) return Float;
   procedure Set_Terrain_Height
     (An_Instance : in out Instance;
      A_Height : Float);

-- Data_Block Methods
   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array);
   procedure Initialize (An_Instance : in out Instance);

   procedure Unpack
     (An_Instance : in out Instance;
      Rdb_Height : in Float;
      Integration_Constant : in Float);


private

  type Instance is new Data_Block.Instance with record
    Num_HOT_Points : Integer;
    HOT_ID : Jpats_Visual_Buffer_Types.Hot_Int_Array;
    Data_Valid : Jpats_Visual_Buffer_Types.Hot_Bool_Array;
    Material_Code_Valid : Jpats_Visual_Buffer_Types.Hot_Bool_Array;
    Plane_Coefficient_Valid : Jpats_Visual_Buffer_Types.Hot_Bool_Array;
    Material_Code : Jpats_Visual_Buffer_Types.Hot_Enum_Array;
    Contaminant_Value : Jpats_Visual_Buffer_Types.Hot_Int_Array;
    Contaminant_Material_Code : Jpats_Visual_Buffer_Types.Hot_Enum_Array;
    Aircraft_On_Runway : Jpats_Visual_Buffer_Types.Hot_Bool_Array;
    Height_Of_Terrain : Jpats_Visual_Buffer_Types.Hot_Float_Array;
    X_Distance_From_Plane : Jpats_Visual_Buffer_Types.Hot_Float_Array;
    Y_Distance_From_Plane : Jpats_Visual_Buffer_Types.Hot_Float_Array;
    Z_Distance_From_Plane : Jpats_Visual_Buffer_Types.Hot_Float_Array;
    Perpendicular_Distance : Jpats_Visual_Buffer_Types.Hot_Float_Array;
    The_Hot_Return_Block : Jpats_Visual_Buffer_Types.Block_Array (1..25);
    Terrain_Height : Float;
  end record;


end Data_Block.HOT_Return;
