-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Visual_Buffer_Types;
with Log;

package body Data_Block.HOT_Return is

   Hot_Responce_Timer : Float := 2.0;
   Demanded_Hot : Jpats_Visual_Buffer_Types.Hot_Float_Array;

-- Access Num_HOT_Points
   function  Num_HOT_Points
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Num_HOT_Points;
   end Num_HOT_Points;

   procedure Set_Num_HOT_Points
     (An_Instance : in out Instance;
      A_Number_Of_Points : in Integer) is
   begin
      An_Instance.Num_Hot_Points := A_Number_Of_Points;
   end Set_Num_HOT_Points;

-- Access HOT_ID
   function  HOT_ID
     (An_Instance : in Instance;
      Element : in Integer)
      return Integer is
   begin
      return An_Instance.HOT_Id(Element);
   end HOT_ID;

   procedure Set_HOT_ID
     (An_Instance : in out Instance;
      Element : in Integer;
      An_Id : in Integer) is
   begin
      An_Instance.Hot_Id(Element) := An_Id;
   end Set_HOT_ID;

-- Access Data_Valid
   function  Data_Valid
     (An_Instance : in Instance;
      Element : in Integer)
      return Boolean is
   begin
      return An_Instance.Data_Valid(Element);
   end Data_Valid;

   procedure Set_Data_Valid
     (An_Instance : in out Instance;
      Element : in Integer;
      Data_Is_Valid : in Boolean) is
   begin
      An_Instance.Data_Valid(Element) := Data_Is_Valid;
   end Set_Data_Valid;

-- Access Material_Code_Valid
   function  Material_Code_Valid
     (An_Instance : in Instance;
      Element : in Integer)
      return Boolean is
   begin
      return An_Instance.Material_Code_Valid(Element);
   end Material_Code_Valid;

   procedure Set_Material_Code_Valid
     (An_Instance : in out Instance;
      Element : in Integer;
      Code_Is_Valid : in Boolean) is
   begin
      An_Instance.Material_Code_Valid(Element) := Code_Is_Valid;
   end Set_Material_Code_Valid;

-- Access Plane_Coefficient_Valid
   function  Plane_Coefficient_Valid
     (An_Instance : in Instance;
      Element : in Integer)
      return Boolean is
   begin
      return An_Instance.Plane_Coefficient_Valid(Element);
   end Plane_Coefficient_Valid;

   procedure Set_Plane_Coefficient_Valid
     (An_Instance : in out Instance;
      Element : in Integer;
      Coefficient_Is_Valid : in Boolean) is
   begin
      An_Instance.Plane_Coefficient_Valid(Element) := Coefficient_Is_Valid;
   end Set_Plane_Coefficient_Valid;

-- Access Material_Code
   function  Material_Code
     (An_Instance : in Instance;
      Element : in Integer)
      return Jpats_Visual_Buffer_Types.Material_Enum is
   begin
      return An_Instance.Material_Code(Element);
   end Material_Code;

   procedure Set_Material_Code
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Material_Code : in Jpats_Visual_Buffer_Types.Material_Enum) is
   begin
      An_Instance.Material_Code(Element) := A_Material_Code;
   end Set_Material_Code;

-- Access Contaminant_Value
   function  Contaminant_Value
     (An_Instance : in Instance;
      Element : in Integer)
      return Integer is
   begin
      return An_Instance.Contaminant_Value(Element);
   end Contaminant_Value;

   procedure Set_Contaminant_Value
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Contaminant_Value : in Integer) is
   begin
      An_Instance.Contaminant_Value(Element) := A_Contaminant_Value;
   end Set_Contaminant_Value;

-- Access Contaminant_Material_Code
   function  Contaminant_Material_Code
     (An_Instance : in Instance;
      Element : in Integer)
      return Jpats_Visual_Buffer_Types.Material_Enum is
   begin
      return An_Instance.Contaminant_Material_Code(Element);
   end Contaminant_Material_Code;

   procedure Set_Contaminant_Material_Code
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Material_Code : in Jpats_Visual_Buffer_Types.Material_Enum) is
   begin
      An_Instance.Contaminant_Material_Code(Element) := A_Material_Code;
   end Set_Contaminant_Material_Code;

-- Access Aircraft_On_Runway
   function  Aircraft_On_Runway
     (An_Instance : in Instance;
      Element : in Integer)
      return Boolean is
   begin
      return An_Instance.Aircraft_On_Runway(Element);
   end Aircraft_On_Runway;

   procedure Set_Aircraft_On_Runway
     (An_Instance : in out Instance;
      Element : in Integer;
      Is_On_Runway : in Boolean) is
   begin
      An_Instance.Aircraft_On_Runway(Element) := Is_On_Runway;
   end Set_Aircraft_On_Runway;

-- Access Height_Of_Terrain
   function  Height_Of_Terrain
     (An_Instance : in Instance;
      Element : in Integer)
      return Float is
   begin
      return An_Instance.Height_Of_Terrain(Element);
   end Height_Of_Terrain;

   procedure Set_Height_Of_Terrain
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Height_Of_Terrain : in Float) is
   begin
      An_Instance.Height_Of_Terrain(Element) := A_Height_Of_Terrain;
   end Set_Height_Of_Terrain;

-- Access X_Distance_From_Plane
   function  X_Distance_From_Plane
     (An_Instance : in Instance;
      Element : in Integer)
      return Float is
   begin
      return An_Instance.X_Distance_From_Plane(Element);
   end X_Distance_From_Plane;

   procedure Set_X_Distance_From_Plane
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Distance : in Float) is
   begin
      An_Instance.X_Distance_From_Plane(Element) := A_Distance;
   end Set_X_Distance_From_Plane;

-- Access Y_Distance_From_Plane
   function  Y_Distance_From_Plane
     (An_Instance : in Instance;
      Element : in Integer)
      return Float is
   begin
      return An_Instance.Y_Distance_From_Plane(Element);
   end Y_Distance_From_Plane;

   procedure Set_Y_Distance_From_Plane
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Distance : in Float) is
   begin
      An_Instance.Y_Distance_From_Plane(Element) := A_Distance;
   end Set_Y_Distance_From_Plane;

-- Access Z_Distance_From_Plane
   function  Z_Distance_From_Plane
     (An_Instance : in Instance;
      Element : in Integer)
      return Float is
   begin
      return An_Instance.Z_Distance_From_Plane(Element);
   end Z_Distance_From_Plane;

   procedure Set_Z_Distance_From_Plane
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Distance : in Float) is
   begin
      An_Instance.Z_Distance_From_Plane(Element) := A_Distance;
   end Set_Z_Distance_From_Plane;

-- Access Perpendicular_Distance
   function  Perpendicular_Distance
     (An_Instance : in Instance;
      Element : in Integer)
      return Float is
   begin
      return An_Instance.Perpendicular_Distance(Element);
   end Perpendicular_Distance;

   procedure Set_Perpendicular_Distance
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Distance : in Float) is
   begin
      An_Instance.Perpendicular_Distance(Element) := A_Distance;
   end Set_Perpendicular_Distance;

-- Access Terrain_Height
   function  Terrain_Height
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Terrain_Height;
   end Terrain_Height;

   procedure Set_Terrain_Height
     (An_Instance : in out Instance;
      A_Height : in Float) is
   begin
      An_Instance.Terrain_Height := A_Height;
   end Set_Terrain_Height;

   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array) is
   begin
      An_Instance.The_Hot_Return_Block := A_Block;
   end Set_Data_Block;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 25;
      An_Instance.Data_Block_Code := 16#10000000#;
      An_Instance.Use_Data := False;

      An_Instance.Num_Hot_Points := 4;
      An_Instance.Terrain_Height := 0.0;
      for I in 1..4 loop
         An_Instance.Hot_Id(I) := 0;
         An_Instance.Data_Valid(I) := False;
         An_Instance.Material_Code_Valid(I) := False;
         An_Instance.Plane_Coefficient_Valid(I) := False;
         An_Instance.Material_Code(I) :=
           Jpats_Visual_Buffer_Types.Material_Enum'val(9);
         An_Instance.Contaminant_Value(I) := 0;
         An_Instance.Contaminant_Material_Code(I) :=
           Jpats_Visual_Buffer_Types.Material_Enum'val(0);
         An_Instance.Height_Of_Terrain(I) := 0.0;
         Demanded_Hot(I) := 0.0;
         An_Instance.X_Distance_From_Plane(I) := 0.0;
         An_Instance.Y_Distance_From_Plane(I) := 0.0;
         An_Instance.Z_Distance_From_Plane(I) := 0.0;
         An_Instance.Perpendicular_Distance(I) := 0.0;
         An_Instance.Aircraft_On_Runway(I) := true;
      end loop;

      for I in 1..25 loop
         An_Instance.The_Hot_Return_Block(I) := 0;
      end loop;

   exception
      when others =>
         Log.Report ("Data_Block-Hot_Return.Initialize()");
         raise;

   end Initialize;

   procedure Unpack
     (An_Instance : in out Instance;
      Rdb_Height : in Float;
      Integration_Constant : in FLoat) is
      Index : Integer;
      Mat_Code : array (1..4) of Integer;
      Contam_Value : array (1..4) of Integer;
      Contam_Mat_Code : array (1..4) of Integer;
      On_Runway : array (1..4) of Boolean;
      Hot : array (1..4) of Float;
      X_Dist : array (1..4) of Float;
      Y_Dist : array (1..4) of Float;
      Z_Dist : array (1..4) of Float;
      Perp_Dist : array (1..4) of Float;
      Mat_Valid : array (1..4) of Boolean;
      Plane_Valid : array (1..4) of Boolean;
      Hot_Valid : array (1..4) of Boolean;
   begin

      Hot_Responce_Timer := Hot_Responce_Timer + Integration_Constant;

      if (An_Instance.Use_Data) then
         Hot_Responce_Timer := 0.0;

         An_Instance.Num_Hot_Points :=
           Integer(((An_Instance.The_Hot_Return_Block(1) and 16#00030000#)
                    / 16#00010000#) and 16#00000003#) + 1;
         for I in 1..An_Instance.Num_Hot_Points loop
            Index := 6*I - 4;
            Hot_Valid(I) :=
              (An_Instance.The_Hot_Return_Block(Index) and 16#80000000#) = 0;
            if (Hot_Valid(I)) then
               Hot(I) := Float
                  (Integer(An_Instance.The_Hot_Return_Block(Index + 1)))
                               / 256.0;
               On_Runway(I) := (An_Instance.The_Hot_Return_Block(Index)
                                and 16#00000003#) /= 0;
               Mat_Valid(I) := (An_Instance.The_Hot_Return_Block(Index)
                                and 16#40000000#) = 0;
               if (Mat_Valid(I)) then
                  Mat_Code(I) :=
                     Integer(((An_Instance.The_Hot_Return_Block(Index)
                               and 16#1f000000#) / 16#01000000#)
                               and 16#0000001f#);
                  Contam_Value(I) :=
                     Integer(((An_Instance.The_Hot_Return_Block(Index)
                               and 16#00ff0000#) / 16#00010000#)
                               and 16#000000ff#);
                  Contam_Mat_Code(I) :=
                     Integer(((An_Instance.The_Hot_Return_Block(Index)
                               and 16#0000f800#) / 16#00000800#)
                               and 16#0000001f#);
               else
                  Mat_Code(I) := 9;
                  Contam_Value(I) := 0;
                  Contam_Mat_Code(I) := 0;
               end if;
               Plane_Valid(I) := (An_Instance.The_Hot_Return_Block(Index)
                                  and 16#20000000#) = 0;
               if (Plane_Valid(I)) then
                  X_Dist(I) :=
                    Float(An_Instance.The_Hot_Return_Block(Index+2) /
                          16#80000000#);
                  Y_Dist(I) :=
                    Float(An_Instance.The_Hot_Return_Block(Index+3) /
                          16#80000000#);
                  Z_Dist(I) :=
                    Float(An_Instance.The_Hot_Return_Block(Index+4) /
                          16#80000000#);
               else
                  X_Dist(I) := 0.0;
                  Y_Dist(I) := 0.0;
                  Z_Dist(I) := 0.0;
               end if;
               Perp_Dist(I) :=
                 Float(An_Instance.The_Hot_Return_Block(Index + 5) / 256);
            else
               Mat_Valid(I) := False;
               Plane_Valid(I) := False;
               On_Runway(I) := True;
               Mat_Code(I) := 9;
               Contam_Value(I) := 0;
               Contam_Mat_Code(I) := 0;
               On_Runway(I) := True;
               X_Dist(I) := 0.0;
               Y_Dist(I) := 0.0;
               Z_Dist(I) := 0.0;
               Hot(I) := 0.0;
               Perp_Dist(I) := 0.0;
            end if;
         end loop;

         for I in 1..4 loop
            An_Instance.Data_Valid(I) := True;
            if (Hot_Valid(I) and Hot(I) > -1500.0) then
               Demanded_Hot(I) := Demanded_Hot(I) +
                (Hot(I) - Demanded_Hot(I))* (6.0*Integration_Constant);
            else
               Demanded_Hot(I) := Rdb_Height;
            end if;
            An_Instance.Height_Of_Terrain(I) :=
              An_Instance.Height_Of_Terrain(I) +
              (Demanded_Hot(I) - An_Instance.Height_Of_Terrain(I))*
              (6.0*Integration_Constant);
            An_Instance.Material_Code_Valid(I) := Mat_Valid(I);
            An_Instance.Plane_Coefficient_Valid(I) := Plane_Valid(I);
            If (Mat_Code(I) < 0) or (Mat_Code(I) > 31) then
               An_Instance.Material_Code(I) :=
                  Jpats_Visual_Buffer_Types.Material_Enum'val(9);
            else
               An_Instance.Material_Code(I) :=
                  Jpats_Visual_Buffer_Types.Material_Enum'val(Mat_Code(I));
            end if;
            If Contam_Value(I) < 0 then
               An_Instance.Contaminant_Value(I) := 0;
            elsif Contam_Value(I) > 100 then
               An_Instance.Contaminant_Value(I) := 100;
            else
               An_Instance.Contaminant_Value(I) := Contam_Value(I);
            end if;
            If (Contam_Mat_Code(I) < 0) or (Contam_Mat_Code(I) > 31) then
               An_Instance.Contaminant_Material_Code(I) :=
                  Jpats_Visual_Buffer_Types.Material_Enum'val(0);
            else
               An_Instance.Contaminant_Material_Code(I) :=
                  Jpats_Visual_Buffer_Types.Material_Enum'val(Contam_Mat_Code(I));
            end if;
            An_Instance.Aircraft_On_Runway(I) := On_Runway(I);
            An_Instance.X_Distance_From_Plane(I) := 0.0;
            An_Instance.Y_Distance_From_Plane(I) := 0.0;
            An_Instance.Z_Distance_From_Plane(I) := 0.0;
            An_Instance.Perpendicular_Distance(I) := 0.0;
         end loop;

         An_Instance.Use_Data := False;
      else
         if Hot_Responce_Timer > 2.0 then
            Hot_Responce_Timer := 2.0;
            for I in 1..4 loop
               An_Instance.Data_Valid(I) := True;
               An_Instance.Height_Of_Terrain(I) := Rdb_Height;
               An_Instance.Material_Code_Valid(I) := False;
               An_Instance.Plane_Coefficient_Valid(I) := False;
               An_Instance.Material_Code(I) :=
                 Jpats_Visual_Buffer_Types.Material_Enum'val(9);
               An_Instance.Contaminant_Value(I) := 0;
               An_Instance.Contaminant_Material_Code(I) :=
                 Jpats_Visual_Buffer_Types.Material_Enum'val(0);
               An_Instance.Aircraft_On_Runway(I) := True;
               An_Instance.X_Distance_From_Plane(I) := 0.0;
               An_Instance.Y_Distance_From_Plane(I) := 0.0;
               An_Instance.Z_Distance_From_Plane(I) := 0.0;
               An_Instance.Perpendicular_Distance(I) := 0.0;
            end loop;
         end if;
      end if;

      An_Instance.Terrain_Height := (An_Instance.Height_Of_Terrain(1) +
                                     An_Instance.Height_Of_Terrain(2)) / 2.0;

   exception
      when others =>
         Log.Report ("Data_Block-Hot_Return.Unpack()");
         raise;

   end Unpack;

end Data_Block.HOT_Return;
