-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.HOT_Request is


   type Instance is new Data_Block.Instance with private;

-- Access Number_HOT_Points
   function  Number_HOT_Points (An_Instance : in Instance) return Integer;
   procedure Set_Number_HOT_Points
     (An_Instance : in out Instance;
      A_Number_Of_Points : in Integer);

-- Access HOT_ID
   function  HOT_ID
     (An_Instance : in Instance) return Integer;
   procedure Set_HOT_ID
     (An_Instance : in out Instance;
      An_Id : in Integer);

-- Access Point_Latitude
   function  Point_Latitude
     (An_Instance : in Instance;
      Element : in Integer) return Long_Float;
   procedure Set_Point_Latitude
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Latitude : in Long_Float);

-- Access Point_Longitude
   function  Point_Longitude
     (An_Instance : in Instance;
      Element : in Integer) return Long_Float;
   procedure Set_Point_Longitude
     (An_Instance : in out Instance;
      Element : in Integer;
      A_Longitude : in Long_Float);

-- Method Predict_AC_Position
   procedure Predict_AC_Position
     (An_Instance : in out Instance;
      Ac_Latitude :in Long_Float;
      Ac_Longitude : in Long_Float;
      Integration_Constant : in Float);

-- Method Gear_Lat_Lon_Position
   procedure Gear_Lat_Lon_Position
     (An_Instance : in out Instance;
      Ac_Latitude : in Long_Float;
      Ac_Heading : in Float);

-- Data_Block Methods
   procedure Initialize (An_Instance : in out Instance);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

  type Instance is new Data_Block.Instance with record
    Number_HOT_Points : Integer;
    HOT_ID : Integer;
    Point_Latitude : Jpats_Visual_Buffer_Types.Hot_Long_Float_Array;
    Point_Longitude : Jpats_Visual_Buffer_Types.Hot_Long_Float_Array;
    The_Hot_Request_Block : Jpats_Visual_Buffer_Types.Block_Array (1..9);
  end record;


end Data_Block.HOT_Request;
