-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6B Texan-II Flight Training Device
--
--
--  Engineer:  Pamela Danner
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;
with Lat_Long_Types;

package Data_Block.High_Precision_Ownship_Send is


  type Instance is new Data_Block.Instance with private;

-- Access X_Eyepoint
   function  X_Eyepoint (An_Instance : in Instance) return Float;
   procedure Set_X_Eyepoint
     (An_Instance : in out Instance;
      An_Eyepoint : in Float);

-- Access Y Eyepoint
   function Y_Eyepoint (An_Instance : in Instance) return Float;
   procedure Set_Y_Eyepoint
     (An_Instance : in out Instance;
      An_Eyepoint : in Float);

-- Access Z_Eyepoint
   function  Z_Eyepoint (An_Instance : in Instance) return Float;
   procedure Set_Z_Eyepoint
     (An_Instance : in out Instance;
      An_Eyepoint : in Float);

-- Access IEEE 754 CG
   function Ieee_754_Cg (An_Instance : in Instance) return Boolean;
   procedure Set_Ieee_754_Cg
     (An_Instance : in out Instance;
      Ieee_754_Cg : in Boolean);

-- Access Wipers
   function Wipers (An_Instance : in Instance) return Boolean;
   procedure Set_Wipers
     (An_Instance : in out Instance;
      Wipers_On : in Boolean);

-- Access Wing_Strobe_Light
   function  Wing_Strobe_Light (An_Instance : in Instance) return Boolean;
   procedure Set_Wing_Strobe_Light
     (An_Instance : in out Instance;
      Light_On : in Boolean);

-- Access Anti_Coll_Beacon_1
   function  Anti_Coll_Beacon_1 (An_Instance : in Instance) return Boolean;
   procedure Set_Anti_Coll_Beacon_1
     (An_Instance : in out Instance;
      Light_On : in Boolean);

-- Access Anti_Coll_Beacon_2
   function  Anti_Coll_Beacon_2 (An_Instance : in Instance) return Boolean;
   procedure Set_Anti_Coll_Beacon_2
     (An_Instance : in out Instance;
      Light_On : in Boolean);

-- Access Anti_Coll_Beacon_3
   function  Anti_Coll_Beacon_3 (An_Instance : in Instance) return Boolean;
   procedure Set_Anti_Coll_Beacon_3
     (An_Instance : in out Instance;
      Light_On : in Boolean);

-- Access Anti_Coll_Beacon_4
   function  Anti_Coll_Beacon_4 (An_Instance : in Instance) return Boolean;
   procedure Set_Anti_Coll_Beacon_4
     (An_Instance : in out Instance;
      Light_On : in Boolean);

-- Access Anti_Coll_Beacon_5
   function  Anti_Coll_Beacon_5 (An_Instance : in Instance) return Boolean;
   procedure Set_Anti_Coll_Beacon_5
     (An_Instance : in out Instance;
      Light_On : in Boolean);

-- Access Anti_Coll_Beacon_6
   function  Anti_Coll_Beacon_6 (An_Instance : in Instance) return Boolean;
   procedure Set_Anti_Coll_Beacon_6
     (An_Instance : in out Instance;
      Light_On : in Boolean);

-- Access Anti_Coll_Beacon_7
   function  Anti_Coll_Beacon_7 (An_Instance : in Instance) return Boolean;
   procedure Set_Anti_Coll_Beacon_7
     (An_Instance : in out Instance;
      Light_On : in Boolean);

-- Access Weight_On_Wheels
   function  Weight_On_Wheels (An_Instance : in Instance) return Boolean;
   procedure Set_Weight_On_Wheels
     (An_Instance : in out Instance;
      On_Wheels : in Boolean);

-- Access Ambient_Lighting
   function  Ambient_Lighting (An_Instance : in Instance) return Boolean;
   procedure Set_Ambient_Lighting
     (An_Instance : in out Instance;
      An_Ambient_Lighting : in Boolean);

-- Access Device Disable Mask 0
   function Device_Disable_Mask_0 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_0
     (An_Instance : in out Instance;
      Device_Disable_Mask_0 : in Boolean);

-- Access Device Disable Mask 1
   function Device_Disable_Mask_1 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_1
     (An_Instance : in out Instance;
      Device_Disable_Mask_1 : in Boolean);

-- Access Device Disable Mask 2
   function Device_Disable_Mask_2 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_2
     (An_Instance : in out Instance;
      Device_Disable_Mask_2 : in Boolean);

-- Access Device Disable Mask 3
   function Device_Disable_Mask_3 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_3
     (An_Instance : in out Instance;
      Device_Disable_Mask_3 : in Boolean);

-- Access Device Disable Mask 4
   function Device_Disable_Mask_4 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_4
     (An_Instance : in out Instance;
      Device_Disable_Mask_4 : in Boolean);

-- Access Device Disable Mask 5
   function Device_Disable_Mask_5 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_5
     (An_Instance : in out Instance;
      Device_Disable_Mask_5 : in Boolean);

-- Access Device Disable Mask 6
   function Device_Disable_Mask_6 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_6
     (An_Instance : in out Instance;
      Device_Disable_Mask_6 : in Boolean);

-- Access Device Disable Mask 7
   function Device_Disable_Mask_7 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_7
     (An_Instance : in out Instance;
      Device_Disable_Mask_7 : in Boolean);

-- Access Device Disable Mask 8
   function Device_Disable_Mask_8 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_8
     (An_Instance : in out Instance;
      Device_Disable_Mask_8 : in Boolean);

-- Access Device Disable Mask 9
   function Device_Disable_Mask_9 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_9
     (An_Instance : in out Instance;
      Device_Disable_Mask_9 : in Boolean);

-- Access Device Disable Mask 10
   function Device_Disable_Mask_10 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_10
     (An_Instance : in out Instance;
      Device_Disable_Mask_10 : in Boolean);

-- Access Device Disable Mask 11
   function Device_Disable_Mask_11 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_11
     (An_Instance : in out Instance;
      Device_Disable_Mask_11 : in Boolean);

-- Access Device Disable Mask 12
   function Device_Disable_Mask_12 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_12
     (An_Instance : in out Instance;
      Device_Disable_Mask_12 : in Boolean);

-- Access Device Disable Mask 13
   function Device_Disable_Mask_13 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_13
     (An_Instance : in out Instance;
      Device_Disable_Mask_13 : in Boolean);

-- Access Device Disable Mask 14
   function Device_Disable_Mask_14 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_14
     (An_Instance : in out Instance;
      Device_Disable_Mask_14 : in Boolean);

-- Access Device Disable Mask 15
   function Device_Disable_Mask_15 (An_Instance : in Instance) return Boolean;
   procedure Set_Device_Disable_Mask_15
     (An_Instance : in out Instance;
      Device_Disable_Mask_15 : in Boolean);

-- Access Vis_Pitch
   function  Vis_Pitch (An_Instance : in Instance) return Float;
   procedure Set_Vis_Pitch
     (An_Instance : in out Instance;
      A_Pitch  : in Float);

-- Access Vis_Roll
   function  Vis_Roll (An_Instance : in Instance) return Float;
   procedure Set_Vis_Roll
     (An_Instance : in out Instance;
      A_Roll : in Float);

-- Access Vis_Heading
   function  Vis_Heading (An_Instance : in Instance) return Float;
   procedure Set_Vis_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float);

-- Access Vis_Latitude
   function  Vis_Position (An_Instance : in Instance)
     return Lat_Long_Types.Position;
   procedure Set_Vis_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position);

-- Method Compute_Ambient_Light
   procedure Compute_Ambient_Light
     (An_Instance : in out Instance;
      A_Time_Of_Day : in Integer);

-- Method Compute_Eyepoint
   procedure Compute_Eyepoint
     (An_Instance : in out Instance;
      X_Cg : in Float;
      Z_Cg : in Float);

-- Data_Block Methods
   procedure Initialize (An_Instance : in out Instance);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

  type Instance is new Data_Block.Instance with record
     X_Eyepoint : Float;
     Y_Eyepoint : Float;
     Z_Eyepoint : Float;
     Ieee_754_Cg : Boolean;
     Wipers : Boolean;
     Wing_Strobe_Light : Boolean;
     Anti_Coll_Beacon_1 : Boolean;
     Anti_Coll_Beacon_2 : Boolean;
     Anti_Coll_Beacon_3 : Boolean;
     Anti_Coll_Beacon_4 : Boolean;
     Anti_Coll_Beacon_5 : Boolean;
     Anti_Coll_Beacon_6 : Boolean;
     Anti_Coll_Beacon_7 : Boolean;
     Weight_On_Wheels : Boolean;
     Ambient_Lighting : Boolean;
     Device_Disable_Mask_0 : Boolean;
     Device_Disable_Mask_1 : Boolean;
     Device_Disable_Mask_2 : Boolean;
     Device_Disable_Mask_3 : Boolean;
     Device_Disable_Mask_4 : Boolean;
     Device_Disable_Mask_5 : Boolean;
     Device_Disable_Mask_6 : Boolean;
     Device_Disable_Mask_7 : Boolean;
     Device_Disable_Mask_8 : Boolean;
     Device_Disable_Mask_9 : Boolean;
     Device_Disable_Mask_10 : Boolean;
     Device_Disable_Mask_11 : Boolean;
     Device_Disable_Mask_12 : Boolean;
     Device_Disable_Mask_13 : Boolean;
     Device_Disable_Mask_14 : Boolean;
     Device_Disable_Mask_15 : Boolean;
     Vis_Pitch : Float;
     Vis_Roll : Float;
     Vis_Heading : Float;
     Vis_Position : Lat_Long_Types.Position;
     The_High_Precision_Ownship_Block : Jpats_Visual_Buffer_Types.Block_Array (1..12);
  end record;


end Data_Block.High_Precision_Ownship_Send;
