-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6B Texan-II Flight Training Device
--
--
--  Engineer:  Pamela Danner
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Text_Io;
with Ada.Float_Text_Io;
use Ada.Text_Io, Ada.Float_Text_Io;

package body Data_Block.High_Precision_Ownship_Send is

   Eyepoint_Station : constant := 13.8;
   Eyepoint_Waterline : constant := 10.25;

   procedure Lat_Lon_Convert
     (Lat_Lon : in Long_Float;
      Word_1_Lat_Lon : in out Jpats_Visual_Buffer_Types.Unsigned_Int;
      Word_2_Lat_Lon : in out Jpats_Visual_Buffer_Types.Unsigned_Int) is
      Bams_31 : constant := 32768.0 * 65536.0;
      Temp_Real : Long_Float;
      Temp_Word_1 : Integer;
      Temp_Word_2 : Integer;
   begin
      Temp_Real := Lat_Lon * Jpats_Visual_Buffer_Types.Bams_32bit;
      Temp_Word_1 := Integer(Long_Float'Truncation(Temp_Real));
      Temp_Real := Temp_Real - Long_Float(Temp_Word_1);
      if (Temp_Real < 0.0) then
         Temp_Word_1 := Temp_Word_1 - 1;
         Temp_Real := Temp_Real + 1.0;
      end if;
      Temp_Real := Temp_Real * Bams_31;
      Temp_Word_2 := Integer(Long_Float'Truncation(Temp_Real));
      Word_1_Lat_Lon :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(Temp_Word_1);
      Word_2_Lat_Lon :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(Temp_Word_2) * 16#00000002#;
   end Lat_Lon_Convert;


-- Access X_Eyepoint
   function  X_Eyepoint
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.X_Eyepoint;
   end X_Eyepoint;

   procedure Set_X_Eyepoint
     (An_Instance : in out Instance;
      An_Eyepoint : in Float) is
   begin
      An_Instance.X_Eyepoint := An_Eyepoint;
   end Set_X_Eyepoint;

-- Access Y Eyepoint
   function Y_Eyepoint
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Y_Eyepoint;
   end Y_Eyepoint;

   procedure Set_Y_Eyepoint
     (An_Instance : in out Instance;
      An_Eyepoint : in Float) is
   begin
      An_Instance.Y_Eyepoint := An_Eyepoint;
      end Set_Y_Eyepoint;

-- Access Z_Eyepoint
   function  Z_Eyepoint
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Z_Eyepoint;
   end Z_Eyepoint;

   procedure Set_Z_Eyepoint
     (An_Instance : in out Instance;
      An_Eyepoint : in Float) is
   begin
      An_Instance.Z_Eyepoint := An_Eyepoint;
   end Set_Z_Eyepoint;

-- Access IEEE 754 CG
   function Ieee_754_Cg
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Ieee_754_Cg;
   end Ieee_754_Cg;

   procedure Set_Ieee_754_Cg
     (An_Instance : in out Instance;
      Ieee_754_Cg : in Boolean) is
   begin
      An_Instance.Ieee_754_Cg := Ieee_754_Cg;
   end Set_Ieee_754_Cg;

-- Access Wipers
   function Wipers
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Wipers;
   end Wipers;

   procedure Set_Wipers
     (An_Instance : in out Instance;
      Wipers_On : in Boolean) is
   begin
      An_Instance.Wipers := Wipers_On;
   end Set_Wipers;

-- Access Wing_Strobe_Light
   function  Wing_Strobe_Light
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Wing_Strobe_Light;
   end Wing_Strobe_Light;

   procedure Set_Wing_Strobe_Light
     (An_Instance : in out Instance;
      Light_On : in Boolean) is
   begin
      An_Instance.Wing_Strobe_Light := Light_On;
   end Set_Wing_Strobe_Light;

-- Access Anti_Coll_Beacon_1
   function  Anti_Coll_Beacon_1
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Anti_Coll_Beacon_1;
   end Anti_Coll_Beacon_1;

   procedure Set_Anti_Coll_Beacon_1
     (An_Instance : in out Instance;
      Light_On : in Boolean) is
   begin
      An_Instance.Anti_Coll_Beacon_1 := Light_On;
   end Set_Anti_Coll_Beacon_1;

-- Access Anti_Coll_Beacon_2
   function  Anti_Coll_Beacon_2
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Anti_Coll_Beacon_2;
   end Anti_Coll_Beacon_2;

   procedure Set_Anti_Coll_Beacon_2
     (An_Instance : in out Instance;
      Light_On : in Boolean) is
   begin
      An_Instance.Anti_Coll_Beacon_2 := Light_On;
   end Set_Anti_Coll_Beacon_2;

-- Access Anti_Coll_Beacon_3
   function  Anti_Coll_Beacon_3
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Anti_Coll_Beacon_3;
   end Anti_Coll_Beacon_3;

   procedure Set_Anti_Coll_Beacon_3
     (An_Instance : in out Instance;
      Light_On : in Boolean) is
   begin
      An_Instance.Anti_Coll_Beacon_3 := Light_On;
   end Set_Anti_Coll_Beacon_3;

-- Access Anti_Coll_Beacon_4
   function  Anti_Coll_Beacon_4
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Anti_Coll_Beacon_4;
   end Anti_Coll_Beacon_4;

   procedure Set_Anti_Coll_Beacon_4
     (An_Instance : in out Instance;
      Light_On : in Boolean) is
   begin
      An_Instance.Anti_Coll_Beacon_4 := Light_On;
   end Set_Anti_Coll_Beacon_4;

-- Access Anti_Coll_Beacon_5
   function  Anti_Coll_Beacon_5
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Anti_Coll_Beacon_5;
   end Anti_Coll_Beacon_5;

   procedure Set_Anti_Coll_Beacon_5
     (An_Instance : in out Instance;
      Light_On : in Boolean) is
   begin
      An_Instance.Anti_Coll_Beacon_5 := Light_On;
   end Set_Anti_Coll_Beacon_5;

-- Access Anti_Coll_Beacon_6
   function  Anti_Coll_Beacon_6
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Anti_Coll_Beacon_6;
   end Anti_Coll_Beacon_6;

   procedure Set_Anti_Coll_Beacon_6
     (An_Instance : in out Instance;
      Light_On : in Boolean) is
   begin
      An_Instance.Anti_Coll_Beacon_6 := Light_On;
   end Set_Anti_Coll_Beacon_6;

-- Access Anti_Coll_Beacon_7
   function  Anti_Coll_Beacon_7
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Anti_Coll_Beacon_7;
   end Anti_Coll_Beacon_7;

   procedure Set_Anti_Coll_Beacon_7
     (An_Instance : in out Instance;
      Light_On : in Boolean) is
   begin
      An_Instance.Anti_Coll_Beacon_7 := Light_On;
   end Set_Anti_Coll_Beacon_7;

-- Access Weight_On_Wheels
   function  Weight_On_Wheels
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Weight_On_Wheels;
   end Weight_On_Wheels;

   procedure Set_Weight_On_Wheels
     (An_Instance : in out Instance;
      On_Wheels : in Boolean) is
   begin
      An_Instance.Weight_On_Wheels := On_Wheels;
   end Set_Weight_On_Wheels;

-- Access Ambient_Lighting
   function  Ambient_Lighting
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Ambient_Lighting;
   end Ambient_Lighting;

   procedure Set_Ambient_Lighting
     (An_Instance : in out Instance;
      An_Ambient_Lighting : in Boolean) is
   begin
      An_Instance.Ambient_Lighting := An_Ambient_Lighting;
   end Set_Ambient_Lighting;

-- Access Device Disable Mask 0
   function Device_Disable_Mask_0
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_0;
   end Device_Disable_Mask_0;

   procedure Set_Device_Disable_Mask_0
     (An_Instance : in out Instance;
      Device_Disable_Mask_0 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_0 := Device_Disable_Mask_0;
   end Set_Device_Disable_Mask_0;

-- Access Device Disable Mask 1
   function Device_Disable_Mask_1
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_1;
   end Device_Disable_Mask_1;

   procedure Set_Device_Disable_Mask_1
     (An_Instance : in out Instance;
      Device_Disable_Mask_1 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_1 := Device_Disable_Mask_1;
   end Set_Device_Disable_Mask_1;

-- Access Device Disable Mask 2
   function Device_Disable_Mask_2
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_2;
   end Device_Disable_Mask_2;

   procedure Set_Device_Disable_Mask_2
     (An_Instance : in out Instance;
      Device_Disable_Mask_2 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_2 := Device_Disable_Mask_2;
   end Set_Device_Disable_Mask_2;

-- Access Device Disable Mask 3
   function Device_Disable_Mask_3
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_3;
   end Device_Disable_Mask_3;

   procedure Set_Device_Disable_Mask_3
     (An_Instance : in out Instance;
      Device_Disable_Mask_3 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_3 := Device_Disable_Mask_3;
   end Set_Device_Disable_Mask_3;

-- Access Device Disable Mask 4
   function Device_Disable_Mask_4
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_4;
   end Device_Disable_Mask_4;

   procedure Set_Device_Disable_Mask_4
     (An_Instance : in out Instance;
      Device_Disable_Mask_4 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_4 := Device_Disable_Mask_4;
   end Set_Device_Disable_Mask_4;

-- Access Device Disable Mask 5
   function Device_Disable_Mask_5
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_5;
   end Device_Disable_Mask_5;

   procedure Set_Device_Disable_Mask_5
     (An_Instance : in out Instance;
      Device_Disable_Mask_5 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_5 := Device_Disable_Mask_5;
   end Set_Device_Disable_Mask_5;

-- Access Device Disable Mask 6
   function Device_Disable_Mask_6
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_6;
   end Device_Disable_Mask_6;

   procedure Set_Device_Disable_Mask_6
     (An_Instance : in out Instance;
      Device_Disable_Mask_6 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_6 := Device_Disable_Mask_6;
   end Set_Device_Disable_Mask_6;

-- Access Device Disable Mask 7
   function Device_Disable_Mask_7
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_7;
   end Device_Disable_Mask_7;

   procedure Set_Device_Disable_Mask_7
     (An_Instance : in out Instance;
      Device_Disable_Mask_7 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_7 := Device_Disable_Mask_7;
   end Set_Device_Disable_Mask_7;

-- Access Device Disable Mask 8
   function Device_Disable_Mask_8
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_8;
   end Device_Disable_Mask_8;

   procedure Set_Device_Disable_Mask_8
     (An_Instance : in out Instance;
      Device_Disable_Mask_8 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_8 := Device_Disable_Mask_8;
   end Set_Device_Disable_Mask_8;

-- Access Device Disable Mask 9
   function Device_Disable_Mask_9
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_9;
   end Device_Disable_Mask_9;

   procedure Set_Device_Disable_Mask_9
     (An_Instance : in out Instance;
      Device_Disable_Mask_9 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_9 := Device_Disable_Mask_9;
   end Set_Device_Disable_Mask_9;

-- Access Device Disable Mask 10
   function Device_Disable_Mask_10
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_10;
   end Device_Disable_Mask_10;

   procedure Set_Device_Disable_Mask_10
     (An_Instance : in out Instance;
      Device_Disable_Mask_10 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_10 := Device_Disable_Mask_10;
   end Set_Device_Disable_Mask_10;

-- Access Device Disable Mask 11
   function Device_Disable_Mask_11
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_11;
   end Device_Disable_Mask_11;

   procedure Set_Device_Disable_Mask_11
     (An_Instance : in out Instance;
      Device_Disable_Mask_11 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_11 := Device_Disable_Mask_11;
   end Set_Device_Disable_Mask_11;

-- Access Device Disable Mask 12
   function Device_Disable_Mask_12
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_12;
   end Device_Disable_Mask_12;

   procedure Set_Device_Disable_Mask_12
     (An_Instance : in out Instance;
      Device_Disable_Mask_12 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_12 := Device_Disable_Mask_12;
   end Set_Device_Disable_Mask_12;

-- Access Device Disable Mask 13
   function Device_Disable_Mask_13
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_13;
   end Device_Disable_Mask_13;

   procedure Set_Device_Disable_Mask_13
     (An_Instance : in out Instance;
      Device_Disable_Mask_13 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_13 := Device_Disable_Mask_13;
   end Set_Device_Disable_Mask_13;

-- Access Device Disable Mask 14
   function Device_Disable_Mask_14
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_14;
   end Device_Disable_Mask_14;

   procedure Set_Device_Disable_Mask_14
     (An_Instance : in out Instance;
      Device_Disable_Mask_14 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_14 := Device_Disable_Mask_14;
   end Set_Device_Disable_Mask_14;

-- Access Device Disable Mask 15
   function Device_Disable_Mask_15
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Device_Disable_Mask_15;
   end Device_Disable_Mask_15;

   procedure Set_Device_Disable_Mask_15
     (An_Instance : in out Instance;
      Device_Disable_Mask_15 : in Boolean) is
   begin
      An_Instance.Device_Disable_Mask_15 := Device_Disable_Mask_15;
   end Set_Device_Disable_Mask_15;

-- Access Vis_Pitch
   function  Vis_Pitch
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Vis_Pitch;
   end Vis_Pitch;

   procedure Set_Vis_Pitch
     (An_Instance : in out Instance;
      A_Pitch : in Float) is
   begin
      An_Instance.Vis_Pitch := A_Pitch;
   end Set_Vis_Pitch;

-- Access Vis_Roll
   function  Vis_Roll
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Vis_Roll;
   end Vis_Roll;

   procedure Set_Vis_Roll
     (An_Instance : in out Instance;
      A_Roll : in Float) is
   begin
      An_Instance.Vis_Roll := A_Roll;
   end Set_Vis_Roll;

-- Access Vis_Heading
   function  Vis_Heading
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Vis_Heading;
   end Vis_Heading;

   procedure Set_Vis_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      An_Instance.Vis_Heading := A_Heading;
   end Set_Vis_Heading;

-- Access Vis_Position
   function  Vis_Position
     (An_Instance : in Instance)
      return Lat_Long_Types.Position is
   begin
      return An_Instance.Vis_Position;
   end Vis_Position;

   procedure Set_Vis_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position) is
   begin
      An_Instance.Vis_Position := A_Position;
   end Set_Vis_Position;

-- Method Compute_Ambient_Light
   procedure Compute_Ambient_Light
     (An_Instance : in out Instance;
      A_Time_Of_Day : in Integer) is
   begin
      null;
   end Compute_Ambient_Light;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 12;
      An_Instance.Data_Block_Code := 16#32000000#;
      An_Instance.Use_Data := True;

      An_Instance.X_Eyepoint := 0.0;
      An_Instance.Y_Eyepoint := 0.0;
      An_Instance.Z_Eyepoint := 0.0;
      An_Instance.Ieee_754_Cg := False;
      An_Instance.Wipers := False;
      An_Instance.Wing_Strobe_Light := false;
      An_Instance.Anti_Coll_Beacon_1 := false;
      An_Instance.Anti_Coll_Beacon_2 := false;
      An_Instance.Anti_Coll_Beacon_3 := false;
      An_Instance.Anti_Coll_Beacon_4 := false;
      An_Instance.Anti_Coll_Beacon_5 := false;
      An_Instance.Anti_Coll_Beacon_6 := false;
      An_Instance.Anti_Coll_Beacon_7 := false;
      An_Instance.Weight_On_Wheels := True;
      An_Instance.Ambient_Lighting := True;
      An_Instance.Device_Disable_Mask_0 := False;
      An_Instance.Device_Disable_Mask_1 := False;
      An_Instance.Device_Disable_Mask_2 := False;
      An_Instance.Device_Disable_Mask_3 := False;
      An_Instance.Device_Disable_Mask_4 := False;
      An_Instance.Device_Disable_Mask_5 := False;
      An_Instance.Device_Disable_Mask_6 := False;
      An_Instance.Device_Disable_Mask_7 := False;
      An_Instance.Device_Disable_Mask_8 := False;
      An_Instance.Device_Disable_Mask_9 := False;
      An_Instance.Device_Disable_Mask_10 := False;
      An_Instance.Device_Disable_Mask_11 := False;
      An_Instance.Device_Disable_Mask_12 := False;
      An_Instance.Device_Disable_Mask_13 := False;
      An_Instance.Device_Disable_Mask_14 := False;
      An_Instance.Device_Disable_Mask_15 := False;
      An_Instance.Vis_Pitch := 0.0;
      An_Instance.Vis_Roll := 0.0;
      An_Instance.Vis_Heading := 0.0;
      An_Instance.Vis_Position.Latitude := 45.00;
      An_Instance.Vis_Position.Longitude := 45.00;
      An_Instance.Vis_Position.Altitude := 0.0;

      for I in 1..12 loop
         An_Instance.The_High_Precision_Ownship_Block(I) := 0;
      end loop;

   end Initialize;

-- Method Compute_Eyepoint
   procedure Compute_Eyepoint
     (An_Instance : in out Instance;
      X_Cg : in Float;
      Z_Cg : in Float) is
   begin
      An_Instance.X_Eyepoint := X_Cg - Eyepoint_Station;
      An_Instance.Y_Eyepoint := 0.0;
      An_Instance.Z_Eyepoint := Z_Cg - Eyepoint_Waterline;
   end Compute_Eyepoint;

   procedure Pack
     (An_Instance : in out Instance) is
      Temp : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Word_1_Lat_Lon : Jpats_Visual_Buffer_Types.Unsigned_Int := 0;
      Word_2_Lat_Lon : Jpats_Visual_Buffer_Types.Unsigned_Int := 0;
      Temp_Lat : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Temp_Lon : Jpats_Visual_Buffer_Types.Unsigned_Int;
      Temp_Roll : Float;
      Temp_Pitch : Float;
      Temp_Heading : Float;
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_High_Precision_Ownship_Block(I) := 0;
      end loop;

      An_Instance.The_High_Precision_Ownship_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      if (An_Instance.Ieee_754_Cg) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00800000#;
      end if;

      if (An_Instance.Wipers) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00008000#;
      end if;
      if (An_Instance.Wing_Strobe_Light) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00004000#;
      end if;
      if (An_Instance.Anti_Coll_Beacon_1) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00002000#;
      end if;
      if (An_Instance.Weight_On_Wheels) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00001000#;
      end if;
      if (An_Instance.Ambient_Lighting) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00000800#;
      end if;
      if (An_Instance.Anti_Coll_Beacon_2) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00000200#;
      end if;
      if (An_Instance.Anti_Coll_Beacon_3) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00000100#;
      end if;
      if (An_Instance.Anti_Coll_Beacon_4) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00000080#;
      end if;
      if (An_Instance.Anti_Coll_Beacon_5) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00000040#;
      end if;
      if (An_Instance.Anti_Coll_Beacon_6) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00000020#;
      end if;
      if (An_Instance.Anti_Coll_Beacon_7) then
         An_Instance.The_High_Precision_Ownship_Block(1) :=
           An_Instance.The_High_Precision_Ownship_Block(1) + 16#00000010#;
      end if;

-- Pack Word 2
      if (An_Instance.Device_Disable_Mask_15) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00008000#;
      end if;
      if (An_Instance.Device_Disable_Mask_14) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00004000#;
      end if;
      if (An_Instance.Device_Disable_Mask_13) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00002000#;
      end if;
      if (An_Instance.Device_Disable_Mask_12) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00001000#;
      end if;
      if (An_Instance.Device_Disable_Mask_11) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000800#;
      end if;
      if (An_Instance.Device_Disable_Mask_10) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000400#;
      end if;
      if (An_Instance.Device_Disable_Mask_9) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000200#;
      end if;
      if (An_Instance.Device_Disable_Mask_8) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000100#;
      end if;
      if (An_Instance.Device_Disable_Mask_7) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000080#;
      end if;
      if (An_Instance.Device_Disable_Mask_6) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000040#;
      end if;
      if (An_Instance.Device_Disable_Mask_5) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000020#;
      end if;
      if (An_Instance.Device_Disable_Mask_4) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000010#;
      end if;
      if (An_Instance.Device_Disable_Mask_3) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000008#;
      end if;
      if (An_Instance.Device_Disable_Mask_2) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000004#;
      end if;
      if (An_Instance.Device_Disable_Mask_1) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000002#;
      end if;
      if (An_Instance.Device_Disable_Mask_0) then
         An_Instance.The_High_Precision_Ownship_Block(2) :=
           An_Instance.The_High_Precision_Ownship_Block(2) + 16#00000001#;
      end if;

-- Pack Word 3
      An_Instance.The_High_Precision_Ownship_Block(3) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(An_Instance.X_Eyepoint * Jpats_Visual_Buffer_Types.Sb16_Scale)));

-- Pack Word 4
      An_Instance.The_High_Precision_Ownship_Block(4) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(An_Instance.Y_Eyepoint * Jpats_Visual_Buffer_Types.Sb16_Scale)));

-- Pack Word 5
      An_Instance.The_High_Precision_Ownship_Block(5) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(An_Instance.Z_Eyepoint * Jpats_Visual_Buffer_Types.Sb16_Scale)));

-- Pack Word 6
      --To get around a constraint error that happens when you try to convert
      --360 degrees (+/- 180) to a 0.5 to -0.5 scale in a full 32 bits in one
      --operation, the roll is divided by 180 and shifted up 23 places before
      --being converted to an integer, then shifted up 8 more places as an int.
      --Not pretty, but (hopefully) it works.
      Temp_Roll := An_Instance.Vis_Roll / 180.0;
      An_Instance.The_High_Precision_Ownship_Block(6) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(Temp_Roll * Jpats_Visual_Buffer_Types.Sb1_24bit_Scale))*256
         and 16#ffffffff#);

-- Pack Word 7
      --To get around a constraint error that happens when you try to convert
      --360 degrees (+/- 180) to a 0.5 to -0.5 scale in a full 32 bits in one
      --operation, the pitch is divided by 180 and shifted up 23 places before
      --being converted to an integer, then shifted up 8 more places as an int.
      --Not pretty, but (hopefully) it works.
      Temp_Pitch := An_Instance.Vis_Pitch / 180.0;
      An_Instance.The_High_Precision_Ownship_Block(7) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(Temp_Pitch * Jpats_Visual_Buffer_Types.Sb1_24bit_Scale))*256
         and 16#Ffffffff#);

-- Pack Word 8
      --To get around a constraint error that happens when you try to convert
      --360 degrees (+/- 180) to a 0.5 to -0.5 scale in a full 32 bits in one
      --operation, the hdg is divided by 180 and shifted up 23 places before
      --being converted to an integer, then shifted up 8 more places as an int.
      --Not pretty, but (hopefully) it works.
      Temp_Heading := An_Instance.Vis_Heading / 180.0;
      An_Instance.The_High_Precision_Ownship_Block(8) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(Temp_Heading * Jpats_Visual_Buffer_Types.Sb1_24bit_Scale))*256
         and 16#Ffffffff#);

-- Pack Words 9, 10, and 11
      Lat_Lon_Convert(An_Instance.Vis_Position.Latitude,
                      Word_1_Lat_Lon, Word_2_Lat_Lon);
      An_Instance.The_High_Precision_Ownship_Block(9) := Word_1_Lat_Lon;
      Temp_Lat := Word_2_Lat_Lon and 16#Ffff0000#;

      Lat_Lon_Convert(An_Instance.Vis_Position.Longitude,
                      Word_1_Lat_Lon, Word_2_Lat_Lon);
      An_Instance.The_High_Precision_Ownship_Block(11) := Word_1_Lat_Lon;
      Temp_Lon := ((Word_2_Lat_Lon and 16#Ffff0000#) / 16#00010000#)
        and 16#0000ffff#;

      An_Instance.The_High_Precision_Ownship_Block(10) := Temp_Lat + Temp_Lon;

-- Pack Word 12
      An_Instance.The_High_Precision_Ownship_Block(12) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Vis_Position.Altitude *
         Jpats_Visual_Buffer_Types.Sb23_Scale));

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_High_Precision_Ownship_Block;
   end Data_Word;



end Data_Block.High_Precision_Ownship_Send;
