-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Expanded_Model is


   type Instance is new Data_Block.Instance with private;

-- Access Model_Hot_Request
   function Model_Hot_Request (An_Instance : in Instance) return Boolean;
   procedure Set_Model_Hot_Request
     (An_Instance : in out Instance;
      A_Request : in Boolean);

-- Access Model_Has_Parent
   function Model_Has_Parent (An_Instance : in Instance) return Boolean;
   procedure Set_Model_Has_Parent
     (An_Instance : in out Instance;
      Has_Parent : in Boolean);

-- Access Model_Ownship
   function Model_Ownship (An_Instance : in Instance) return Boolean;
   procedure Set_Model_Ownship
     (An_Instance : in out Instance;
      Is_Ownship : in Boolean);

-- Access Terrain_Following
   function Terrain_Following (An_Instance : in Instance) return Boolean;
   procedure Set_Terrain_Following
     (An_Instance : in out Instance;
      Is_Following : in Boolean);

-- Access Expanded_HOT
   function Expanded_Hot (An_Instance : in Instance) return Boolean;
   procedure Set_Expanded_Hot
     (An_Instance : in out Instance;
      Hot_Request : in Boolean);

-- Access Appended_Word_Count
   function Appended_Word_Count (An_Instance : in Instance) return Integer;
   procedure Set_Appended_Word_Count
     (An_Instance : in out Instance;
      A_Count : in Integer);

-- Access Model_Designation
   function Model_Designation (An_Instance : in Instance) return Integer;
   procedure Set_Model_Designation
     (An_Instance : in out Instance;
      A_Designation : in Integer);

-- Access Parent_Id
   function Parent_Id (An_Instance : in Instance) return Integer;
   procedure Set_Parent_Id
     (An_Instance : in out Instance;
      A_Parent : in Integer);

-- Access Model_Instance_Id
   function Model_Instance_Id (An_Instance : in Instance) return Integer;
   procedure Set_Model_Instance_Id
     (An_Instance : in out Instance;
      An_Id : in Integer);

-- Access Model_Lat_X
   function Model_Lat_X (An_Instance : in Instance) return Long_Float;
   procedure Set_Model_Lat_X
     (An_Instance : in out Instance;
      A_Lat_X : in Long_Float);

-- Access Model_Lon_Y
   function Model_Lon_Y (An_Instance : in Instance) return Long_Float;
   procedure Set_Model_Lon_Y
     (An_Instance : in out Instance;
      A_Lon_Y : in Long_Float);

-- Access Model_Alt_Z
   function Model_Alt_Z (An_Instance : in Instance) return Float;
   procedure Set_Model_Alt_Z
     (An_Instance : in out Instance;
      An_Alt_Z : in Float);

-- Access Model_Heading
   function  Model_Heading (An_Instance : in Instance) return Float;
   procedure Set_Model_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float);

-- Access Model_Pitch
   function  Model_Pitch (An_Instance : in Instance) return Float;
   procedure Set_Model_Pitch
     (An_Instance : in out Instance;
      A_Pitch : in Float);

-- Access Model_Roll
   function  Model_Roll (An_Instance : in Instance) return Float;
   procedure Set_Model_Roll
     (An_Instance : in out Instance;
      A_Roll : in Float);

-- Data_Block Methods
   procedure Initialize
     (An_Instance : in out Instance);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

   type Instance is new Data_Block.Instance with record
      Model_Hot_Request : Boolean;
      Model_Has_Parent : Boolean;
      Model_Ownship : Boolean;
      Terrain_Following : Boolean;
      Expanded_Hot : Boolean;
      Appended_Word_Count : Integer;
      Model_Designation : Integer;
      Parent_Id : Integer;
      Model_Instance_Id : Integer;
      Model_Lat_X : Long_Float;
      Model_Lon_Y : Long_Float;
      Model_Alt_Z : Float;
      Model_Heading : Float;
      Model_Pitch : Float;
      Model_Roll : Float;
      The_Expanded_Block : Jpats_Visual_Buffer_Types.Block_Array (1..7);
   end record;


end Data_Block.Expanded_Model;
