-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Expanded_Model is


-- Access Model_Hot_Request
   function Model_Hot_Request
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Model_Hot_Request;
   end Model_Hot_Request;

   procedure Set_Model_Hot_Request
     (An_Instance : in out Instance;
      A_Request : in Boolean) is
   begin
      An_Instance.Model_Hot_Request := A_Request;
   end Set_Model_Hot_Request;

-- Access Model_Has_Parent
   function Model_Has_Parent
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Model_Has_Parent;
   end Model_Has_Parent;

   procedure Set_Model_Has_Parent
     (An_Instance : in out Instance;
      Has_Parent : in Boolean) is
   begin
      An_Instance.Model_Has_Parent := Has_Parent;
   end Set_Model_Has_Parent;

-- Access Model_Ownship
   function Model_Ownship
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Model_Ownship;
   end Model_Ownship;

   procedure Set_Model_Ownship
     (An_Instance : in out Instance;
      Is_Ownship : in Boolean) is
   begin
      An_Instance.Model_Ownship := Is_Ownship;
   end Set_Model_Ownship;

-- Access Terrain_Following
   function Terrain_Following
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Terrain_Following;
   end Terrain_Following;

   procedure Set_Terrain_Following
     (An_Instance : in out Instance;
      Is_Following : in Boolean) is
   begin
      An_Instance.Terrain_Following := Is_Following;
   end Set_Terrain_Following;

-- Access Expanded_HOT
   function Expanded_Hot
     (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.Expanded_Hot;
   end Expanded_Hot;

   procedure Set_Expanded_Hot
     (An_Instance : in out Instance;
      Hot_Request : in Boolean) is
   begin
      An_Instance.Expanded_Hot := Hot_Request;
   end Set_Expanded_Hot;

-- Access Appended_Word_Count
   function Appended_Word_Count
     (An_Instance : in Instance)
     return Integer is
   begin
      return An_Instance.Appended_Word_Count;
   end Appended_Word_Count;

   procedure Set_Appended_Word_Count
     (An_Instance : in out Instance;
      A_Count : in Integer) is
   begin
      An_Instance.Appended_Word_Count := A_Count;
   end Set_Appended_Word_Count;

-- Access Model_Designation
   function Model_Designation
     (An_Instance : in Instance)
     return Integer is
   begin
      return An_Instance.Model_Designation;
   end Model_Designation;

   procedure Set_Model_Designation
     (An_Instance : in out Instance;
      A_Designation : in Integer) is
   begin
      An_Instance.Model_Designation := A_Designation;
   end Set_Model_Designation;

-- Access Parent_Id
   function Parent_Id
     (An_Instance : in Instance)
     return Integer is
   begin
      return An_Instance.Parent_Id;
   end Parent_Id;

   procedure Set_Parent_Id
     (An_Instance : in out Instance;
      A_Parent : in Integer) is
   begin
      An_Instance.Parent_Id := A_Parent;
   end Set_Parent_Id;

-- Access Model_Instance_Id
   function Model_Instance_Id
     (An_Instance : in Instance)
     return Integer is
   begin
      return An_Instance.Model_Instance_Id;
   end Model_Instance_Id;

   procedure Set_Model_Instance_Id
     (An_Instance : in out Instance;
      An_Id : in Integer) is
   begin
      An_Instance.Model_Instance_Id := An_Id;
   end Set_Model_Instance_Id;

-- Access Model_Lat_X
   function Model_Lat_X
     (An_Instance : in Instance)
     return Long_Float is
   begin
      return An_Instance.Model_Lat_X;
   end Model_Lat_X;

   procedure Set_Model_Lat_X
     (An_Instance : in out Instance;
      A_Lat_X : in Long_Float) is
   begin
      An_Instance.Model_Lat_X := A_Lat_X;
   end Set_Model_Lat_X;

-- Access Model_Lon_Y
   function Model_Lon_Y
     (An_Instance : in Instance)
     return Long_Float is
   begin
      return An_Instance.Model_Lon_Y;
   end Model_Lon_Y;

   procedure Set_Model_Lon_Y
     (An_Instance : in out Instance;
      A_Lon_Y : in Long_Float) is
   begin
      An_Instance.Model_Lon_Y := A_Lon_Y;
   end Set_Model_Lon_Y;

-- Access Model_Alt_Z
   function Model_Alt_Z
     (An_Instance : in Instance)
     return Float is
   begin
      return An_Instance.Model_Alt_Z;
   end Model_Alt_Z;

   procedure Set_Model_Alt_Z
     (An_Instance : in out Instance;
      An_Alt_Z : in Float) is
   begin
      An_Instance.Model_Alt_Z := An_Alt_Z;
   end Set_Model_Alt_Z;

-- Access Model_Heading
   function  Model_Heading
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Model_Heading;
   end Model_Heading;

   procedure Set_Model_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      An_Instance.Model_Heading := A_Heading;
   end Set_Model_Heading;

-- Access Model_Pitch
   function  Model_Pitch
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Model_Pitch;
   end Model_Pitch;

   procedure Set_Model_Pitch
     (An_Instance : in out Instance;
      A_Pitch : in Float) is
   begin
      An_Instance.Model_Pitch := A_Pitch;
   end Set_Model_Pitch;

-- Access Model_Roll
   function  Model_Roll
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Model_Roll;
   end Model_Roll;

   procedure Set_Model_Roll
     (An_Instance : in out Instance;
      A_Roll : in Float) is
   begin
      An_Instance.Model_Roll := A_Roll;
   end Set_Model_Roll;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 7;
      An_Instance.Data_Block_Code := 16#17000000#;
      An_Instance.Use_Data := False;

      An_Instance.Model_Instance_Id := 0;
      An_Instance.Model_Hot_Request := False;
      An_Instance.Expanded_Hot := False;
      An_Instance.Model_Ownship := False;
      An_Instance.Model_Has_Parent := False;
      An_Instance.Terrain_Following := False;
      An_Instance.Parent_Id := 0;
      An_Instance.Model_Designation := 0;
      An_Instance.Model_Lat_X := 0.0;
      An_Instance.Model_Lon_Y := 0.0;
      An_Instance.Model_Alt_Z := 0.0;
      An_Instance.Model_Heading := 0.0;
      An_Instance.Model_Pitch := 0.0;
      An_Instance.Model_Roll := 0.0;

      for I in 1..7 loop
         An_Instance.The_Expanded_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_Expanded_Block(I) := 0;
      end loop;

      An_Instance.The_Expanded_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      if An_Instance.Model_Hot_Request then
         An_Instance.The_Expanded_Block(1) :=
           An_Instance.The_Expanded_Block(1) + 16#00008000#;
      end if;
      if An_Instance.Model_Has_Parent then
         An_Instance.The_Expanded_Block(1) :=
           An_Instance.The_Expanded_Block(1) + 16#00002000#;
      end if;
      if An_Instance.Model_Ownship then
         An_Instance.The_Expanded_Block(1) :=
           An_Instance.The_Expanded_Block(1) + 16#00001000#;
      end if;
      if An_Instance.Terrain_Following then
         An_Instance.The_Expanded_Block(1) :=
           An_Instance.The_Expanded_Block(1) + 16#00000800#;
      end if;
      if An_Instance.Expanded_Hot then
         An_Instance.The_Expanded_Block(1) :=
           An_Instance.The_Expanded_Block(1) + 16#00000400#;
      end if;
      An_Instance.The_Expanded_Block(1) :=
        An_Instance.The_Expanded_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Appended_Word_Count);

      An_Instance.The_Expanded_Block(2) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (An_Instance.Model_Designation) * 16#00010000#) and 16#ffff0000#;
      An_Instance.The_Expanded_Block(2) :=
         An_Instance.The_Expanded_Block(2) +
         Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Parent_Id);

      An_Instance.The_Expanded_Block(3) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (An_Instance.Model_Instance_id) * 16#00010000#) and 16#ffff0000#;
      An_Instance.The_Expanded_Block(3) :=
        An_Instance.The_Expanded_Block(3) +
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(An_Instance.Model_Heading *
                  Jpats_Visual_Buffer_Types.Sb1_Scale))
         and 16#0000ffff#);

      if An_Instance.Model_Has_Parent then
        An_Instance.The_Expanded_Block(4) :=
          Jpats_Visual_Buffer_Types.Unsigned_Int
          (Integer(An_Instance.Model_Lat_X *
                 Jpats_Visual_Buffer_Types.Sb23_Scale));
        An_Instance.The_Expanded_Block(5) :=
          Jpats_Visual_Buffer_Types.Unsigned_Int
          (Integer(An_Instance.Model_Lon_Y *
                   Jpats_Visual_Buffer_Types.Sb23_Scale));
      else
        An_Instance.The_Expanded_Block(4) :=
          Jpats_Visual_Buffer_Types.Unsigned_Int
          (Integer(An_Instance.Model_Lat_X *
                 Jpats_Visual_Buffer_Types.Bams_32bit));
        An_Instance.The_Expanded_Block(5) :=
          Jpats_Visual_Buffer_Types.Unsigned_Int
          (Integer(An_Instance.Model_Lon_Y *
                   Jpats_Visual_Buffer_Types.Bams_32bit));
      end if;
      An_Instance.The_Expanded_Block(6) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Model_Alt_Z *
                 Jpats_Visual_Buffer_Types.Sb23_Scale));

      An_Instance.The_Expanded_Block(7) :=
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(An_Instance.Model_Roll *
                  Jpats_Visual_Buffer_Types.Sb1_Scale))
         * 16#00010000#) and 16#ffff0000#;
      An_Instance.The_Expanded_Block(7) :=
        An_Instance.The_Expanded_Block(7) +
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(An_Instance.Model_Pitch *
                  Jpats_Visual_Buffer_Types.Sb1_Scale))
         and 16#0000ffff#);
   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Expanded_Block;
   end Data_Word;


end Data_Block.Expanded_Model;
