-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
with Lat_Long_Types;

package Data_Block.DOF_Models is


  type Instance is new Data_Block.Instance with private;

-- Access HOT_Return_Request
   function  HOT_Return_Request (An_Instance : in Instance) return Boolean;
   procedure Set_HOT_Return_Request
     (An_Instance : in out Instance;
      A_Request : in Boolean);

-- Access Model_Instance_ID
   function  Model_Instance_ID (An_Instance : in Instance) return Integer;
   procedure Set_Model_Instance_ID
     (An_Instance : in out Instance;
      An_Id : in Integer);

-- Access Model_Designation
   function  Model_Designation (An_Instance : in Instance) return Integer;
   procedure Set_Model_Designation
     (An_Instance : in out Instance;
      A_Designation : in Integer);

-- Access Model_Latitude
   function  Model_Position (An_Instance : in Instance)
     return Lat_Long_Types.Position;
   procedure Set_Model_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position);

-- Access Discrete_Switches
   function  Discrete_Switches
     (An_Instance : in Instance;
      An_Index : Integer) return Boolean;
   procedure Set_Discrete_Switches
     (An_Instance : in out Instance;
      An_Index : Integer;
      Switches_On : in Boolean);


private

   type Switch_Array is array (1..8) of Boolean;

   type Instance is new Data_Block.Instance with record
      HOT_Return_Request : Boolean;
      Model_Instance_ID : Integer;
      Model_Designation : Integer;
      Model_Position : Lat_Long_Types.Position;
      Discrete_Switches : Switch_Array;
   end record;


end Data_Block.DOF_Models;
