-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.DOF_Models is


-- Access HOT_Return_Request
   function  HOT_Return_Request
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.HOT_Return_Request;
   end HOT_Return_Request;

   procedure Set_HOT_Return_Request
     (An_Instance : in out Instance;
      A_Request : in Boolean) is
   begin
      An_Instance.Hot_Return_Request := A_Request;
   end Set_HOT_Return_Request;

-- Access Model_Instance_ID
   function  Model_Instance_ID
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Model_Instance_ID;
   end Model_Instance_ID;

   procedure Set_Model_Instance_ID
     (An_Instance : in out Instance;
      An_Id : in Integer) is
   begin
      An_Instance.Model_Instance_Id := An_Id;
   end Set_Model_Instance_ID;

-- Access Model_Designation
   function  Model_Designation
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Model_Designation;
   end Model_Designation;

   procedure Set_Model_Designation
     (An_Instance : in out Instance;
      A_Designation : in Integer) is
   begin
      An_Instance.Model_Designation := A_Designation;
   end Set_Model_Designation;

-- Access Model_Positioin
   function  Model_Position
     (An_Instance : in Instance)
      return Lat_Long_Types.Position is
   begin
      return An_Instance.Model_Position;
   end Model_Position;

   procedure Set_Model_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position) is
   begin
      An_Instance.Model_Position := A_Position;
   end Set_Model_Position;

-- Access Discrete_Switches
   function  Discrete_Switches
     (An_Instance : in Instance;
      An_Index : Integer)
      return Boolean is
   begin
      return An_Instance.Discrete_Switches(An_Index);
   end Discrete_Switches;

   procedure Set_Discrete_Switches
     (An_Instance : in out Instance;
      An_Index : Integer;
      Switches_On : in Boolean) is
   begin
      An_Instance.Discrete_Switches(An_Index) := Switches_On;
   end Set_Discrete_Switches;


end Data_Block.DOF_Models;
