-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Dof_Models.Three_DOF_Model is

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 5;
      An_Instance.Data_Block_Code := 16#06000000#;
      An_Instance.Use_Data := False;

      An_Instance.Model_Instance_Id := 3;
      An_Instance.Hot_Return_Request := False;
      An_Instance.Model_Designation := 0;
      An_Instance.Model_Position.Latitude := 0.0;
      An_Instance.Model_Position.Longitude := 0.0;
      An_Instance.Model_Position.Altitude := 0.0;
      for I in 1..8 loop
         An_Instance.Discrete_Switches(I) := False;
      end loop;

      for I in 1..5 loop
         An_Instance.The_Three_Dof_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_Three_Dof_Block(I) := 0;
      end loop;

      An_Instance.The_Three_Dof_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      for I in 1..8 loop
         if (An_Instance.Discrete_Switches(I)) then
            An_Instance.The_Three_Dof_Block(1) :=
              An_Instance.The_Three_Dof_Block(1) +
              Jpats_Visual_Buffer_Types.Unsigned_Int(2**(24-I));
         end if;
      end loop;

      if (An_Instance.Hot_Return_Request) then
         An_Instance.The_Three_Dof_Block(1) :=
           An_Instance.The_Three_Dof_Block(1) + 16#00008000#;
      end if;
      An_Instance.The_Three_Dof_Block(1) :=
        An_Instance.The_Three_Dof_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Model_Instance_Id);

      An_Instance.The_Three_Dof_Block(2) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Model_Designation) * 16#00010000#;

      An_Instance.The_Three_Dof_Block(3) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Model_Position.Latitude *
         Jpats_Visual_Buffer_Types.Bams_32bit));

      An_Instance.The_Three_Dof_Block(4) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Model_Position.Longitude *
         Jpats_Visual_Buffer_Types.Bams_32bit));

      An_Instance.The_Three_Dof_Block(5) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Model_Position.Altitude * 256.0));

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Three_Dof_Block;
   end Data_Word;


end Data_Block.Dof_Models.Three_DOF_Model;
