-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
with Data_Block.Dof_Models;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Dof_Models.Four_DOF_Model is


  type Instance is new Data_Block.Dof_Models.Instance with private;

-- Access Lightning_Enable
  function  Lightning_Enable (An_Instance : in Instance) return Integer;
   procedure Set_Lightning_Enable
     (An_Instance : in out Instance;
      A_Lightning_Enable :in Integer);

-- Access Model_Heading
   function  Model_Heading (An_Instance : in Instance) return Float;
   procedure Set_Model_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float);

-- Data_Block Methods
   procedure Initialize
     (An_Instance : in out Instance;
      An_Element : Integer);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;

private

  type Instance is new Data_Block.Dof_Models.Instance with record
    Lightning_Enable : Integer;
    Model_Heading : Float;
    The_Four_Dof_Block : Jpats_Visual_Buffer_Types.Block_Array (1..5);
  end record;


end Data_Block.Dof_Models.Four_DOF_Model;
