-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Dof_Models.Four_DOF_Model is


-- Access Lightning_Enable
   function  Lightning_Enable
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Lightning_Enable;
   end Lightning_Enable;

   procedure Set_Lightning_Enable
     (An_Instance : in out Instance;
      A_Lightning_Enable : in Integer) is
   begin
      An_Instance.Lightning_Enable := A_Lightning_Enable;
   end Set_Lightning_Enable;

-- Access Model_Heading
   function  Model_Heading
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Model_Heading;
   end Model_Heading;

   procedure Set_Model_Heading
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      An_Instance.Model_Heading := A_Heading;
   end Set_Model_Heading;

   procedure Initialize
     (An_Instance : in out Instance;
      An_Element : Integer) is
   begin
      An_Instance.Word_Count := 5;
      An_Instance.Data_Block_Code := 16#07000000#;
      An_Instance.Use_Data := False;

      An_Instance.Model_Instance_Id := An_Element + 3;
      An_Instance.Hot_Return_Request := False;
      An_Instance.Model_Designation := 0;
      An_Instance.Model_Position.Latitude := 0.0;
      An_Instance.Model_Position.Longitude := 0.0;
      An_Instance.Model_Position.Altitude := 0.0;
      An_Instance.Model_Heading := 0.0;
      An_Instance.Lightning_Enable := 0;
      for I in 1..8 loop
         An_Instance.Discrete_Switches(I) := False;
      end loop;

      for I in 1..5 loop
         An_Instance.The_Four_Dof_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_Four_Dof_Block(I) := 0;
      end loop;

      An_Instance.The_Four_Dof_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      for I in 1..8 loop
         if (An_Instance.Discrete_Switches(I)) then
            An_Instance.The_Four_Dof_Block(1) :=
              An_Instance.The_Four_Dof_Block(1) +
              Jpats_Visual_Buffer_Types.Unsigned_Int(2**(24-I));
         end if;
      end loop;

      if (An_Instance.Hot_Return_Request) then
         An_Instance.The_Four_Dof_Block(1) :=
           An_Instance.The_Four_Dof_Block(1) + 16#00008000#;
      end if;
      An_Instance.The_Four_Dof_Block(1) :=
        An_Instance.The_Four_Dof_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Lightning_Enable) * 16#00000020#;
      An_Instance.The_Four_Dof_Block(1) :=
        An_Instance.The_Four_Dof_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Model_Instance_Id);

      An_Instance.The_Four_Dof_Block(2) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Model_Designation) * 16#00010000#;
      An_Instance.The_Four_Dof_Block(2) :=
        An_Instance.The_Four_Dof_Block(2) +
        (Jpats_Visual_Buffer_Types.Unsigned_Int
         (Integer(An_Instance.Model_Heading *
                  Jpats_Visual_Buffer_Types.Bams_16bit))
         and 16#0000ffff#);

      An_Instance.The_Four_Dof_Block(3) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Model_Position.Latitude *
                 Jpats_Visual_Buffer_Types.Bams_32bit));

      An_Instance.The_Four_Dof_Block(4) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Model_Position.Longitude *
                 Jpats_Visual_Buffer_Types.Bams_32bit));

      An_Instance.The_Four_Dof_Block(5) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Model_Position.Altitude * 256.0));

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Four_Dof_Block;
   end Data_Word;


end Data_Block.Dof_Models.Four_DOF_Model;
