-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;
with Lat_Long_Types;

package Data_Block.Config_Apt_Cntl is


  type Instance is new Data_Block.Instance with private;

-- Access Leading_Zero_Runway_Number
  function  Leading_Zero_Runway_Number
    (An_Instance : in Instance) return Boolean;
   procedure Set_Leading_Zero_Runway_Number
     (An_Instance : in out Instance;
      A_Leading_Zero : in Boolean);

-- Access Building_Location
   function  Building_Location (An_Instance : in Instance) return Boolean;
   procedure Set_Building_Location
     (An_Instance : in out Instance;
      A_Location : in Boolean);

-- Access REIL_Lighting
   function  REIL_Lighting (An_Instance : in Instance) return Boolean;
   procedure Set_REIL_Lighting
     (An_Instance : in out Instance;
      A_Lighting : in Boolean);

-- Access Civil_Rotating_Beacon
   function  Civil_Rotating_Beacon (An_Instance : in Instance) return Boolean;
   procedure Set_Civil_Rotating_Beacon
     (An_Instance : in out Instance;
      Beacon_On : in Boolean);

-- Access Terrain_Type
   function  Terrain_Type (An_Instance : in Instance) return Integer;
   procedure Set_Terrain_Type
     (An_Instance : in out Instance;
      A_Terrain : in Integer);

-- Access Runway_Width
   function  Runway_Width (An_Instance : in Instance) return Integer;
   procedure Set_Runway_Width
     (An_Instance : in out Instance;
      A_Width : in Integer);

-- Access Runway_Length
   function  Runway_Length (An_Instance : in Instance) return Integer;
   procedure Set_Runway_Length
     (An_Instance : in out Instance;
      A_Length : in Integer);

-- Access Approach_Path_Indicator
   function  Approach_Path_Indicator
     (An_Instance : in Instance) return Integer;
   procedure Set_Approach_Path_Indicator
     (An_Instance : in out Instance;
      An_Indicator : in Integer);

-- Access Approach_Light_System
   function  Approach_Light_System (An_Instance : in Instance) return Integer;
   procedure Set_Approach_Light_System
     (An_Instance : in out Instance;
      A_System : in Integer);

-- Access Runway_Markings
   function  Runway_Markings (An_Instance : in Instance) return Integer;
   procedure Set_Runway_Markings
     (An_Instance : in out Instance;
      A_Marking : in Integer);

-- Access Cultrual_Lights
   function  Cultural_Lights (An_Instance : in Instance) return Integer;
   procedure Set_Cultural_Lights
     (An_Instance : in out Instance;
      A_Lighting : in Integer);

-- Access Primary_Runway_Position
   function  Primary_Runway_Position (An_Instance : in Instance)
                                      return Lat_Long_Types.Position;
   procedure Set_Primary_Runway_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position);

-- Access Default_X_Offset
   function  Default_X_Offset (An_Instance : in Instance) return Float;
   procedure Set_Default_X_Offset
     (An_Instance : in out Instance;
      An_Offset : in Float);

-- Access Default_Y_Offset
   function  Default_Y_Offset (An_Instance : in Instance) return Float;
   procedure Set_Default_Y_Offset
     (An_Instance : in out Instance;
      An_Offset : in Float);

-- Access Default_Runway_True_Hdg
   function  Default_Runway_True_Hdg (An_Instance : in Instance) return Float;
   procedure Set_Default_Runway_True_Hdg
     (An_Instance : in out Instance;
      A_Heading : in Float);

-- Access Default_Runway_GS_Angle
   function  Default_Runway_GS_Angle (An_Instance : in Instance) return Float;
   procedure Set_Default_Runway_GS_Angle
     (An_Instance : in out Instance;
      An_Angle : in Float);

-- Access Default_Runway_Mag_Hdg
   function  Default_Runway_Mag_Hdg (An_Instance : in Instance) return Float;
   procedure Set_Default_Runway_Mag_Hdg
     (An_Instance : in out Instance;
      A_Heading : in Float);

-- Data_Block Methods
   procedure Initialize (An_Instance : in out Instance);
   procedure Pack (An_Instance : in out Instance);

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array;


private

  type Instance is new Data_Block.Instance with record
    Leading_Zero_Runway_Number : Boolean;
    Building_Location : Boolean;
    REIL_Lighting : Boolean;
    Civil_Rotating_Beacon : Boolean;
    Terrain_Type : Integer;
    Runway_Width : Integer;
    Runway_Length : Integer;
    Approach_Path_Indicator : Integer;
    Approach_Light_System : Integer;
    Runway_Markings : Integer;
    Cultural_Lights : Integer;
    Primary_Runway_Position : Lat_Long_Types.Position;
    Default_X_Offset : Float;
    Default_Y_Offset : Float;
    Default_Runway_True_Hdg : Float;
    Default_Runway_GS_Angle : Float;
    Default_Runway_Mag_Hdg : Float;
    The_Config_Apt_Cntl_Block : Jpats_Visual_Buffer_Types.Block_Array (1..7);
  end record;


end Data_Block.Config_Apt_Cntl;
