-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Data_Block.Config_Apt_Cntl is


-- Access Runway_Number
   function  Leading_Zero_Runway_Number
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Leading_Zero_Runway_Number;
   end Leading_Zero_Runway_Number;

   procedure Set_Leading_Zero_Runway_Number
     (An_Instance : in out Instance;
      A_Leading_Zero : in Boolean) is
   begin
      An_Instance.Leading_Zero_Runway_Number := A_Leading_Zero;
   end Set_Leading_Zero_Runway_Number;

-- Access Building_Location
   function  Building_Location
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Building_Location;
   end Building_Location;

   procedure Set_Building_Location
     (An_Instance : in out Instance;
      A_Location : in Boolean) is
   begin
      An_Instance.Building_Location := A_Location;
   end Set_Building_Location;

-- Access REIL_Lighting
   function  REIL_Lighting
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.REIL_Lighting;
   end REIL_Lighting;

   procedure Set_REIL_Lighting
     (An_Instance : in out Instance;
      A_Lighting : in Boolean) is
   begin
      An_Instance.Reil_Lighting := A_Lighting;
   end Set_REIL_Lighting;

-- Access Civil_Rotating_Beacon
   function  Civil_Rotating_Beacon
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Civil_Rotating_Beacon;
   end Civil_Rotating_Beacon;

   procedure Set_Civil_Rotating_Beacon
     (An_Instance : in out Instance;
      Beacon_On : in Boolean) is
   begin
      An_Instance.Civil_Rotating_Beacon := Beacon_On;
   end Set_Civil_Rotating_Beacon;

-- Access Terrain_Type
   function  Terrain_Type
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Terrain_Type;
   end Terrain_Type;

   procedure Set_Terrain_Type
     (An_Instance : in out Instance;
      A_Terrain : in Integer) is
   begin
      An_Instance.Terrain_Type := A_Terrain;
   end Set_Terrain_Type;

-- Access Runway_Width
   function  Runway_Width
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Runway_Width;
   end Runway_Width;

   procedure Set_Runway_Width
     (An_Instance : in out Instance;
      A_Width : in Integer) is
   begin
      An_Instance.Runway_Width := A_Width;
   end Set_Runway_Width;

-- Access Runway_Length
   function  Runway_Length
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Runway_Length;
   end Runway_Length;

   procedure Set_Runway_Length
     (An_Instance : in out Instance;
      A_Length : in Integer) is
   begin
      An_Instance.Runway_Length := A_Length;
   end Set_Runway_Length;

-- Access Approach_Path_Indicator
   function  Approach_Path_Indicator
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Approach_Path_Indicator;
   end Approach_Path_Indicator;

   procedure Set_Approach_Path_Indicator
     (An_Instance : in out Instance;
      An_Indicator : in Integer) is
   begin
      An_Instance.Approach_Path_Indicator := An_Indicator;
   end Set_Approach_Path_Indicator;

-- Access Approach_Light_System
   function  Approach_Light_System
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Approach_Light_System;
   end Approach_Light_System;

   procedure Set_Approach_Light_System
     (An_Instance : in out Instance;
      A_System : in Integer) is
   begin
      An_Instance.Approach_Light_System := A_System;
   end Set_Approach_Light_System;

-- Access Runway_Markings
   function  Runway_Markings
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Runway_Markings;
   end Runway_Markings;

   procedure Set_Runway_Markings
     (An_Instance : in out Instance;
      A_Marking : in Integer) is
   begin
      An_Instance.Runway_Markings := A_Marking;
   end Set_Runway_Markings;

-- Access Cultrual_Lights
   function  Cultural_Lights
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Cultural_Lights;
   end Cultural_Lights;

   procedure Set_Cultural_Lights
     (An_Instance : in out Instance;
      A_Lighting : in Integer) is
   begin
      An_Instance.Cultural_Lights := A_Lighting;
   end Set_Cultural_Lights;

-- Access Primary_Runway_Position
   function  Primary_Runway_Position
     (An_Instance : in Instance)
      return Lat_Long_Types.Position is
   begin
      return An_Instance.Primary_Runway_Position;
   end Primary_Runway_Position;

   procedure Set_Primary_Runway_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position) is
   begin
      An_Instance.Primary_Runway_Position := A_Position;
   end Set_Primary_Runway_Position;

-- Access Default_X_Offset
   function  Default_X_Offset
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Default_X_Offset;
   end Default_X_Offset;

   procedure Set_Default_X_Offset
     (An_Instance : in out Instance;
      An_Offset : in Float) is
   begin
      An_Instance.Default_X_Offset := An_Offset;
   end Set_Default_X_Offset;

-- Access Default_Y_Offset
   function  Default_Y_Offset
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Default_Y_Offset;
   end Default_Y_Offset;

   procedure Set_Default_Y_Offset
     (An_Instance : in out Instance;
      An_Offset : in Float) is
   begin
      An_Instance.Default_Y_Offset := An_Offset;
   end Set_Default_Y_Offset;

-- Access Default_Runway_True_Hdg
   function  Default_Runway_True_Hdg
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Default_Runway_True_Hdg;
   end Default_Runway_True_Hdg;

   procedure Set_Default_Runway_True_Hdg
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      An_Instance.Default_Runway_True_Hdg := A_Heading;
   end Set_Default_Runway_True_Hdg;

-- Access Default_Runway_GS_Angle
   function  Default_Runway_GS_Angle
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Default_Runway_GS_Angle;
   end Default_Runway_GS_Angle;

   procedure Set_Default_Runway_GS_Angle
     (An_Instance : in out Instance;
      An_Angle : in Float) is
   begin
      An_Instance.Default_Runway_Gs_Angle := An_Angle;
   end Set_Default_Runway_GS_Angle;

-- Access Default_Runway_Mag_Hdg
   function  Default_Runway_Mag_Hdg
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Default_Runway_Mag_Hdg;
   end Default_Runway_Mag_Hdg;

   procedure Set_Default_Runway_Mag_Hdg
     (An_Instance : in out Instance;
      A_Heading : in Float) is
   begin
      An_Instance.Default_Runway_Mag_Hdg := A_Heading;
   end Set_Default_Runway_Mag_Hdg;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Word_Count := 7;
      An_Instance.Data_Block_Code := 16#0c000000#;
      An_Instance.Use_Data := False;

      An_Instance.Leading_Zero_Runway_Number := True;
      An_Instance.Building_Location := False;
      An_Instance.Reil_Lighting := False;
      An_Instance.Civil_Rotating_Beacon := False;
      An_Instance.Terrain_Type := 0;
      An_Instance.Runway_Width := 1;
      An_Instance.Runway_Length := 15;
      An_Instance.Approach_Path_Indicator := 0;
      An_Instance.Approach_Light_System := 0;
      An_Instance.Runway_Markings := 0;
      An_Instance.Cultural_Lights := 0;
      An_Instance.Primary_Runway_Position.Latitude := 0.0;
      An_Instance.Primary_Runway_Position.Longitude := 0.0;
      An_Instance.Primary_Runway_Position.Altitude := 0.0;
      An_Instance.Default_X_Offset := 0.0;
      An_Instance.Default_Y_Offset := 0.0;
      An_Instance.Default_Runway_True_Hdg := 0.0;
      An_Instance.Default_Runway_Gs_Angle := 3.0;
      An_Instance.Default_Runway_Mag_Hdg := 0.0;

      for I in 1..7 loop
         An_Instance.The_Config_Apt_Cntl_Block(I) := 0;
      end loop;

   end Initialize;

   procedure Pack
     (An_Instance : in out Instance) is
      Temp : Jpats_Visual_Buffer_Types.Unsigned_Int;
   begin
      for I in 1..An_Instance.Word_Count loop
         An_Instance.The_Config_Apt_Cntl_Block(I) := 0;
      end loop;

-- Pack Word 1
      An_Instance.The_Config_Apt_Cntl_Block(1) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Data_Block_Code);
      if (An_Instance.Leading_Zero_Runway_Number) then
         An_Instance.The_Config_Apt_Cntl_Block(1) :=
           An_Instance.The_Config_Apt_Cntl_Block(1) + 16#00800000#;
      end if;
      if (An_Instance.Building_Location) then
         An_Instance.The_Config_Apt_Cntl_Block(1) :=
           An_Instance.The_Config_Apt_Cntl_Block(1) + 16#00400000#;
      end if;
      if (An_Instance.Reil_Lighting) then
         An_Instance.The_Config_Apt_Cntl_Block(1) :=
           An_Instance.The_Config_Apt_Cntl_Block(1) + 16#00200000#;
      end if;
      if (An_Instance.Civil_Rotating_Beacon) then
         An_Instance.The_Config_Apt_Cntl_Block(1) :=
           An_Instance.The_Config_Apt_Cntl_Block(1) + 16#00100000#;
      end if;
      An_Instance.The_Config_Apt_Cntl_Block(1) :=
        An_Instance.The_Config_Apt_Cntl_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Terrain_Type) *
        16#00010000#;
      An_Instance.The_Config_Apt_Cntl_Block(1) :=
        An_Instance.The_Config_Apt_Cntl_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Runway_Width) *
        16#00002000#;
      An_Instance.The_Config_Apt_Cntl_Block(1) :=
        An_Instance.The_Config_Apt_Cntl_Block(1) +
        Jpats_Visual_Buffer_Types.Unsigned_Int(An_Instance.Runway_Length) *
        16#00000100#;

-- Pack Word 2
      An_Instance.The_Config_Apt_Cntl_Block(2) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Primary_Runway_Position.latitude *
         Jpats_Visual_Buffer_Types.Bams_32bit));

-- Pack Word 3
      An_Instance.The_Config_Apt_Cntl_Block(3) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Primary_Runway_Position.Longitude *
         Jpats_Visual_Buffer_Types.Bams_32bit));

-- Pack Word 4
      An_Instance.The_Config_Apt_Cntl_Block(4) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Primary_Runway_Position.Altitude)) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Default_X_Offset)) and 16#0000ffff#;
      An_Instance.The_Config_Apt_Cntl_Block(4) :=
        An_Instance.The_Config_Apt_Cntl_Block(4) + Temp;

-- Pack Word 5
      An_Instance.The_Config_Apt_Cntl_Block(5) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Default_Y_Offset)) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Default_Runway_True_Hdg *
         Jpats_Visual_Buffer_Types.Bams_16bit)) and 16#0000ffff#;
      An_Instance.The_Config_Apt_Cntl_Block(5) :=
        An_Instance.The_Config_Apt_Cntl_Block(5) + Temp;

-- Pack Word 6
      An_Instance.The_Config_Apt_Cntl_Block(6) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Default_Runway_Gs_Angle *
         Jpats_Visual_Buffer_Types.Bams_16bit)) * 16#00010000#;
      Temp := Jpats_Visual_Buffer_Types.Unsigned_Int
        (Integer(An_Instance.Default_Runway_Mag_Hdg *
         Jpats_Visual_Buffer_Types.Bams_16bit)) and 16#0000ffff#;
      An_Instance.The_Config_Apt_Cntl_Block(6) :=
        An_Instance.The_Config_Apt_Cntl_Block(6) + Temp;

-- Pack Word 7
      An_Instance.The_Config_Apt_Cntl_Block(7) :=
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Approach_Path_Indicator) * 16#10000000#;
      An_Instance.The_Config_Apt_Cntl_Block(7) :=
        An_Instance.The_Config_Apt_Cntl_Block(7) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Approach_Light_System) * 16#01000000#;
      An_Instance.The_Config_Apt_Cntl_Block(7) :=
        An_Instance.The_Config_Apt_Cntl_Block(7) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Runway_Markings) * 16#00100000#;
      An_Instance.The_Config_Apt_Cntl_Block(7) :=
        An_Instance.The_Config_Apt_Cntl_Block(7) +
        Jpats_Visual_Buffer_Types.Unsigned_Int
        (An_Instance.Cultural_Lights) * 16#00010000#;

   end Pack;

   function Data_Word
     (An_Instance : in Instance)
      return Jpats_Visual_Buffer_Types.Block_Array is
   begin
      return An_Instance.The_Config_Apt_Cntl_Block;
   end Data_Word;


end Data_Block.Config_Apt_Cntl;
