-------------------------------------------------------------------------------
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Buffer_Types;
with Data_Block;
use type Jpats_Visual_Buffer_Types.Unsigned_Int;

package Data_Block.Celestial_Control_Return is


  type Instance is new Data_Block.Instance with private;

   function Sun_Azimuth (An_Instance : in Instance) return Float;
   procedure Set_Sun_Azimuth
     (An_Instance     : in out Instance;
      An_Sun_Azimuth  : in Float);
  
   function Sun_Elevation (An_Instance : in Instance) return Float;
   procedure Set_Sun_Elevation
     (An_Instance       : in out Instance;
      An_Sun_Elevation  : in Float);

   function Moon_Azimuth (An_Instance : in Instance) return Float;
   procedure Set_Moon_Azimuth
     (An_Instance     : in out Instance;
      An_Moon_Azimuth : in Float);
  
   function Moon_Elevation (An_Instance : in Instance) return Float;
   procedure Set_Moon_Elevation
     (An_Instance       : in out Instance;
      An_Moon_Elevation : in Float);

   function Moon_Phase (An_Instance : in Instance) return Integer;
   procedure Set_Moon_Phase
     (An_Instance   : in out Instance;
      An_Moon_Phase : in Integer);

   function Shadows_Enabled (An_Instance : in Instance) return Boolean;
   procedure Set_Shadows_Enabled
     (An_Instance        : in out Instance;
      An_Shadows_Enabled : in Boolean);

   function Shadows_Transitioning (An_Instance : in Instance) return Boolean;
   procedure Set_Shadows_Transitioning
     (An_Instance        : in out Instance;
      An_Shadows_Transitioning : in Boolean);

-- Data_Block Methods
   procedure Set_Data_Block
     (An_Instance : in out Instance;
      A_Block : in Jpats_Visual_Buffer_Types.Block_Array);
   procedure Initialize (An_Instance : in out Instance);
   procedure Unpack (An_Instance : in out Instance);


private

  type Instance is new Data_Block.Instance with record
     Sun_Azimuth                        : Float;
     Sun_Elevation                      : Float;
     Moon_Azimuth                       : Float;
     Moon_Elevation                     : Float;
     Moon_Phase                         : Integer;
     Shadows_Enabled                    : Boolean;
     Shadows_Transitioning              : Boolean;
     The_Celestial_Control_Return_Block : Jpats_Visual_Buffer_Types.Block_Array (1..4);
  end record;


end Data_Block.Celestial_Control_Return;
